/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.data.DataItemType;
import com.ibm.vipr.data.FormatKind;
import com.ibm.vipr.data.ITuple;
import com.ibm.vipr.info.IItemClassInfo;
import com.ibm.vipr.info.IItemClassSetInfo;
import com.ibm.vipr.info.IItemInfo;
import com.ibm.vipr.info.ITupleInfo;
import com.ibm.vipr.info.InfoType;
import com.ibm.vipr.internal.data.CatDataItem;
import com.ibm.vipr.internal.data.DataContext;
import com.ibm.vipr.internal.data.Item;
import com.ibm.vipr.internal.data.ItemClass;
import com.ibm.vipr.internal.data.ItemClassSet;
import com.ibm.vipr.internal.data.Slotted;
import com.ibm.vipr.internal.util.JoinUtil;
import com.ibm.vipr.renderingservice.api.IRSDataContext;
import com.ibm.vipr.renderingservice.data.IRSItem;
import com.ibm.vipr.renderingservice.data.IRSItemClass;
import com.ibm.vipr.renderingservice.data.IRSItemClassSet;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.data.IRSValue;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.vizdef.SlotRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class Tuple
extends Slotted<ITuple>
implements IRSTuple,
ITupleInfo {
    private static final String TUPLE_CAPTION_JOIN = " | ";
    private static final String KEY_JOIN = "\u00d7";
    public final int index;
    public final ItemClassSet itemClassSet;
    public final List<IRSItem> items;
    private String key;
    private String keyS;

    public static String joinKey(List<String> _parts) {
        return String.join((CharSequence)KEY_JOIN, _parts);
    }

    public Tuple(ITuple _source, Set<String> _decoFilter, SlotRef _slotRef, int _index, ItemClassSet _itemClassSet, List<IRSItem> _items) {
        super(_source, _decoFilter, _slotRef);
        this.index = _index;
        this.itemClassSet = _itemClassSet;
        this.items = Collections.unmodifiableList(_items);
    }

    public RSDataItemType getType() {
        return RSDataItemType.Cat;
    }

    public CatDataItem getDataItem(IRSDataContext _context) {
        return (CatDataItem)DataContext.getOwner(_context, this);
    }

    public IRSTuple asCat() {
        return this;
    }

    public IRSValue asCont() {
        return null;
    }

    public String getCaption(RSFormatKind _kind) {
        return JoinUtil.joinCaptions(this.items, _kind, TUPLE_CAPTION_JOIN);
    }

    @Override
    public String getSubType() {
        return null;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public IRSItemClassSet getItemClassSet() {
        return this.itemClassSet;
    }

    public List<IRSItemClass> getItemClasses() {
        return this.itemClassSet.getItemClasses();
    }

    public int getItemClassCount() {
        return this.itemClassSet != null ? this.itemClassSet.getItemClassCount() : 0;
    }

    public IRSItemClass getItemClass(int _index) {
        return this.itemClassSet != null ? this.itemClassSet.getItemClass(_index) : null;
    }

    public List<IRSItem> getItems() {
        return this.items;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public IRSItem getItem(int _index) {
        return _index >= 0 && _index < this.items.size() ? this.items.get(_index) : null;
    }

    public String getKey() {
        return this.getKey(true);
    }

    @Override
    public String getKey(boolean _sorted) {
        String key;
        String string = key = _sorted ? this.keyS : this.key;
        if (key == null) {
            ArrayList<String> parts = new ArrayList<String>();
            this.addKeyParts(parts);
            if (parts.size() < 1) {
                parts.add(Integer.toString(this.index));
            } else if (parts.size() > 1 && _sorted) {
                parts.sort((a, b) -> a.compareTo((String)b));
            }
            key = Tuple.joinKey(parts);
            if (_sorted) {
                this.keyS = key;
            } else {
                this.key = key;
            }
        }
        return key;
    }

    @Override
    public String getCaption(FormatKind _kind) {
        return this.getCaption(Tuple.toRS(_kind));
    }

    @Override
    public InfoType getInfoType() {
        return InfoType.Tuple;
    }

    @Override
    public DataItemType getDataItemInfoType() {
        return DataItemType.Cat;
    }

    @Override
    public IItemClassSetInfo getItemClassSetInfo() {
        return this.itemClassSet;
    }

    @Override
    public List<IItemClassInfo> getItemClassInfos() {
        return this.itemClassSet.getItemClassInfos();
    }

    @Override
    public List<IItemInfo> getItemInfos() {
        return Tuple.toInfo(this.items);
    }

    @Override
    public CatDataItem getDataItemInfo() {
        return (CatDataItem)DataContext.getOwner(DataContext.vipr, this);
    }

    void addKeyParts(List<String> _parts) {
        if (this.source != null) {
            for (IRSItem item : this.items) {
                _parts.add(item.getUniqueName());
            }
        }
    }

    protected List<IRSItem> cloneItems(Set<String> _decoFilter, ItemClassSet _itemClassSet) {
        int len = this.items.size();
        ArrayList<IRSItem> items = new ArrayList<IRSItem>(len);
        for (int i = 0; i < len; ++i) {
            items.add(((Item)this.items.get(i)).clone(_decoFilter, (ItemClass)_itemClassSet.itemClasses.get(i)));
        }
        return items;
    }

    void applyContext(DataContext _context, CatDataItem _dataItem) {
        if (_dataItem != null) {
            _context.setOwner(this, _dataItem);
        }
    }

    Tuple clone(Set<String> _decoFilter, ItemClassSet _itemClassSet) {
        return new Tuple((ITuple)this.source, _decoFilter, _itemClassSet.getSlotRef(), this.index, _itemClassSet, this.cloneItems(_decoFilter, _itemClassSet));
    }
}

