/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.VizServiceNotification;
import com.ibm.vipr.api.ICapability;
import com.ibm.vipr.api.IHostAPI;
import com.ibm.vipr.api.INls;
import com.ibm.vipr.data.ISlotMapping;
import com.ibm.vipr.data.IVIPRData;
import com.ibm.vipr.info.ICatDataItemInfo;
import com.ibm.vipr.info.IDataSetInfo;
import com.ibm.vipr.info.IVIPRDataInfo;
import com.ibm.vipr.info.InfoType;
import com.ibm.vipr.internal.data.DataContext;
import com.ibm.vipr.internal.data.DataObject;
import com.ibm.vipr.internal.data.DataSet;
import com.ibm.vipr.internal.data.SliceResult;
import com.ibm.vipr.internal.data.TruncationFactory;
import com.ibm.vipr.renderingservice.api.RSSeverity;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.data.IRenderingServiceData;
import com.ibm.vipr.truncation.TruncationInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class VIPRData
extends DataObject<IVIPRData>
implements IRenderingServiceData,
IVIPRDataInfo {
    private static final String TRUNCATE_ID = "truncate";
    private final Set<String> decoFilter;
    public final ISlotMapping mapping;
    public final List<IRSDataSet> dataSets;
    private final VIPRData slicedFrom;
    private int decoVer;
    private int sourceVer;

    public static boolean isSliced(VIPRData _viprData) {
        return _viprData == null || _viprData.slicedFrom != null;
    }

    VIPRData(IVIPRData _source, Set<String> _decoFilter, ISlotMapping _mapping, List<IRSDataSet> _dataSets, VIPRData _slicedFrom) {
        super(_source);
        this.decoFilter = _decoFilter;
        this.mapping = _mapping;
        this.dataSets = Collections.unmodifiableList(_dataSets);
        this.slicedFrom = _slicedFrom;
        this.decoVer = 0;
        this.sourceVer = -1;
    }

    public List<IRSDataSet> getDataSets() {
        return this.dataSets;
    }

    public IRSDataSet getDataSet(String _name) {
        for (IRSDataSet dataSet : this.dataSets) {
            if (!dataSet.getName().equals(_name)) continue;
            return dataSet;
        }
        return null;
    }

    public IRSDataSet getDataSetAt(int _index) {
        return this.dataSets.get(_index);
    }

    @Override
    public int getDecorationsVersion() {
        return this.decoVer;
    }

    @Override
    public InfoType getInfoType() {
        return InfoType.VIPRData;
    }

    @Override
    public ISlotMapping getMapping() {
        return this.mapping;
    }

    @Override
    public List<IDataSetInfo> getDataSetInfos() {
        return VIPRData.toInfo(this.dataSets);
    }

    @Override
    public IDataSetInfo getDataSetInfo(String _name) {
        return (IDataSetInfo)this.getDataSet(_name);
    }

    @Override
    public VIPRData empty() {
        int dataSetCount = this.dataSets.size();
        ArrayList<IRSDataSet> dataSets = new ArrayList<IRSDataSet>(dataSetCount);
        for (int i = 0; i < dataSetCount; ++i) {
            DataSet dataSet = (DataSet)this.dataSets.get(i);
            if (dataSet != null) {
                dataSet = dataSet.empty();
            }
            dataSets.add(dataSet);
        }
        return new VIPRData((IVIPRData)this.source, this.decoFilter, this.mapping, dataSets, this.slicedFrom);
    }

    @Override
    public void filterDecorations(Iterable<String> _decorations) {
        boolean changed;
        boolean bl = changed = this.decoFilter.size() > 0;
        if (changed) {
            this.decoFilter.clear();
        }
        if (_decorations != null) {
            for (String entry : _decorations) {
                if (entry == null) continue;
                this.decoFilter.add(entry);
            }
            if (!changed && this.decoFilter.size() > 0) {
                changed = true;
            }
        }
        if (changed) {
            ++this.decoVer;
            for (IRSDataSet dataSet : this.dataSets) {
                if (dataSet == null) continue;
                ((DataSet)dataSet).setDataPointDecorationsDirty();
            }
        }
    }

    int refreshDecorations() {
        if (this.slicedFrom != null) {
            this.decoVer = this.slicedFrom.refreshDecorations();
            this.sourceVer = this.slicedFrom.sourceVer;
        } else {
            int v;
            int n = v = this.source == null ? 0 : ((IVIPRData)this.source).getDecorationsVersion();
            if (v != this.sourceVer) {
                ++this.decoVer;
                this.sourceVer = v;
                for (IRSDataSet dataSet : this.dataSets) {
                    if (dataSet == null) continue;
                    ((DataSet)dataSet).setDataPointDecorationsDirty();
                }
            }
        }
        return this.decoVer;
    }

    SliceResult slice(List<String> _slotNames, List<ICapability> _capabilities, IHostAPI _hostApi, INls _nls) {
        ArrayList<ICatDataItemInfo> dataItems = new ArrayList<ICatDataItemInfo>();
        if (this.slicedFrom != null) {
            throw new RuntimeException("VIPRData is already processed");
        }
        int dataSetCount = this.dataSets.size();
        int sliceVolume = 1;
        ArrayList<List<DataSet>> slicedDataSets = new ArrayList<List<DataSet>>(dataSetCount);
        TruncationFactory truncationFactory = new TruncationFactory(_nls);
        for (IRSDataSet dataSet : this.dataSets) {
            if (dataSet == null) {
                slicedDataSets.add(null);
                continue;
            }
            List<DataSet> dataSetSlices = ((DataSet)dataSet).slice(_slotNames, dataItems, _capabilities, truncationFactory);
            if (dataSetSlices.size() > sliceVolume) {
                sliceVolume = dataSetSlices.size();
            }
            slicedDataSets.add(dataSetSlices);
        }
        ArrayList<IVIPRDataInfo> slices = new ArrayList<IVIPRDataInfo>(sliceVolume);
        for (int sliceOrdinal = 0; sliceOrdinal < sliceVolume; ++sliceOrdinal) {
            ArrayList<IRSDataSet> dataSets = new ArrayList<IRSDataSet>(dataSetCount);
            for (int iDataSet = 0; iDataSet < dataSetCount; ++iDataSet) {
                List dataSetSlices;
                dataSets.add((IRSDataSet)dataSetSlices.get((dataSetSlices = (List)slicedDataSets.get(iDataSet)).size() == 1 ? 0 : sliceOrdinal));
            }
            slices.add(new VIPRData((IVIPRData)this.source, this.decoFilter, this.mapping, dataSets, this));
        }
        TruncationInfo truncationInfo = truncationFactory.create();
        if (truncationInfo != null && _hostApi != null) {
            _hostApi.notify(new VizServiceNotification(RSSeverity.Warning.value(), TRUNCATE_ID, truncationInfo.message, truncationInfo));
        }
        return new SliceResult(dataItems, slices);
    }

    VIPRData initDataContext(DataContext _context) {
        if (_context == null) {
            throw new NullPointerException("_context cannot be null");
        }
        for (IRSDataSet rsDataSet : this.dataSets) {
            if (rsDataSet == null) continue;
            ((DataSet)rsDataSet).applyContext(_context, this);
        }
        return this;
    }
}

