/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.data.IDataSet;
import com.ibm.vipr.data.IDataSetMapping;
import com.ibm.vipr.data.ISlotMapping;
import com.ibm.vipr.data.IVIPRData;
import com.ibm.vipr.internal.data.DataSet;
import com.ibm.vipr.internal.data.DataSetFactory;
import com.ibm.vipr.internal.data.VIPRData;
import com.ibm.vipr.internal.util.VIPRNls;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.vizdef.DataSetDef;
import com.ibm.vipr.vizdef.VizDef;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class VIPRDataFactory {
    private static final DataSetFactory dataSetFactory = new DataSetFactory();

    public VIPRData process(IVIPRData _iViprData, ISlotMapping _slotMapping, VizDef _hostVizDef, VizDef _vizDef, VIPRNls _nls) {
        List<DataSetDef> vizDataSets = _vizDef.source != null ? _vizDef.source.dataSets : _vizDef.dataSets;
        ArrayList<IRSDataSet> dataSets = new ArrayList<IRSDataSet>(vizDataSets.size());
        HashSet<String> decorationsFilter = new HashSet<String>();
        for (DataSetDef dataSetDef : vizDataSets) {
            DataSetDef hostDataSetDef = _hostVizDef.getDataSet(dataSetDef.name);
            IDataSet dataSetSource = null;
            if (hostDataSetDef != null) {
                dataSetSource = _iViprData.getDataSetAt(hostDataSetDef.index);
            }
            DataSet dataSet = null;
            if (dataSetSource != null) {
                IDataSetMapping mapping = null;
                if (_slotMapping != null) {
                    mapping = _slotMapping.getDataSetMapping(hostDataSetDef.index);
                }
                dataSet = dataSetFactory.process(hostDataSetDef, dataSetDef, dataSetSource, mapping, decorationsFilter, _nls);
            }
            if (dataSet == null && !dataSetDef.optional) {
                throw new Error("DataSet " + dataSetDef.name + " cannot be null, it is not optional.");
            }
            dataSets.add(dataSet);
        }
        return new VIPRData(_iViprData, decorationsFilter, _slotMapping, dataSets, null);
    }
}

