/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.data.DataItemType;
import com.ibm.vipr.data.FormatKind;
import com.ibm.vipr.data.IValue;
import com.ibm.vipr.data.ValueType;
import com.ibm.vipr.info.IContDataItemInfo;
import com.ibm.vipr.info.IValueInfo;
import com.ibm.vipr.info.InfoType;
import com.ibm.vipr.internal.data.ContDataItem;
import com.ibm.vipr.internal.data.DataContext;
import com.ibm.vipr.internal.data.Slotted;
import com.ibm.vipr.internal.util.JoinUtil;
import com.ibm.vipr.renderingservice.api.IRSDataContext;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.data.IRSValue;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.renderingservice.data.RSValueType;
import com.ibm.vipr.vizdef.SlotRef;
import java.util.Set;

class Value
extends Slotted<IValue>
implements IRSValue,
IValueInfo {
    public final RSValueType valueType;

    private static RSValueType toValueType(ValueType _valueType) {
        if (_valueType == null) {
            return RSValueType.Missing;
        }
        switch (_valueType) {
            case Missing: {
                return RSValueType.Missing;
            }
            case Numeric: {
                return RSValueType.Numeric;
            }
        }
        throw new Error("Unhandled ValueType");
    }

    public Value(IValue _source, Set<String> _decoFilter, SlotRef _slotRef, ContDataItem _dataItem) {
        super(_source, _decoFilter, _slotRef);
        this.valueType = Value.toValueType(_source == null ? null : _source.getValueType());
        DataContext.vipr.setReference(this, _dataItem);
    }

    @Override
    public InfoType getInfoType() {
        return InfoType.Value;
    }

    public RSDataItemType getType() {
        return RSDataItemType.Cont;
    }

    public IRSTuple asCat() {
        return null;
    }

    public IRSValue asCont() {
        return this;
    }

    public RSValueType getValueType() {
        return this.valueType;
    }

    @Override
    public Object getValue() {
        return this.valueType == RSValueType.Missing ? null : ((IValue)this.source).getValue();
    }

    public ContDataItem getDataItem(IRSDataContext _context) {
        return (ContDataItem)DataContext.getReference(_context, this);
    }

    public String getCaption(RSFormatKind _kind) {
        return this.getCaption(Value.fromRS(_kind));
    }

    @Override
    public String getCaption(FormatKind _kind) {
        FormatKind.validate(_kind);
        if (this.source != null) {
            return JoinUtil.normalize(((IValue)this.source).getCaption(_kind));
        }
        return this.getDataItem(DataContext.vipr).missingCaption(Value.toRS(_kind));
    }

    @Override
    public DataItemType getDataItemInfoType() {
        return DataItemType.Cont;
    }

    @Override
    public ValueType getValueInfoType() {
        switch (this.valueType) {
            case Missing: {
                return ValueType.Missing;
            }
            case Numeric: {
                return ValueType.Numeric;
            }
        }
        throw new Error("Unhandled ValueType");
    }

    @Override
    public IContDataItemInfo getDataItemInfo() {
        return this.getDataItem(DataContext.vipr);
    }

    Value clone(Set<String> _decoFilter, ContDataItem _dataItem) {
        return new Value((IValue)this.source, _decoFilter, _dataItem.getSlotRef(), _dataItem);
    }

    void applyContext(DataContext _context, ContDataItem _dataItem) {
        if (_context != DataContext.vipr) {
            _context.setReference(this, _dataItem);
        }
    }
}

