/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.manifest;

import com.ibm.vipr.internal.manifest.InvalidManifestException;
import com.ibm.vipr.internal.manifest.ServiceDescription;
import com.ibm.vipr.internal.util.XmlParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Manifest {
    public static final String ERROR_MISSING_SERVICE_DEFINITION = "Missing service definition in manifest";
    public static final String ERROR_MISSING_SERVICE_BINDINGS = "Manifest has no service bindings";
    private static final Pattern reService = Pattern.compile("^service$", 2);
    private final Map<String, String> properties;
    private final List<ServiceDescription> services;

    public static Manifest fromXml(Document _doc) throws InvalidManifestException {
        if (_doc == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        ArrayList<ServiceDescription> services = new ArrayList<ServiceDescription>();
        Element root = _doc.getDocumentElement();
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String tagName = node.getNodeName().toLowerCase();
            if (tagName.startsWith("bundle-") || tagName.equals("servicedefinition")) {
                properties.put(tagName, XmlParser.getTextContent(node).trim());
                continue;
            }
            if (!tagName.equals("servicebindings")) continue;
            List<Node> nodes = XmlParser.filterChildElementsByTag(node, reService);
            Iterator<Node> it = nodes.iterator();
            while (it.hasNext()) {
                services.add(ServiceDescription.fromXml(it.next()));
            }
        }
        if (properties.getOrDefault("servicedefinition", "").equals("")) {
            throw new InvalidManifestException(ERROR_MISSING_SERVICE_DEFINITION);
        }
        if (services.size() == 0) {
            throw new InvalidManifestException(ERROR_MISSING_SERVICE_BINDINGS);
        }
        return new Manifest(properties, services);
    }

    public final String getName() {
        return this.properties.getOrDefault("bundle-name", "");
    }

    public final String getType() {
        return this.properties.getOrDefault("bundle-type", "");
    }

    public final String getSymbolicName() {
        return this.properties.getOrDefault("bundle-symbolicname", "");
    }

    public final String getManifestVersion() {
        return this.properties.getOrDefault("bundle-manifestversion", "");
    }

    public final String getVersion() {
        return this.properties.getOrDefault("bundle-version", "");
    }

    public final String getPropertyApi() {
        return this.properties.getOrDefault("bundle-propertyapi", "");
    }

    public final String getNls() {
        return this.properties.getOrDefault("bundle-nls", "");
    }

    public final String getPreload() {
        return this.properties.getOrDefault("bundle-preload", "");
    }

    public final String getServiceDefinition() {
        return this.properties.getOrDefault("servicedefinition", "");
    }

    public String getProperty(String _name) {
        return this.properties.get(_name.toLowerCase());
    }

    public ServiceDescription getServiceDescription(String _type, String _lang) {
        int len = this.services.size();
        for (int i = 0; i < len; ++i) {
            ServiceDescription service = this.services.get(i);
            if (!service.getLang().equalsIgnoreCase(_lang) || !service.hasType(_type)) continue;
            return service;
        }
        return null;
    }

    Manifest(Map<String, String> _properties, List<ServiceDescription> _services) {
        this.properties = Collections.unmodifiableMap(_properties);
        this.services = Collections.unmodifiableList(_services);
    }
}

