/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.manifest;

import com.ibm.vipr.internal.manifest.Dependency;
import com.ibm.vipr.internal.manifest.InvalidManifestException;
import com.ibm.vipr.internal.util.XmlParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class ServiceDescription {
    public static final String ERROR_NODE_NULL = "Node cannot be null";
    public static final String ERROR_MISSING_FORMAT = "Service 'format' attribute missing or empty";
    public static final String ERROR_MISSING_CLASS = "Service 'class' attribute missing or empty";
    public static final String ERROR_CLASS_INVALID = "Class attribute is invalid";
    public static final String ERROR_MISSING_LANG = "Service 'lang' attribute missing or empty";
    private static final Pattern reDepencency = Pattern.compile("^dependency$", 2);
    private final List<String> formats;
    private final String lang;
    private final String classPath;
    private final List<Dependency> dependencies;

    static ServiceDescription fromXml(Node _node) throws InvalidManifestException {
        if (_node == null) {
            throw new IllegalArgumentException(ERROR_NODE_NULL);
        }
        List<String> formats = XmlParser.commaSeparatedAttr(_node, "format", null);
        String lang = XmlParser.stringAttr(_node, "lang", null);
        String cls = XmlParser.stringAttr(_node, "class", null);
        if (formats == null || formats.isEmpty()) {
            throw new InvalidManifestException(ERROR_MISSING_FORMAT);
        }
        if (cls == null || cls.length() == 0) {
            throw new InvalidManifestException(ERROR_MISSING_CLASS);
        }
        if (lang == null || lang.length() == 0) {
            throw new InvalidManifestException(ERROR_MISSING_LANG);
        }
        if (cls.split("/", 2).length != 2) {
            throw new InvalidManifestException(ERROR_CLASS_INVALID);
        }
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        List<Node> depNodes = XmlParser.filterChildElementsByTag(_node, reDepencency);
        Iterator<Node> it = depNodes.iterator();
        while (it.hasNext()) {
            deps.add(Dependency.fromXml(it.next()));
        }
        return new ServiceDescription(formats, lang, cls, deps);
    }

    public List<String> getFormats() {
        return this.formats;
    }

    public String getLang() {
        return this.lang;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public boolean hasType(String _type) {
        return this.formats.contains(_type);
    }

    private ServiceDescription(List<String> _formats, String _lang, String _classPath, List<Dependency> _dependencies) {
        this.formats = Collections.unmodifiableList(_formats);
        this.lang = _lang;
        this.classPath = _classPath;
        this.dependencies = Collections.unmodifiableList(_dependencies);
    }
}

