/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.property;

import com.ibm.vipr.event.IEventListener;
import com.ibm.vipr.internal.property.Property;
import com.ibm.vipr.property.IVizGroupProperty;
import com.ibm.vipr.property.IVizProperty;
import com.ibm.vipr.property.PropertyActiveEventArgs;
import com.ibm.vipr.renderingservice.property.IRSProperty;
import com.ibm.vipr.vizdef.GroupPropertyDef;
import com.ibm.vipr.vizdef.PropertyDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class GroupProperty
extends Property<GroupPropertyDef> {
    public final List<Property<?>> properties;
    private final VizGroupProperty vizGroup;

    private boolean determineActive() {
        boolean active = false;
        int len = this.properties.size();
        for (int i = 0; i < len && !active; ++i) {
            active = this.properties.get(i).isActive();
        }
        return active;
    }

    public GroupProperty(GroupPropertyDef _def, List<Property<?>> _properties) {
        super(_def, false);
        ArrayList<IVizProperty> vizProperties = new ArrayList<IVizProperty>(_properties.size());
        for (Property<?> prop : _properties) {
            vizProperties.add(prop.toHost());
        }
        this.vizGroup = new VizGroupProperty(_def, Collections.unmodifiableList(vizProperties));
        this.properties = Collections.unmodifiableList(_properties);
        this.setActive(this.determineActive());
        IEventListener valueListener = (_args, _sender) -> this.emit("value", _args);
        IEventListener activeListener = (_args, _sender) -> {
            this.emit("active", _args);
            boolean propertyActive = ((PropertyActiveEventArgs)_args).property.isActive();
            if (this.isActive() != propertyActive) {
                this.setActive(propertyActive || this.determineActive());
            }
        };
        for (Property<?> prop : this.properties) {
            prop.on("value", valueListener);
            prop.on("active", activeListener);
        }
    }

    @Override
    public IVizGroupProperty toHost() {
        return this.vizGroup;
    }

    @Override
    IRSProperty toRS() {
        return null;
    }

    private class VizGroupProperty
    extends Property.VizProperty
    implements IVizGroupProperty {
        private final List<IVizProperty> properties;

        public VizGroupProperty(GroupPropertyDef _def, List<IVizProperty> _properties) {
            super((Property)GroupProperty.this, (PropertyDef)_def);
            this.properties = _properties;
        }

        @Override
        public List<IVizProperty> getProperties() {
            return this.properties;
        }
    }
}

