/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.property;

import com.ibm.vipr.api.IPaletteResolver;
import com.ibm.vipr.api.PaletteType;
import com.ibm.vipr.internal.property.IToRSValueFunction;
import com.ibm.vipr.internal.property.ValueProperty;
import com.ibm.vipr.internal.property.palette.CatPaletteProxy;
import com.ibm.vipr.internal.property.palette.ContPaletteProxy;
import com.ibm.vipr.internal.property.palette.CustomCatPaletteProxy;
import com.ibm.vipr.internal.property.palette.CustomContPaletteProxy;
import com.ibm.vipr.property.IVizPaletteProperty;
import com.ibm.vipr.renderingservice.api.ICustomData;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSContStops;
import com.ibm.vipr.renderingservice.api.IRSDataContext;
import com.ibm.vipr.renderingservice.api.IRSPalette;
import com.ibm.vipr.renderingservice.data.IRSContDataItem;
import com.ibm.vipr.renderingservice.data.IRSContDomain;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.property.IPropertyParser;
import com.ibm.vipr.renderingservice.property.IRSCatPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSContPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSCustomCatPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSCustomContPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSPaletteProperty;
import com.ibm.vipr.vizdef.PalettePropertyDef;
import com.ibm.vipr.vizdef.ValuePropertyDef;

public class PaletteProperty
extends ValueProperty<PalettePropertyDef, IPaletteResolver, IRSPalette> {
    private final IRSPaletteProperty rs;
    private final IVizPaletteProperty host;

    private static final IToRSValueFunction<IPaletteResolver, IRSPalette> getRSValueFunc(final PalettePropertyDef _def, final IRSDataContext _dataContext) {
        return new IToRSValueFunction<IPaletteResolver, IRSPalette>(){

            @Override
            public IRSPalette toRSValue(IPaletteResolver _value) {
                if (_value == null) {
                    return null;
                }
                switch (_def.type) {
                    case Cat: {
                        return new CatPaletteProxy(_dataContext, _value);
                    }
                    case Cont: {
                        return new ContPaletteProxy(_dataContext, _value);
                    }
                    case CustomCat: {
                        return new CustomCatPaletteProxy(_dataContext, _value);
                    }
                    case CustomCont: {
                        return new CustomContPaletteProxy(_dataContext, _value);
                    }
                }
                throw new Error("Unknown palette type");
            }
        };
    }

    public PaletteProperty(PalettePropertyDef _def, boolean _forRS, IPropertyParser<?> _parser, IRSDataContext _dataContext) {
        super(_def, _forRS, _parser, PaletteProperty.getRSValueFunc(_def, _dataContext));
        RSPaletteProperty rsPalProp = null;
        switch (_def.type) {
            case Cat: {
                rsPalProp = new RSCatPaletteProperty(this);
                break;
            }
            case Cont: {
                rsPalProp = new RSContPaletteProperty(this);
                break;
            }
            case CustomCat: {
                rsPalProp = new RSCustomCatPaletteProperty(this);
                break;
            }
            case CustomCont: {
                rsPalProp = new RSCustomContPaletteProperty(this);
                break;
            }
            default: {
                throw new Error("Unsupported palette type: " + (Object)((Object)_def.type));
            }
        }
        this.rs = rsPalProp;
        this.host = new VizPaletteProperty(_def);
    }

    IRSPaletteProperty toRS() {
        return this.rs;
    }

    @Override
    IVizPaletteProperty toHost() {
        return this.host;
    }

    protected class VizPaletteProperty
    extends ValueProperty.VizValueProperty
    implements IVizPaletteProperty {
        public VizPaletteProperty(PalettePropertyDef _def) {
            super((ValueProperty)PaletteProperty.this, (ValuePropertyDef)_def);
        }

        @Override
        public PaletteType getPaletteType() {
            return ((PalettePropertyDef)this.def).type;
        }

        @Override
        public String getSlot() {
            return ((PalettePropertyDef)this.def).slot.name;
        }
    }

    protected class RSCustomContPaletteProperty
    extends RSPaletteProperty
    implements IRSCustomContPaletteProperty {
        RSCustomContPaletteProperty(PaletteProperty _ref) {
            super(_ref);
        }

        public IRSContStops getColorStops(IRSContDomain _domain) {
            return ((CustomContPaletteProxy)this.ref.toRS().getValue()).getColorStops(_domain);
        }
    }

    protected class RSCustomCatPaletteProperty
    extends RSPaletteProperty
    implements IRSCustomCatPaletteProperty {
        RSCustomCatPaletteProperty(PaletteProperty _ref) {
            super(_ref);
        }

        public IRSColor getColor(int _index, int _count, ICustomData _customData) {
            return ((CustomCatPaletteProxy)this.ref.toRS().getValue()).getColor(_index, _count, _customData);
        }
    }

    protected class RSContPaletteProperty
    extends RSPaletteProperty
    implements IRSContPaletteProperty {
        RSContPaletteProperty(PaletteProperty _ref) {
            super(_ref);
        }

        public IRSContStops getColorStops(IRSContDataItem _dataItem) {
            return ((ContPaletteProxy)this.ref.toRS().getValue()).getColorStops(_dataItem);
        }

        public IRSContStops getColorStops(IRSContDataItem _dataItem, IRSContDomain _domain) {
            return ((ContPaletteProxy)this.ref.toRS().getValue()).getColorStops(_dataItem, _domain);
        }
    }

    protected class RSCatPaletteProperty
    extends RSPaletteProperty
    implements IRSCatPaletteProperty {
        RSCatPaletteProperty(PaletteProperty _ref) {
            super(_ref);
        }

        public IRSColor getColor(IRSTuple _tuple) {
            return ((CatPaletteProxy)this.ref.toRS().getValue()).getColor(_tuple);
        }

        public IRSColor getColor(IRSTuple _tuple, int _level) {
            return ((CatPaletteProxy)this.ref.toRS().getValue()).getColor(_tuple, _level);
        }
    }

    protected class RSPaletteProperty
    extends ValueProperty.RSValueProperty
    implements IRSPaletteProperty {
        protected PaletteProperty ref;
        protected PalettePropertyDef def;

        RSPaletteProperty(PaletteProperty _ref) {
            this.ref = _ref;
            this.def = (PalettePropertyDef)this.ref.def;
        }

        public com.ibm.vipr.renderingservice.api.PaletteType getPaletteType() {
            switch (this.def.type) {
                case Cat: {
                    return com.ibm.vipr.renderingservice.api.PaletteType.Cat;
                }
                case Cont: {
                    return com.ibm.vipr.renderingservice.api.PaletteType.Cont;
                }
                case CustomCat: {
                    return com.ibm.vipr.renderingservice.api.PaletteType.CustomCat;
                }
                case CustomCont: {
                    return com.ibm.vipr.renderingservice.api.PaletteType.CustomCont;
                }
            }
            throw new Error("Unknown palette type " + (Object)((Object)this.def.type));
        }

        public String getSlot() {
            return this.def.slot != null ? this.def.slot.name : null;
        }
    }
}

