/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.property;

import com.ibm.vipr.api.IVizEnumProperty;
import com.ibm.vipr.api.PaletteType;
import com.ibm.vipr.event.Evented;
import com.ibm.vipr.event.IEventListener;
import com.ibm.vipr.internal.property.BooleanProperty;
import com.ibm.vipr.internal.property.ColorProperty;
import com.ibm.vipr.internal.property.EnumProperty;
import com.ibm.vipr.internal.property.FontProperty;
import com.ibm.vipr.internal.property.GroupProperty;
import com.ibm.vipr.internal.property.LengthProperty;
import com.ibm.vipr.internal.property.NumberProperty;
import com.ibm.vipr.internal.property.PaletteProperty;
import com.ibm.vipr.internal.property.Property;
import com.ibm.vipr.internal.property.PropertyApi;
import com.ibm.vipr.internal.property.StringProperty;
import com.ibm.vipr.internal.property.ValueProperty;
import com.ibm.vipr.property.IVizBooleanProperty;
import com.ibm.vipr.property.IVizColorProperty;
import com.ibm.vipr.property.IVizGroupProperty;
import com.ibm.vipr.property.IVizNumberProperty;
import com.ibm.vipr.property.IVizPaletteProperty;
import com.ibm.vipr.property.IVizProperties;
import com.ibm.vipr.property.IVizProperty;
import com.ibm.vipr.property.IVizStringProperty;
import com.ibm.vipr.property.IVizValueProperty;
import com.ibm.vipr.property.PropertyType;
import com.ibm.vipr.property.PropertyVisibility;
import com.ibm.vipr.renderingservice.api.IRSDataContext;
import com.ibm.vipr.renderingservice.property.IDeprecatedProperty;
import com.ibm.vipr.renderingservice.property.IPropertyParser;
import com.ibm.vipr.renderingservice.property.IRSBooleanProperty;
import com.ibm.vipr.renderingservice.property.IRSCatPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSColorProperty;
import com.ibm.vipr.renderingservice.property.IRSContPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSCustomCatPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSCustomContPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSEnumProperty;
import com.ibm.vipr.renderingservice.property.IRSFontProperty;
import com.ibm.vipr.renderingservice.property.IRSLengthProperty;
import com.ibm.vipr.renderingservice.property.IRSNumberProperty;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.property.IRSStringProperty;
import com.ibm.vipr.renderingservice.property.IRSValueProperty;
import com.ibm.vipr.vizdef.BooleanPropertyDef;
import com.ibm.vipr.vizdef.ColorPropertyDef;
import com.ibm.vipr.vizdef.EnumPropertyDef;
import com.ibm.vipr.vizdef.FontPropertyDef;
import com.ibm.vipr.vizdef.GroupPropertyDef;
import com.ibm.vipr.vizdef.LengthPropertyDef;
import com.ibm.vipr.vizdef.NumberPropertyDef;
import com.ibm.vipr.vizdef.PalettePropertyDef;
import com.ibm.vipr.vizdef.PropertyDef;
import com.ibm.vipr.vizdef.StringPropertyDef;
import com.ibm.vipr.vizdef.ValuePropertyDef;
import com.ibm.vipr.vizdef.VizDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Properties
extends Evented {
    private final Map<String, Property<?>> map = new HashMap();
    private final List<ValueProperty<?, ?, ?>> values = new ArrayList();
    private final List<ValueProperty<?, ?, ?>> listed = new ArrayList();
    private final List<IVizProperty> tree = new ArrayList<IVizProperty>();
    private final List<IVizValueProperty<?>> excluded = new ArrayList();
    private final List<IVizValueProperty<?>> configuration = new ArrayList();
    private final List<IRSValueProperty<?>> rsProps = new ArrayList();
    private final VizProperties vizPropertiesImpl = new VizProperties(Collections.unmodifiableList(this.tree), Collections.unmodifiableList(this.configuration), Collections.unmodifiableList(this.excluded));
    private final RSProperties rsPropertiesImpl = new RSProperties(Collections.unmodifiableList(this.rsProps));

    private static ValueProperty<?, ?, ?> createValueProperty(ValuePropertyDef<?> _def, boolean _forRS, IPropertyParser<?> _parser, IRSDataContext _dataContext) {
        ValueProperty valueProp = null;
        switch (_def.type) {
            case Boolean: {
                valueProp = new BooleanProperty((BooleanPropertyDef)_def, _forRS, _parser);
                break;
            }
            case Color: {
                valueProp = new ColorProperty((ColorPropertyDef)_def, _forRS, _parser);
                break;
            }
            case Enum: {
                valueProp = new EnumProperty((EnumPropertyDef)_def, _forRS, _parser);
                break;
            }
            case Font: {
                valueProp = new FontProperty((FontPropertyDef)_def, _forRS, _parser);
                break;
            }
            case Length: {
                valueProp = new LengthProperty((LengthPropertyDef)_def, _forRS, _parser);
                break;
            }
            case Number: {
                valueProp = new NumberProperty((NumberPropertyDef)_def, _forRS, _parser);
                break;
            }
            case Palette: {
                valueProp = new PaletteProperty((PalettePropertyDef)_def, _forRS, _parser, _dataContext);
                break;
            }
            case String: {
                valueProp = new StringProperty((StringPropertyDef)_def, _forRS, _parser);
                break;
            }
            default: {
                throw new Error("Unhandled PropertyType: " + (Object)((Object)_def.type));
            }
        }
        return valueProp;
    }

    private static void createProperties(Properties _target, List<? extends PropertyDef> _nodes, PropertyApi _propertyApi, Function<PropertyDef, Boolean> _forRS, List<Property<?>> _parentProperties, IEventListener _valueListener, IEventListener _activeListener, IRSDataContext _dataContext) {
        for (PropertyDef propertyDef : _nodes) {
            Property prop;
            boolean listed;
            boolean bl = listed = propertyDef.visibility == PropertyVisibility.Listed;
            if (propertyDef.type == PropertyType.Group) {
                List<PropertyDef> defs = ((GroupPropertyDef)propertyDef).properties;
                ArrayList children = new ArrayList(defs.size());
                Properties.createProperties(_target, defs, _propertyApi, _forRS, children, _valueListener, _activeListener, _dataContext);
                prop = new GroupProperty((GroupPropertyDef)propertyDef, children);
                if (listed && _parentProperties == null) {
                    prop.on("value", _valueListener);
                    prop.on("active", _activeListener);
                }
            } else {
                ValueProperty<?, ?, ?> valueProp = Properties.createValueProperty((ValuePropertyDef)propertyDef, _forRS.apply(propertyDef), _propertyApi.parser(propertyDef.name), _dataContext);
                prop = valueProp;
                _target.values.add(valueProp);
                if (listed) {
                    _target.listed.add(valueProp);
                } else if (propertyDef.visibility == PropertyVisibility.Configuration) {
                    _target.configuration.add((IVizValueProperty<?>)valueProp.toHost());
                } else if (propertyDef.visibility == PropertyVisibility.Excluded) {
                    _target.excluded.add((IVizValueProperty<?>)valueProp.toHost());
                }
                if (prop.forRS) {
                    _target.rsProps.add(valueProp.toRS());
                }
                if (!listed || _parentProperties == null) {
                    valueProp.on("value", _valueListener);
                    valueProp.on("active", _activeListener);
                }
            }
            _target.map.put(propertyDef.name, prop);
            for (String alias : propertyDef.aliases) {
                _target.map.put(alias, prop);
            }
            if (listed && _parentProperties == null) {
                _target.tree.add(prop.toHost());
            }
            if (_parentProperties == null || propertyDef.visibility == PropertyVisibility.Excluded) continue;
            _parentProperties.add(prop);
        }
    }

    private Properties() {
    }

    public static Properties create(VizDef _vizDef, VizDef _hostVizDef, PropertyApi _propertyApi, IRSDataContext _dataContext) {
        if (_vizDef == null || _hostVizDef == null) {
            throw new IllegalArgumentException("_vizDef and _hostVizDef cannot be null");
        }
        if (_propertyApi == null) {
            throw new IllegalArgumentException("_propertyApi cannot be null");
        }
        Properties result = new Properties();
        IEventListener valueListener = (_args, _sender) -> result.emit("value", _args);
        IEventListener activeListener = (_args, _sender) -> result.emit("active", _args);
        Function<PropertyDef, Boolean> forRS = _def -> _vizDef.getProperty(_def.name) != null;
        Properties.createProperties(result, _hostVizDef.properties, _propertyApi, forRS, null, valueListener, activeListener, _dataContext);
        Properties.createProperties(result, _hostVizDef.configuration, _propertyApi, forRS, null, valueListener, activeListener, _dataContext);
        for (ValueProperty<?, ?, ?> valueProp : result.values) {
            if (!((ValuePropertyDef)valueProp.def).deprecated) continue;
            valueProp.initDeprecated(result.map, result.toRS(), _propertyApi.deprecated(((ValuePropertyDef)valueProp.def).name));
        }
        return result;
    }

    public IVizProperties toHost() {
        return this.vizPropertiesImpl;
    }

    public IRSProperties toRS() {
        return this.rsPropertiesImpl;
    }

    public boolean rsDirty() {
        boolean dirty = false;
        int len = this.rsProps.size();
        for (int i = 0; i < len && !dirty; ++i) {
            dirty = this.rsProps.get(i).isDirty();
        }
        return dirty;
    }

    public void lock() {
        for (ValueProperty<?, ?, ?> prop : this.values) {
            prop.lock();
        }
    }

    public void unlock(boolean _success) {
        for (ValueProperty<?, ?, ?> prop : this.values) {
            prop.unlock(_success);
        }
    }

    private final class RSProperties
    implements IRSProperties {
        private final List<IRSValueProperty<?>> rsProps;

        public RSProperties(List<IRSValueProperty<?>> _rsProps) {
            this.rsProps = _rsProps;
        }

        public IRSValueProperty<?> get(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node != null && node.forRS ? (IRSValueProperty)node.toRS() : null;
        }

        public Iterator<IRSValueProperty<?>> iterator() {
            return this.rsProps.iterator();
        }

        public IRSBooleanProperty getBoolean(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof BooleanProperty ? ((BooleanProperty)node).toRS() : null;
        }

        public IRSColorProperty getColor(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof ColorProperty ? ((ColorProperty)node).toRS() : null;
        }

        public IRSEnumProperty getEnum(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof EnumProperty ? ((EnumProperty)node).toRS() : null;
        }

        public IRSFontProperty getFont(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof FontProperty ? ((FontProperty)node).toRS() : null;
        }

        public IRSLengthProperty getLength(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof LengthProperty ? ((LengthProperty)node).toRS() : null;
        }

        public IRSNumberProperty getNumber(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof NumberProperty ? ((NumberProperty)node).toRS() : null;
        }

        public IRSStringProperty getString(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof StringProperty ? ((StringProperty)node).toRS() : null;
        }

        public IRSCatPaletteProperty getCatPalette(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof PaletteProperty && ((PalettePropertyDef)node.def).type == PaletteType.Cat ? (IRSCatPaletteProperty)((PaletteProperty)node).toRS() : null;
        }

        public IRSContPaletteProperty getContPalette(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof PaletteProperty && ((PalettePropertyDef)node.def).type == PaletteType.Cont ? (IRSContPaletteProperty)((PaletteProperty)node).toRS() : null;
        }

        public IRSCustomCatPaletteProperty getCustomCatPalette(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof PaletteProperty && ((PalettePropertyDef)node.def).type == PaletteType.CustomCat ? (IRSCustomCatPaletteProperty)((PaletteProperty)node).toRS() : null;
        }

        public IRSCustomContPaletteProperty getCustomContPalette(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof PaletteProperty && ((PalettePropertyDef)node.def).type == PaletteType.CustomCont ? (IRSCustomContPaletteProperty)((PaletteProperty)node).toRS() : null;
        }
    }

    private final class VizProperties
    implements IVizProperties {
        private final List<IVizProperty> tree;
        private final List<IVizValueProperty<?>> configuration;
        private final List<IVizValueProperty<?>> excluded;

        public VizProperties(List<IVizProperty> _tree, List<IVizValueProperty<?>> _configuration, List<IVizValueProperty<?>> _excluded) {
            this.tree = _tree;
            this.configuration = _configuration;
            this.excluded = _excluded;
        }

        @Override
        public List<IVizProperty> tree() {
            return this.tree;
        }

        @Override
        public List<IVizValueProperty<?>> configuration() {
            return this.configuration;
        }

        @Override
        public List<IVizValueProperty<?>> excluded() {
            return this.excluded;
        }

        @Override
        public boolean has(String _name) {
            return Properties.this.map.containsKey(_name);
        }

        @Override
        public IVizProperty get(String _name) {
            return ((Property)Properties.this.map.get(_name)).toHost();
        }

        @Override
        public void set(String _name, Object _value) {
            Property node = (Property)Properties.this.map.get(_name);
            if (node instanceof ValueProperty) {
                ((ValueProperty)node).setValue(_value);
            }
        }

        @Override
        public IRSValueProperty<?> initHostProperty(String _name, IPropertyParser<?> _parser, IDeprecatedProperty<?> _deprecated) {
            Properties source = Properties.this;
            Property node = (Property)source.map.get(_name);
            if (!(node instanceof ValueProperty)) {
                throw new Error("Cannot initialize " + _name);
            }
            ValueProperty prop = (ValueProperty)node;
            if (((ValuePropertyDef)prop.def).deprecated) {
                prop.initDeprecated(source.map, source.rsPropertiesImpl, _deprecated);
            } else if (_deprecated != null) {
                throw new Error("Deprecated handler passed for non deprecated property " + _name);
            }
            return prop.initHost(_parser);
        }

        @Override
        public Evented.Handle on(String _name, IEventListener _listener) {
            return Properties.this.on(_name, (_args, _sender) -> _listener.handle(_args, this));
        }

        @Override
        public Iterator<IVizValueProperty<?>> iterator() {
            final Iterator it = Properties.this.listed.iterator();
            return new Iterator<IVizValueProperty<?>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public IVizValueProperty<?> next() {
                    return ((ValueProperty)it.next()).toHost();
                }
            };
        }

        @Override
        public IVizGroupProperty getGroup(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof GroupProperty ? ((GroupProperty)node).toHost() : null;
        }

        @Override
        public IVizBooleanProperty getBoolean(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof BooleanProperty ? ((BooleanProperty)node).toHost() : null;
        }

        @Override
        public IVizColorProperty getColor(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof ColorProperty ? ((ColorProperty)node).toHost() : null;
        }

        @Override
        public IVizEnumProperty getEnum(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof EnumProperty ? ((EnumProperty)node).toHost() : null;
        }

        @Override
        public IVizNumberProperty getNumber(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof NumberProperty ? ((NumberProperty)node).toHost() : null;
        }

        @Override
        public IVizPaletteProperty getPalette(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof PaletteProperty ? ((PaletteProperty)node).toHost() : null;
        }

        @Override
        public IVizStringProperty getString(String _name) {
            Property node = (Property)Properties.this.map.get(_name);
            return node instanceof StringProperty ? ((StringProperty)node).toHost() : null;
        }
    }
}

