/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.property;

import com.ibm.vipr.event.IEventListener;
import com.ibm.vipr.internal.property.IToRSValueFunction;
import com.ibm.vipr.internal.property.Property;
import com.ibm.vipr.property.IVizValueProperty;
import com.ibm.vipr.property.PropertyValueEventArgs;
import com.ibm.vipr.renderingservice.property.IDeprecatedProperty;
import com.ibm.vipr.renderingservice.property.IPropertyParser;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.property.IRSValueProperty;
import com.ibm.vipr.vizdef.PropertyDef;
import com.ibm.vipr.vizdef.ValuePropertyDef;
import java.util.HashMap;
import java.util.Map;

abstract class ValueProperty<TPropertyDef extends ValuePropertyDef<TValue>, TValue, TRSValue>
extends Property<TPropertyDef> {
    private static final Object NotApplicable = new Object();
    private boolean initialized;
    private TValue value;
    private TRSValue rsValue;
    private TRSValue rsPeek;
    private boolean locked;
    private Object rendered;
    protected IPropertyParser<TRSValue> parser;
    private Deprecated<TRSValue> deprecated;
    private IToRSValueFunction<TValue, TRSValue> toRSValueFn;

    private IDeprecatedProperty<TRSValue> normalizeDeprecated(IDeprecatedProperty<?> _api) {
        return _api;
    }

    private IPropertyParser<TRSValue> normalizeParser(IPropertyParser<?> _parser) {
        return _parser;
    }

    public void initDeprecated(Map<String, Property<?>> _properties, IRSProperties _rsProperties, IDeprecatedProperty<?> _api) {
        if (!((ValuePropertyDef)this.def).deprecated) {
            throw new Error(((ValuePropertyDef)this.def).name + " is not deprecated");
        }
        if (_api == null) {
            throw new Error("Missing IDeprecatedProperty interface for deprecated property " + ((ValuePropertyDef)this.def).name);
        }
        if (this.deprecated != null) {
            throw new Error(((ValuePropertyDef)this.def).name + " is already initialized as deprecated");
        }
        this.deprecated = new Deprecated<TRSValue>(_properties, _rsProperties, this.normalizeDeprecated(_api));
        this.evaluate();
        IEventListener affectedListener = (_args, _sender) -> this.evaluate();
        for (String propName : _api.getAffectedBy()) {
            _properties.get(propName).on("value", affectedListener);
        }
    }

    public IRSValueProperty<TRSValue> initHost(IPropertyParser<?> _parser) {
        if (this.initialized) {
            throw new Error(((ValuePropertyDef)this.def).name + " is already initialized");
        }
        this.parser = this.normalizeParser(_parser);
        this.initialized = true;
        return this.toRS();
    }

    abstract IRSValueProperty<TRSValue> toRS();

    @Override
    abstract IVizValueProperty<TValue> toHost();

    void lock() {
        this.locked = true;
    }

    void unlock(boolean _success) {
        if (this.locked) {
            if (_success) {
                this.rendered = this.rsValue;
            }
            this.rsValue = this.rsPeek;
            this.locked = false;
        }
    }

    public TValue getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TValue setValue(Object _value) {
        Deprecated<TRSValue> deprecated;
        Object rsParsed;
        TValue oldValue = this.value;
        TValue newValue = ((ValuePropertyDef)this.def).parse(_value, oldValue);
        TRSValue rsValue = this.toRSValueFn.toRSValue(newValue);
        if (this.parser != null && (rsParsed = this.parser.parseValue(rsValue, _value, this.rsPeek)) != rsValue) {
            newValue = ((ValuePropertyDef)this.def).parse(rsParsed, newValue);
            rsValue = this.toRSValueFn.toRSValue(newValue);
        }
        if ((deprecated = this.deprecated) != null && !deprecated.updating) {
            HashMap<String, Object> toSet = new HashMap<String, Object>();
            deprecated.api.setValue(deprecated.rsProperties, rsValue, toSet);
            if (toSet.size() > 0) {
                deprecated.updating = true;
                try {
                    toSet.forEach((_name, _valueToSet) -> {
                        Property<?> prop = deprecated.properties.get(_name);
                        if (prop instanceof ValueProperty && !((PropertyDef)prop.def).deprecated) {
                            ((ValueProperty)prop).setValue(_valueToSet);
                        }
                    });
                }
                finally {
                    deprecated.updating = false;
                }
            }
        }
        if (!((ValuePropertyDef)this.def).valuesEqual(newValue, oldValue)) {
            this.value = newValue;
            this.rsPeek = rsValue;
            if (!this.locked) {
                this.rsValue = rsValue;
            }
            this.emit("value", new PropertyValueEventArgs((IVizValueProperty<?>)this.toHost(), oldValue));
        }
        return this.value;
    }

    private void evaluate() {
        Deprecated<TRSValue> deprecated = this.deprecated;
        if (!deprecated.updating) {
            Object value = deprecated.api.evaluate(deprecated.rsProperties, this.rsPeek);
            deprecated.updating = true;
            this.setValue(value);
            deprecated.updating = false;
        }
    }

    public ValueProperty(TPropertyDef _def, boolean _forRS, IPropertyParser<?> _parser, IToRSValueFunction<TValue, TRSValue> _toRSValueFn) {
        super(_def, _forRS);
        Object value = ((ValuePropertyDef)_def).defaultValue;
        this.toRSValueFn = _toRSValueFn;
        TRSValue rsValue = this.toRSValueFn.toRSValue(value);
        this.initialized = this.forRS;
        this.value = value;
        this.rsValue = rsValue;
        this.rsPeek = rsValue;
        this.locked = false;
        this.rendered = NotApplicable;
        this.parser = this.normalizeParser(_parser);
        this.deprecated = null;
    }

    protected static class VizValueProperty
    extends Property.VizProperty
    implements IVizValueProperty<TValue> {
        final /* synthetic */ ValueProperty this$0;

        public VizValueProperty(TPropertyDef _def) {
            this.this$0 = this$0;
            super((Property)this$0, _def);
        }

        @Override
        public TValue getValue() {
            return this.this$0.getValue();
        }

        @Override
        public TValue setValue(Object _value) {
            return this.this$0.setValue(_value);
        }

        @Override
        public boolean isActive() {
            return this.this$0.isActive();
        }

        @Override
        public boolean isDirty() {
            ValueProperty source = this.this$0;
            return source.rsPeek != source.rendered;
        }

        @Override
        public boolean getAllowNull() {
            return ((ValuePropertyDef)this.def).allowNull;
        }

        @Override
        public boolean isServiceWritable() {
            return ((ValuePropertyDef)this.def).serviceWritable;
        }

        @Override
        public TValue getDefaultValue() {
            return ((ValuePropertyDef)this.def).defaultValue;
        }

        @Override
        public boolean getRequiresData() {
            return ((ValuePropertyDef)this.def).requiresData;
        }
    }

    protected class RSValueProperty
    extends Property.RSProperty
    implements IRSValueProperty<TRSValue> {
        protected RSValueProperty() {
            super(ValueProperty.this);
        }

        public TRSValue getValue() {
            return ValueProperty.this.rsValue;
        }

        public void setValue(TRSValue _value) {
            if (!this.isWritable()) {
                throw new Error(this.getName() + " is not writable");
            }
            ValueProperty.this.setValue(_value);
        }

        public TRSValue peekValue() {
            return ValueProperty.this.rsPeek;
        }

        public void setActive(boolean _value) {
            ValueProperty.this.setActive(_value);
        }

        public boolean isDirty() {
            ValueProperty source = ValueProperty.this;
            return source.rsValue != source.rendered;
        }

        public boolean isWritable() {
            ValuePropertyDef def = (ValuePropertyDef)ValueProperty.this.def;
            return def.serviceWritable && !def.deprecated;
        }
    }

    private static class Deprecated<TRSValue> {
        public final Map<String, Property<?>> properties;
        public final IRSProperties rsProperties;
        public final IDeprecatedProperty<TRSValue> api;
        public boolean updating;

        public Deprecated(Map<String, Property<?>> _properties, IRSProperties _rsProperties, IDeprecatedProperty<TRSValue> _api) {
            this.properties = _properties;
            this.rsProperties = _rsProperties;
            this.api = _api;
            this.updating = false;
        }
    }
}

