/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.property.palette;

import com.ibm.vipr.api.ContDomain;
import com.ibm.vipr.api.IColor;
import com.ibm.vipr.api.IColorStop;
import com.ibm.vipr.api.IContStops;
import com.ibm.vipr.api.IPaletteResolver;
import com.ibm.vipr.data.IContDomain;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSColorStop;
import com.ibm.vipr.renderingservice.api.IRSContStops;
import com.ibm.vipr.renderingservice.api.IRSDataContext;
import com.ibm.vipr.renderingservice.data.IRSContDomain;
import com.ibm.vipr.util.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PaletteProxy {
    public static final IColor FallbackColor = Color.Named.purple.color;
    protected final IRSDataContext dataContext;
    protected final IPaletteResolver resolver;

    private static double clamp(double _min, double _val, double _max) {
        return _val < _min ? _min : (_val > _max ? _max : _val);
    }

    protected IRSContStops processColorStops(IContStops _stops, IContDomain _domain) {
        List<IRSColorStop> aligned;
        ArrayList<IRSColorStop> stops;
        double domainMin = _domain.getMin();
        double domainMax = _domain.getMax();
        double stopMin = domainMin;
        double stopMax = domainMax;
        boolean domainsAlign = true;
        double valueRange = stopMax - stopMin;
        List sourceStops = (List)_stops.getStops();
        int len = sourceStops.size();
        if (len > 1 && valueRange > 0.0) {
            double previousValue;
            double value;
            double at;
            stops = new ArrayList(len);
            for (int i = 0; i < len; ++i) {
                stops.add(null);
            }
            IColorStop sourceStop = (IColorStop)sourceStops.get(0);
            IColor color = sourceStop.getColor();
            if (sourceStop.getAt() != null) {
                at = PaletteProxy.clamp(0.0, sourceStop.getAt().doubleValue(), 1.0);
                value = domainMin + at * valueRange;
            } else {
                at = 0.0;
                value = sourceStop.getValue().doubleValue();
            }
            stopMin = previousValue = value;
            stops.set(0, new RSColorStop(color, (Number)at, (Number)value));
            sourceStop = (IColorStop)sourceStops.get(len - 1);
            color = sourceStop.getColor();
            if (sourceStop.getAt() != null) {
                at = PaletteProxy.clamp(0.0, sourceStop.getAt().doubleValue(), 1.0);
                value = Double.compare(at, 1.0) == 0 ? domainMax : domainMin + at * valueRange;
            } else {
                at = 1.0;
                value = sourceStop.getValue().doubleValue();
            }
            stopMax = value;
            stops.set(len - 1, new RSColorStop(color, (Number)at, (Number)value));
            double stopRange = Math.abs(stopMax - stopMin);
            if (Double.compare(stopMin, domainMin) != 0 || Double.compare(stopMax, domainMax) != 0) {
                domainsAlign = false;
            }
            for (int i = 1; i < len - 1; ++i) {
                sourceStop = (IColorStop)sourceStops.get(i);
                color = sourceStop.getColor();
                if (sourceStop.getAt() != null) {
                    at = PaletteProxy.clamp(0.0, sourceStop.getAt().doubleValue(), 1.0);
                    value = stopMin + at * stopRange;
                } else {
                    value = sourceStop.getValue().doubleValue();
                    at = (value - stopMin) / stopRange;
                }
                if (value < previousValue || value > stopMax) {
                    throw new Error("Stops are out of order, this is not supported");
                }
                stops.set(i, new RSColorStop(color, (Number)at, (Number)value));
            }
        } else {
            IColor color;
            stops = new ArrayList<IRSColorStop>(2);
            IColorStop sourceStop = len > 0 ? (IColorStop)sourceStops.get(0) : null;
            IColor iColor = color = sourceStop != null ? sourceStop.getColor() : null;
            if (color == null) {
                color = FallbackColor;
            }
            if (_domain.isEmpty()) {
                stops.add(new RSColorStop(color, 0));
                stops.add(new RSColorStop(color, 1));
            } else {
                stops.add(new RSColorStop(color, (Number)0, (Number)stopMin));
                stops.add(new RSColorStop(color, (Number)1, (Number)stopMax));
            }
        }
        if (domainsAlign) {
            aligned = stops;
        } else {
            aligned = this.alignStops(stops, domainMin, domainMax);
            _domain = new ContDomain(stopMin, stopMax);
        }
        return new RSContStops(stops, _domain, aligned, _stops.mustInterpolate());
    }

    private List<IRSColorStop> alignStops(List<IRSColorStop> _stops, double _min, double _max) {
        IRSColorStop lastStop = null;
        double lastAt = 1.0;
        double lastValue = 0.0;
        double valueRange = Math.abs(_max - _min);
        ArrayList<IRSColorStop> result = new ArrayList<IRSColorStop>();
        int len = _stops.size();
        for (int i = 0; i < len; ++i) {
            IRSColor color;
            double ratio;
            IRSColorStop stop = _stops.get(i);
            double stopValue = stop.getValue().doubleValue();
            double at = (stopValue - _min) / valueRange;
            if (i > 0 && lastAt < 0.0 && at > 0.0) {
                ratio = (_min - lastValue) / (stopValue - lastValue);
                color = Color.interpolate(lastStop.getColor(), stop.getColor(), ratio);
                result.add(new RSColorStop(color, (Number)0.0, (Number)_min));
            }
            if (at >= 0.0 && at <= 1.0) {
                result.add(new RSColorStop(stop.getColor(), (Number)at, (Number)stopValue));
            }
            if (i > 0 && lastAt < 1.0 && at > 1.0) {
                ratio = (_max - lastValue) / (stopValue - lastValue);
                color = Color.interpolate(lastStop.getColor(), stop.getColor(), ratio);
                result.add(new RSColorStop(color, (Number)1.0, (Number)_max));
            }
            lastStop = stop;
            lastAt = at;
            lastValue = stop.getValue().doubleValue();
        }
        return result;
    }

    public PaletteProxy(IRSDataContext _dataContext, IPaletteResolver _resolver) {
        this.dataContext = _dataContext;
        this.resolver = _resolver;
    }

    private static class RSContStops
    implements IRSContStops {
        private List<IRSColorStop> stops;
        private IContDomain domain;
        private List<IRSColorStop> aligned;
        private boolean mustInterpolate;

        public RSContStops(List<IRSColorStop> _stops, IContDomain _domain, List<IRSColorStop> _aligned, boolean _mustInterpolate) {
            this.stops = _stops;
            this.domain = _domain;
            this.aligned = _aligned;
            this.mustInterpolate = _mustInterpolate;
        }

        public Iterator<IRSColorStop> iterator() {
            return this.stops.iterator();
        }

        public List<IRSColorStop> getStops() {
            return this.stops;
        }

        public IRSContDomain getDomain() {
            return this.domain;
        }

        public List<IRSColorStop> getAligned() {
            return this.aligned;
        }

        public boolean mustInterpolate() {
            return this.mustInterpolate;
        }

        public IRSColor getColor(Number _value) {
            int i;
            double value = _value != null ? _value.doubleValue() : 0.0;
            int len = this.stops.size();
            IRSColorStop stop = null;
            IRSColorStop next = null;
            IRSColor result = null;
            double stopValue = 0.0;
            for (i = len - 1; i >= 0; --i) {
                stop = this.stops.get(i);
                if (stop.getValue() != null) {
                    stopValue = stop.getValue().doubleValue();
                }
                if (value >= stopValue) break;
                next = stop;
            }
            if (i < 0 || next == null || !this.mustInterpolate || Double.compare(stopValue, value) == 0) {
                if (stop != null) {
                    result = stop.getColor();
                }
            } else {
                double nextValue = 0.0;
                if (next.getValue() != null) {
                    nextValue = next.getValue().doubleValue();
                }
                double valueRange = Math.abs(nextValue - stopValue);
                double at = 0.0;
                if (valueRange > 0.0) {
                    at = (value - stopValue) / valueRange;
                }
                result = Color.interpolate(stop.getColor(), next.getColor(), at);
            }
            if (result != null) {
                return result;
            }
            return Color.toRSColor(FallbackColor);
        }
    }

    private class RSColorStop
    implements IRSColorStop {
        private final IRSColor color;
        private final Number at;
        private final Number value;

        public RSColorStop(IColor _color, Number _at) {
            this(Color.toRSColor(_color), _at, null);
        }

        public RSColorStop(IColor _color, Number _at, Number _value) {
            this(Color.toRSColor(_color), _at, _value);
        }

        public RSColorStop(IRSColor _color, Number _at, Number _value) {
            this.color = _color;
            this.at = _at;
            this.value = _value;
        }

        public IRSColor getColor() {
            return this.color;
        }

        public Number getAt() {
            return this.at;
        }

        public Number getValue() {
            return this.value;
        }
    }
}

