/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.util;

import com.ibm.vipr.api.IImageMapEntry;
import com.ibm.vipr.api.IPoint;
import com.ibm.vipr.info.IInfo;
import com.ibm.vipr.internal.data.VIPRDataApi;
import com.ibm.vipr.internal.util.Point;
import com.ibm.vipr.renderingservice.api.IRSImageMapEntry;
import com.ibm.vipr.renderingservice.api.IRSPoint;
import com.ibm.vipr.renderingservice.data.IRSDataNode;
import java.util.ArrayList;
import java.util.List;

public class ImageMapEntry
implements IImageMapEntry {
    private final String type;
    private final String subType;
    private final List<IInfo> data;
    private final List<IPoint> points;

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getSubType() {
        return this.subType;
    }

    @Override
    public List<IInfo> getData() {
        return this.data;
    }

    @Override
    public List<IPoint> getPoints() {
        return this.points;
    }

    private ImageMapEntry(String _type, String _subType, List<IInfo> _data, List<IPoint> _points) {
        this.type = _type;
        this.subType = _subType;
        this.data = _data;
        this.points = _points;
    }

    public static ImageMapEntry create(IRSImageMapEntry _entry) {
        ArrayList<IInfo> info = null;
        List rsData = _entry.getData();
        if (rsData != null) {
            info = new ArrayList<IInfo>(rsData.size());
            for (IRSDataNode node : rsData) {
                info.add(VIPRDataApi.dataToInfo(node));
            }
        }
        List rsPoints = _entry.getPoints();
        ArrayList<IPoint> points = new ArrayList<IPoint>(rsPoints.size());
        for (IRSPoint pt : rsPoints) {
            points.add(new Point(pt.getX(), pt.getY()));
        }
        return new ImageMapEntry(_entry.getType(), _entry.getSubType(), info, points);
    }
}

