/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.util;

import com.ibm.vipr.renderingservice.data.IRSCaptioned;
import com.ibm.vipr.renderingservice.data.IRSSubCaptioned;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import java.util.List;

public class JoinUtil {
    private static final String EMPTY = "";

    public static String normalize(String _caption) {
        return _caption == null ? EMPTY : _caption;
    }

    public static <T extends IRSCaptioned> String joinCaptions(List<T> _list, RSFormatKind _kind, String _separator) {
        int len = _list.size();
        if (len < 2) {
            return len < 1 ? EMPTY : JoinUtil.normalize(((IRSCaptioned)_list.get(0)).getCaption(_kind));
        }
        StringBuilder builder = new StringBuilder();
        boolean empty = true;
        for (int i = 0; i < len; ++i) {
            String part;
            if (i > 0) {
                builder.append(_separator);
            }
            if ((part = ((IRSCaptioned)_list.get(i)).getCaption(_kind)) == null || part.length() <= 0) continue;
            empty = false;
            builder.append(part);
        }
        return empty ? EMPTY : builder.toString();
    }

    public static <T extends IRSSubCaptioned> String joinSubCaptions(List<T> _list, RSFormatKind _kind, String _separator) {
        int len = _list.size();
        if (len < 2) {
            return len < 1 ? EMPTY : JoinUtil.normalize(((IRSSubCaptioned)_list.get(0)).getSubCaption(_kind));
        }
        StringBuilder builder = new StringBuilder();
        boolean empty = true;
        for (int i = 0; i < len; ++i) {
            String part;
            if (i > 0) {
                builder.append(_separator);
            }
            if ((part = ((IRSSubCaptioned)_list.get(i)).getSubCaption(_kind)) == null || part.length() <= 0) continue;
            empty = false;
            builder.append(part);
        }
        return empty ? EMPTY : builder.toString();
    }

    public static <T extends IRSSubCaptioned> String joinCombinedCaptions(List<T> _list, RSFormatKind _kind, String _separator) {
        int len = _list.size();
        if (len < 2) {
            return len < 1 ? EMPTY : JoinUtil.normalize(((IRSSubCaptioned)_list.get(0)).combineCaptions(_kind));
        }
        StringBuilder builder = new StringBuilder();
        boolean empty = true;
        for (int i = 0; i < len; ++i) {
            String part;
            if (i > 0) {
                builder.append(_separator);
            }
            if ((part = ((IRSSubCaptioned)_list.get(i)).combineCaptions(_kind)) == null || part.length() <= 0) continue;
            empty = false;
            builder.append(part);
        }
        return empty ? EMPTY : builder.toString();
    }
}

