/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.util;

import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArtifact;
import com.ibm.vipr.internal.util.ResourceLoaderException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class ResourceLoader {
    private static final String EOL = System.getProperty("line.separator");
    private final URL m_location;

    public ResourceLoader(URL _location) {
        this.m_location = _location;
    }

    public CompletableFuture<Object> loadJSON(String _path) {
        return this.loadStream(_path).thenApply(_stream -> {
            try (InputStream inStream = (InputStream)_stream;){
                JSONArtifact jSONArtifact = JSON.parse((InputStream)inStream);
                return jSONArtifact;
            }
            catch (IOException e) {
                throw new CompletionException(String.format("Error parsing JSON resource\"%s\"", _path), e);
            }
            catch (Throwable t) {
                throw new CompletionException(String.format("Unexpected error while loading resource from \"%s\"", _path), t);
            }
        });
    }

    public CompletableFuture<Object> loadStream(String _path) {
        URL url;
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        try {
            url = new URL(this.m_location, _path);
        }
        catch (MalformedURLException e) {
            future.completeExceptionally(new ResourceLoaderException("Can't get a URL from \"%s\"", (Throwable)e, _path));
            return future;
        }
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            future.complete(conn.getInputStream());
            return future;
        }
        catch (IOException e) {
            future.completeExceptionally(new ResourceLoaderException("Can't read JSON from URL %s", null, url));
            return future;
        }
        catch (Throwable t) {
            future.completeExceptionally(new CompletionException(String.format("Unexpected error while loading resource from \"%s\"", _path), t));
            return future;
        }
    }

    public CompletableFuture<Object> loadText(String _path) {
        return this.loadStream(_path).thenApply(_inStream -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)_inStream));){
                String line;
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                while ((line = reader.readLine()) != null) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(EOL);
                    }
                    sb.append(line);
                }
                String string = sb.toString();
                return string;
            }
            catch (IOException e) {
                throw new CompletionException(String.format("Error reading resource \"%s\"", _path), e);
            }
            catch (Throwable t) {
                throw new CompletionException(String.format("Unexpected error while loading resource from \"%s\"", _path), t);
            }
        });
    }
}

