/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.util;

import com.ibm.vipr.api.INls;
import com.ibm.vipr.renderingservice.api.IRSNls;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VIPRNls
implements IRSNls,
INls {
    private static final Pattern reNlsProp = Pattern.compile("^\\$nls\\.([^\\s]+)", 2);
    private final List<ResourceBundle> bundles = new ArrayList<ResourceBundle>();

    public static VIPRNls create(Locale _locale) {
        VIPRNls nls = new VIPRNls();
        nls.addBundle(ResourceBundle.getBundle("Messages", _locale));
        return nls;
    }

    public String resolve(String _str) {
        String key;
        Matcher matcher;
        if (_str != null && (matcher = reNlsProp.matcher(_str)).matches() && this.has(key = matcher.group(1))) {
            return this.get(key);
        }
        return _str;
    }

    public void addBundle(ResourceBundle _bundle) {
        this.bundles.add(_bundle);
    }

    @Override
    public boolean has(String _key) {
        for (ResourceBundle bundle : this.bundles) {
            if (!bundle.containsKey(_key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String get(String _key) {
        for (int i = this.bundles.size() - 1; i >= 0; --i) {
            ResourceBundle bundle = this.bundles.get(i);
            if (!bundle.containsKey(_key)) continue;
            return bundle.getString(_key);
        }
        return null;
    }
}

