/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlParser {
    public static final String ERROR_INVALID_NUMBER = "Invalid number value: ";

    public static Document parse(InputStream _stream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(_stream);
    }

    public static Document parse(String _xml) throws Exception {
        return XmlParser.parse(new ByteArrayInputStream(_xml.getBytes()));
    }

    private static boolean tagMatcher(Node _node, Pattern _tag) {
        return _node.getNodeType() == 1 && _tag.matcher(_node.getNodeName()).matches();
    }

    private static Node getAttribute(Node _node, String _name) {
        return _node == null ? null : _node.getAttributes().getNamedItem(_name);
    }

    public static String getTextContent(Node _node) {
        StringBuilder result = new StringBuilder();
        if (_node != null) {
            switch (_node.getNodeType()) {
                case 1: {
                    for (Node child = _node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child.getNodeType() != 3) continue;
                        result.append(child.getNodeValue());
                    }
                    break;
                }
                case 3: {
                    result.append(_node.getNodeValue());
                }
            }
        }
        return result.length() == 0 ? null : result.toString();
    }

    public static List<Node> filterChildElements(Node _parentNode) {
        NodeList nodes = _parentNode != null ? _parentNode.getChildNodes() : null;
        int length = nodes == null ? 0 : nodes.getLength();
        ArrayList<Node> result = new ArrayList<Node>(length);
        if (nodes != null) {
            for (int i = 0; i < length; ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                result.add(node);
            }
        }
        return result;
    }

    public static List<Node> filterChildElementsByTag(Node _parentNode, Pattern _tagExpr) {
        NodeList nodes = _parentNode != null ? _parentNode.getChildNodes() : null;
        int length = nodes == null ? 0 : nodes.getLength();
        ArrayList<Node> result = new ArrayList<Node>(length);
        if (nodes != null && _tagExpr != null) {
            for (int i = 0; i < length; ++i) {
                Node child = nodes.item(i);
                if (!XmlParser.tagMatcher(child, _tagExpr)) continue;
                result.add(child);
            }
        }
        return result;
    }

    public static Node findChildElementByTag(Node _parentNode, Pattern _tagExpr) {
        if (_parentNode != null && _tagExpr != null && _parentNode.hasChildNodes()) {
            for (Node child = _parentNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!XmlParser.tagMatcher(child, _tagExpr)) continue;
                return child;
            }
        }
        return null;
    }

    public static String stringAttr(Node _node, String _name, String _default) {
        Node attr = XmlParser.getAttribute(_node, _name);
        return attr != null ? attr.getNodeValue() : _default;
    }

    public static List<String> commaSeparatedAttr(Node _node, String _name, List<String> _default) {
        Node attr = XmlParser.getAttribute(_node, _name);
        if (attr == null) {
            return _default;
        }
        String value = attr.getNodeValue().trim();
        return Arrays.asList(value.split("\\s*,\\s*"));
    }

    public static boolean boolAttr(Node _node, String _name, boolean _default) {
        Node attr = XmlParser.getAttribute(_node, _name);
        return attr != null ? Boolean.parseBoolean(attr.getNodeValue()) : _default;
    }

    public static Number numberAttr(Node _node, String _name, Number _default, boolean _throwOnNaN) {
        Node attr = XmlParser.getAttribute(_node, _name);
        if (attr == null) {
            return _default;
        }
        try {
            return NumberFormat.getNumberInstance(Locale.ENGLISH).parse(attr.getNodeValue());
        }
        catch (ParseException ex) {
            if (_throwOnNaN) {
                throw new Error(ERROR_INVALID_NUMBER + attr.getNodeValue());
            }
            return _default;
        }
    }
}

