/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.util;

import com.ibm.vipr.api.IColor;
import com.ibm.vipr.util.Color;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CatPaletteBase {
    protected final List<IColor> colors;

    public CatPaletteBase(String _colors) {
        this(Arrays.asList(_colors.trim().split("\\s*;\\s*")));
    }

    public CatPaletteBase(List<?> _colors) {
        if (_colors.get(0) instanceof String) {
            this.colors = _colors.stream().map(_c -> Color.fromString(_c.trim())).filter(_c -> _c != null).collect(Collectors.toList());
        } else if (_colors.get(0) instanceof IColor) {
            this.colors = _colors.stream().map(_c -> Color.immutable(_c)).collect(Collectors.toList());
        } else {
            throw new Error("List type can only be String or IColor");
        }
    }

    protected IColor getColorAt(int _index) {
        return this.colors.get(_index % this.colors.size());
    }
}

