/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.util;

import com.ibm.vipr.api.ICatPaletteResolver;
import com.ibm.vipr.api.IColor;
import com.ibm.vipr.info.ICatDataItemInfo;
import com.ibm.vipr.info.IDataItemInfo;
import com.ibm.vipr.info.IItemInfo;
import com.ibm.vipr.info.ITupleInfo;
import com.ibm.vipr.util.CatPaletteBase;
import com.ibm.vipr.util.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CatPaletteResolver
extends CatPaletteBase
implements ICatPaletteResolver {
    private static final IColor FALLBACK_COLOR = Color.Named.purple.color;
    private final Map<IDataItemInfo, Map<Integer, List<String>>> levelCaches = new HashMap<IDataItemInfo, Map<Integer, List<String>>>();
    private final int defaultIndex;

    private List<String> getLevelCache(ICatDataItemInfo _dataItem, int _level) {
        List<String> cachedItems;
        Map<Integer, List<String>> cache = this.levelCaches.get(_dataItem);
        if (cache == null) {
            cache = new HashMap<Integer, List<String>>();
            this.levelCaches.put(_dataItem, cache);
        }
        if ((cachedItems = cache.get(_level)) != null) {
            return cachedItems;
        }
        ArrayList<String> items = new ArrayList<String>();
        cache.put(_level, items);
        _dataItem.getTupleInfos().forEach(_tupleInfo -> {
            String name;
            IItemInfo info = _tupleInfo.getItemInfos().get(_level);
            if (info != null && !items.contains(name = info.getUniqueName())) {
                items.add(name);
            }
        });
        return items;
    }

    public CatPaletteResolver(String _colors) {
        this(_colors, 0);
    }

    public CatPaletteResolver(String _colors, int _defaultIndex) {
        super(_colors);
        this.defaultIndex = _defaultIndex;
    }

    public CatPaletteResolver(List<?> _colors) {
        this(_colors, 0);
    }

    public CatPaletteResolver(List<?> _colors, int _defaultIndex) {
        super(_colors);
        this.defaultIndex = _defaultIndex;
    }

    @Override
    public IColor getColor(ITupleInfo _tuple, ICatDataItemInfo _dataItem, int _level) {
        if (this.colors.size() == 0) {
            return FALLBACK_COLOR;
        }
        int index = this.defaultIndex;
        if (_tuple != null) {
            if (_level < 0) {
                index = _tuple.getIndex();
            } else if (_dataItem != null) {
                index = this.getLevelCache(_dataItem, _level).indexOf(_tuple.getItemInfos().get(_level).getUniqueName());
            }
        }
        if (_tuple != null && _dataItem != null) {
            index = _level < 0 ? _tuple.getIndex() : this.getLevelCache(_dataItem, _level).indexOf(_tuple.getItemInfos().get(_level).getUniqueName());
        }
        return this.getColorAt(index);
    }
}

