/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.util;

import com.ibm.vipr.api.IColor;
import com.ibm.vipr.api.IColorStop;
import com.ibm.vipr.api.IContStops;
import com.ibm.vipr.data.IContDomain;
import com.ibm.vipr.util.Color;
import com.ibm.vipr.util.ColorStop;
import com.ibm.vipr.util.ContStops;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContPaletteBase {
    private static final Pattern reOffset = Pattern.compile("\\s+(-?(?:\\d*\\.\\d+|\\d+))(%)?\\s*$");
    public final boolean interpolate;
    public final boolean equalize;
    public final Number midPoint;
    public final List<IColorStop> linear = new ArrayList<IColorStop>();
    public final List<IColorStop> divergent = new ArrayList<IColorStop>();
    private final List<IColorStop> lowStops = new ArrayList<IColorStop>();
    private final List<IColorStop> highStops = new ArrayList<IColorStop>();

    private static void parseStops(List<IColorStop> _result, List<String> _stops, boolean _divergent) {
        if (_stops.size() == 0) {
            return;
        }
        double low = _divergent ? -1.0 : 0.0;
        double high = 1.0;
        double value = 0.0;
        boolean absolute = false;
        boolean relative = false;
        boolean implicit = false;
        int len = _stops.size();
        ArrayList<IColor> colors = new ArrayList<IColor>();
        _result.clear();
        for (int i = 0; i < len; ++i) {
            String stop = _stops.get(i);
            IColor color = null;
            Number rel = null;
            Number abs = null;
            Matcher offset = reOffset.matcher(stop);
            if (offset.find()) {
                String pattern = offset.group(0);
                String number = offset.group(1);
                String perc = offset.group(2);
                color = Color.fromString(stop.substring(0, stop.length() - pattern.length()));
                if (perc != null) {
                    rel = Double.parseDouble(number) / 100.0;
                } else {
                    abs = Double.parseDouble(number);
                }
            } else {
                color = Color.fromString(stop);
            }
            if (color == null) {
                throw new IllegalArgumentException("Invalid color stop definition: " + stop);
            }
            if (rel != null && (rel.doubleValue() < low || rel.doubleValue() > high)) {
                throw new IllegalArgumentException("Offset of stop " + stop + " is out of bounds");
            }
            if (rel != null) {
                relative = true;
                _result.add(ColorStop.createRelative(color, rel.doubleValue()));
            } else if (abs != null) {
                absolute = true;
                _result.add(ColorStop.createAbsolute(color, abs.doubleValue()));
            } else {
                implicit = true;
                _result.add(null);
            }
            colors.add(color);
        }
        if (absolute && relative) {
            throw new IllegalArgumentException("Mixing absolute and relative stops is not supported");
        }
        if (implicit) {
            IColorStop stop = _result.get(len - 1);
            if (stop == null) {
                if (absolute) {
                    throw new IllegalArgumentException("The last value of an absolute palette cannot be implicit");
                }
                stop = ColorStop.createRelative((IColor)colors.get(len - 1), high);
                _result.set(len - 1, stop);
            }
            high = absolute ? stop.getValue().doubleValue() : stop.getAt().doubleValue();
            stop = _result.get(0);
            if (stop == null) {
                if (absolute) {
                    throw new IllegalArgumentException("The first value of an absolute palette cannot be implicit");
                }
                stop = ColorStop.createRelative((IColor)colors.get(0), low);
                _result.set(0, stop);
            }
            low = absolute ? stop.getValue().doubleValue() : stop.getAt().doubleValue();
            int iLow = 0;
            int iHigh = -1;
            for (int i = 0; i < len; ++i) {
                stop = _result.get(i);
                if (stop == null) {
                    if (iHigh <= i) {
                        for (iHigh = i + 1; iHigh < len; ++iHigh) {
                            stop = _result.get(iHigh);
                            if (stop == null) continue;
                            high = absolute ? stop.getValue().doubleValue() : stop.getAt().doubleValue();
                            break;
                        }
                    }
                    value = low + (high - low) * ((double)(i - iLow) / (double)(iHigh - iLow));
                    if (absolute) {
                        _result.set(i, ColorStop.createAbsolute((IColor)colors.get(i), value));
                        continue;
                    }
                    _result.set(i, ColorStop.createRelative((IColor)colors.get(i), value));
                    continue;
                }
                low = absolute ? stop.getValue().doubleValue() : stop.getAt().doubleValue();
                iLow = i;
            }
        }
    }

    private static void buildStops(List<IColorStop> _result, List<IColorStop> _stops) {
        int size = _stops.size();
        for (int idx = 0; idx < size; ++idx) {
            IColorStop stop = _stops.get(idx);
            _result.add(ColorStop.immutable(stop));
        }
    }

    private static boolean isAbsolute(List<IColorStop> _stops) {
        return _stops.get(0).getValue() != null;
    }

    public ContPaletteBase(String _linear, String _divergent, boolean _interpolate, boolean _equalize) {
        this(Arrays.asList(_linear.trim().split("\\s*;\\s*")), _divergent != null ? Arrays.asList(_divergent.trim().split("\\s*;\\s*")) : null, _interpolate, _equalize);
    }

    public ContPaletteBase(List<?> _linear, List<?> _divergent, boolean _interpolate, boolean _equalize) {
        int len;
        this.interpolate = _interpolate;
        this.equalize = _equalize;
        if (_linear.size() > 0) {
            if (_linear.get(0) instanceof String) {
                ContPaletteBase.parseStops(this.linear, _linear, false);
            } else if (_linear.get(0) instanceof IColorStop) {
                ContPaletteBase.buildStops(this.linear, _linear);
            } else {
                throw new Error("List type can only be String or IColor");
            }
        }
        int n = len = _divergent != null ? _divergent.size() : 0;
        if (len > 0) {
            if (_divergent.get(0) instanceof String) {
                ContPaletteBase.parseStops(this.divergent, _divergent, true);
            } else if (_divergent.get(0) instanceof IColorStop) {
                ContPaletteBase.buildStops(this.divergent, _divergent);
            } else {
                throw new Error("List type can only be String or IColor");
            }
            boolean absolute = ContPaletteBase.isAbsolute(this.divergent);
            int iMid = Math.floorDiv(len, 2);
            this.midPoint = absolute ? (Number)this.divergent.get(iMid).getValue() : (Number)null;
            this.determineLowHigh(absolute, iMid);
        } else {
            this.midPoint = null;
        }
    }

    public IContStops getStopsFor(IContDomain _domain) {
        double mid = this.midPoint != null ? this.midPoint.doubleValue() : 0.0;
        double min = 0.0;
        double max = 0.0;
        boolean wantDivergent = false;
        if (_domain != null) {
            min = _domain.getMin();
            max = _domain.getMax();
            wantDivergent = this.divergent.size() > 0 && min < mid && max > mid;
        }
        List<IColorStop> stops = wantDivergent ? this.divergent : this.linear;
        int len = stops.size();
        boolean absolute = ContPaletteBase.isAbsolute(stops);
        boolean interpolate = this.interpolate;
        List<IColorStop> result = null;
        if (!wantDivergent && len < 1) {
            stops = min < mid ? this.lowStops : this.highStops;
            len = stops.size();
            absolute = ContPaletteBase.isAbsolute(stops);
        }
        if (min == max) {
            interpolate = false;
            result = Arrays.asList(stops.get((int)Math.floor(len / 2)));
        } else if (absolute || !wantDivergent) {
            result = stops;
        } else {
            result = new ArrayList<IColorStop>(len);
            double dLow = Math.abs(mid - min);
            double dHigh = Math.abs(max - mid);
            if (this.equalize) {
                if (dLow < dHigh) {
                    dLow = dHigh;
                    min = mid - dLow;
                } else if (dLow > dHigh) {
                    dHigh = dLow;
                }
            }
            for (int i = 0; i < len; ++i) {
                IColorStop stop = stops.get(i);
                double at = stop.getAt().doubleValue();
                result.add(ColorStop.createAbsolute(stop.getColor(), at < 0.0 ? (at + 1.0) * dLow + min : at * dHigh + mid));
            }
        }
        return new ContStops(result, interpolate);
    }

    List<IColorStop> getLinear() {
        return this.linear;
    }

    List<IColorStop> getDivergent() {
        return this.divergent;
    }

    private void determineLowHigh(boolean _absolute, int _iMid) {
        int len = this.divergent.size();
        for (int i = 0; i < len; ++i) {
            IColorStop stop = this.divergent.get(i);
            if (i <= _iMid) {
                this.lowStops.add(_absolute ? stop : ColorStop.createRelative(stop.getColor(), stop.getAt().doubleValue() + 1.0));
            }
            if (i < _iMid) continue;
            this.highStops.add(stop);
        }
    }
}

