/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.vizdef;

import com.ibm.vipr.property.PropertyType;
import com.ibm.vipr.property.PropertyVisibility;
import com.ibm.vipr.vizdef.ValuePropertyDef;
import java.util.List;
import java.util.regex.Pattern;

public class BooleanPropertyDef
extends ValuePropertyDef<Boolean> {
    private static final Pattern reTrue = Pattern.compile("^(?:true|yes|on|1)$", 2);
    private static final Pattern reFalse = Pattern.compile("^(?:false|no|off|0)$", 2);

    public static Boolean parse(String _value, boolean _allowNull, Boolean _fallback) {
        Boolean result = null;
        if (_value != null && !_value.isEmpty()) {
            result = reTrue.matcher(_value).matches() ? Boolean.valueOf(true) : (reFalse.matcher(_value).matches() ? Boolean.valueOf(false) : _fallback);
        }
        if (result == null && !_allowNull) {
            result = _fallback == null ? false : _fallback;
        }
        return result;
    }

    public BooleanPropertyDef(String _name, String _caption, String _description, List<String> _aliases, List<String> _tags, PropertyVisibility _visibility, boolean _deprecated, boolean _allowNull, Boolean _defaultValue, boolean _serviceWritable, boolean _requiresData) {
        super(PropertyType.Boolean, _name, _caption, _description, _aliases, _tags, _visibility, _deprecated, _allowNull, _defaultValue, _serviceWritable, _requiresData);
    }

    protected BooleanPropertyDef clone(String _caption, String _description, List<String> _aliases, List<String> _tags, PropertyVisibility _visibility, Boolean _defaultValue) {
        return new BooleanPropertyDef(this.name, _caption, _description, _aliases, _tags, _visibility, this.deprecated, this.allowNull, _defaultValue, this.serviceWritable, this.requiresData);
    }

    @Override
    protected Boolean parseImpl(Object _value, Boolean _fallback) {
        if (_value instanceof Boolean) {
            return (Boolean)_value;
        }
        if (_value instanceof String) {
            return BooleanPropertyDef.parse((String)_value, this.allowNull, _fallback);
        }
        return _fallback;
    }
}

