/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.vizdef;

import com.ibm.vipr.api.IColor;
import com.ibm.vipr.property.PropertyType;
import com.ibm.vipr.property.PropertyVisibility;
import com.ibm.vipr.util.Color;
import com.ibm.vipr.vizdef.ValuePropertyDef;
import java.util.List;
import java.util.regex.Pattern;

public class ColorPropertyDef
extends ValuePropertyDef<IColor> {
    private static final Pattern reNullColor = Pattern.compile("^(?:\\s*|auto(?:matic)?|null|inherit)$", 2);

    public static IColor parse(String _value, boolean _allowNull, IColor _fallback) {
        IColor result = null;
        if (_value != null && !reNullColor.matcher(_value).matches() && !_value.isEmpty() && (result = Color.fromString(_value)) == null) {
            result = _fallback;
        }
        if (!_allowNull && result == null) {
            result = _fallback == null ? Color.Named.black.color : _fallback;
        }
        return result;
    }

    public ColorPropertyDef(String _name, String _caption, String _description, List<String> _aliases, List<String> _tags, PropertyVisibility _visibility, boolean _deprecated, boolean _allowNull, IColor _defaultValue, boolean _serviceWritable, boolean _requiresData) {
        super(PropertyType.Color, _name, _caption, _description, _aliases, _tags, _visibility, _deprecated, _allowNull, _defaultValue, _serviceWritable, _requiresData);
    }

    protected ColorPropertyDef clone(String _caption, String _description, List<String> _aliases, List<String> _tags, PropertyVisibility _visibility, IColor _defaultValue) {
        return new ColorPropertyDef(this.name, _caption, _description, _aliases, _tags, _visibility, this.deprecated, this.allowNull, _defaultValue, this.serviceWritable, this.requiresData);
    }

    @Override
    protected IColor parseImpl(Object _value, IColor _fallback) {
        if (_value instanceof IColor) {
            return Color.immutable((IColor)_value);
        }
        if (_value instanceof String) {
            return ColorPropertyDef.parse((String)_value, this.allowNull, _fallback);
        }
        return _fallback;
    }
}

