/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.vizdef;

import com.ibm.vipr.property.PropertyType;
import com.ibm.vipr.property.PropertyVisibility;
import com.ibm.vipr.vizdef.PropertyDef;
import com.ibm.vipr.vizdef.PropertyOverride;
import java.util.Collections;
import java.util.List;

public class GroupPropertyDef
extends PropertyDef {
    public final List<PropertyDef> properties;

    GroupPropertyDef(String _name, String _caption, String _description, List<String> _aliases, List<String> _tags, PropertyVisibility _visibility, boolean _deprecated, List<PropertyDef> _properties) {
        super(PropertyType.Group, _name, _caption, _description, _aliases, _tags, _visibility, _deprecated);
        this.properties = Collections.unmodifiableList(_properties);
    }

    public boolean isEmpty() {
        for (PropertyDef property : this.properties) {
            if (property.visibility == PropertyVisibility.Excluded) continue;
            return false;
        }
        return true;
    }

    public GroupPropertyDef override(PropertyOverride _propertyOverride, List<String> _tags, PropertyVisibility _visibility, List<PropertyDef> _properties) {
        PropertyVisibility visibility;
        List<PropertyDef> properties;
        String caption = this.caption;
        String description = this.description;
        List<PropertyDef> list = properties = _properties == null ? this.properties : _properties;
        if (_propertyOverride != null && !_propertyOverride.isEmpty()) {
            caption = _propertyOverride.getCaption(caption);
            description = _propertyOverride.getDescription(description);
        }
        if ((visibility = _visibility) == null) {
            visibility = PropertyVisibility.Excluded;
            for (PropertyDef child : properties) {
                if (child.visibility == visibility) continue;
                visibility = child.visibility;
                break;
            }
        }
        return new GroupPropertyDef(this.name, caption, description, this.aliases, (List<String>)(_tags != null ? _tags : this.tags), visibility, this.deprecated, properties);
    }

    public GroupPropertyDef clone(List<PropertyDef> _properties) {
        return this.override(PropertyOverride.Empty, null, null, _properties);
    }
}

