/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.vizdef;

import com.ibm.vipr.property.PropertyType;
import com.ibm.vipr.property.PropertyVisibility;
import com.ibm.vipr.renderingservice.util.NumberUtil;
import com.ibm.vipr.vizdef.ValuePropertyDef;
import java.util.List;

public class NumberPropertyDef
extends ValuePropertyDef<Number> {
    public final Number minValue;
    public final Number maxValue;

    public static Number parse(String _value, boolean _allowNull, Number _fallback) {
        Number result = null;
        if (_value != null) {
            result = NumberUtil.parseNumber((String)_value, (Number)_fallback);
        }
        if (result == null && !_allowNull) {
            result = _fallback == null ? (Number)0 : (Number)_fallback;
        }
        return result;
    }

    public NumberPropertyDef(String _name, String _caption, String _description, List<String> _aliases, List<String> _tags, PropertyVisibility _visibility, boolean _deprecated, boolean _allowNull, Number _defaultValue, boolean _serviceWritable, boolean _requiresData, Number _minValue, Number _maxValue) {
        super(PropertyType.Number, _name, _caption, _description, _aliases, _tags, _visibility, _deprecated, _allowNull, _defaultValue, _serviceWritable, _requiresData);
        this.minValue = _minValue;
        this.maxValue = _maxValue;
        if (this.minValue != null && this.maxValue != null && this.maxValue.doubleValue() < this.minValue.doubleValue()) {
            throw new Error("Invalid range, minValue " + this.minValue + " is greater than maxValue " + this.maxValue);
        }
        if (this.defaultValue != null) {
            if (this.minValue != null && ((Number)this.defaultValue).doubleValue() < this.minValue.doubleValue()) {
                throw new Error("defaultValue " + this.defaultValue + " is out of bounds, it is below minValue " + this.minValue);
            }
            if (this.maxValue != null && ((Number)this.defaultValue).doubleValue() > this.maxValue.doubleValue()) {
                throw new Error("defaultValue " + this.defaultValue + " is out of bounds, it is above maxValue " + this.maxValue);
            }
        }
    }

    protected NumberPropertyDef clone(String _caption, String _description, List<String> _aliases, List<String> _tags, PropertyVisibility _visibility, Number _defaultValue) {
        return new NumberPropertyDef(this.name, _caption, _description, _aliases, _tags, _visibility, this.deprecated, this.allowNull, _defaultValue, this.serviceWritable, this.requiresData, this.minValue, this.maxValue);
    }

    @Override
    protected Number parseImpl(Object _value, Number _fallback) {
        Number result = _fallback;
        if (_value instanceof Number) {
            result = (Number)_value;
        } else if (_value instanceof String) {
            result = NumberUtil.parseNumber((String)((String)_value), (Number)_fallback);
        }
        if (result != null) {
            if (this.minValue != null && result.doubleValue() < this.minValue.doubleValue()) {
                result = this.minValue;
            }
            if (this.maxValue != null && result.doubleValue() > this.maxValue.doubleValue()) {
                result = this.maxValue;
            }
        }
        return result;
    }
}

