/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.vizdef;

import com.ibm.vipr.api.ICatPaletteResolver;
import com.ibm.vipr.api.IContPaletteResolver;
import com.ibm.vipr.api.ICustomCatPaletteResolver;
import com.ibm.vipr.api.ICustomContPaletteResolver;
import com.ibm.vipr.api.IPaletteResolver;
import com.ibm.vipr.api.PaletteType;
import com.ibm.vipr.property.PropertyType;
import com.ibm.vipr.property.PropertyVisibility;
import com.ibm.vipr.util.CatPaletteResolver;
import com.ibm.vipr.util.ContPaletteResolver;
import com.ibm.vipr.util.CustomCatPaletteResolver;
import com.ibm.vipr.util.CustomContPaletteResolver;
import com.ibm.vipr.vizdef.SlotDef;
import com.ibm.vipr.vizdef.ValuePropertyDef;
import java.util.List;

public class PalettePropertyDef
extends ValuePropertyDef<IPaletteResolver> {
    public final SlotDef slot;
    public final PaletteType type;
    public final Number min;
    public final Number max;

    public PalettePropertyDef(String _name, String _caption, String _description, List<String> _aliases, List<String> _tags, PropertyVisibility _visibility, boolean _deprecated, boolean _allowNull, IPaletteResolver _defaultValue, boolean _serviceWritable, boolean _requiresData, SlotDef _slot, PaletteType _type, Number _min, Number _max) {
        super(PropertyType.Palette, _name, _caption, _description, _aliases, _tags, _visibility, _deprecated, _allowNull, _defaultValue, _serviceWritable, _requiresData);
        this.slot = _slot;
        this.type = _type;
        this.min = _min;
        this.max = _max;
    }

    protected PalettePropertyDef clone(String _caption, String _description, List<String> _aliases, List<String> _tags, PropertyVisibility _visibility, IPaletteResolver _defaultValue) {
        return new PalettePropertyDef(this.name, _caption, _description, _aliases, _tags, _visibility, this.deprecated, this.allowNull, _defaultValue, this.serviceWritable, this.requiresData, this.slot, this.type, this.min, this.max);
    }

    @Override
    protected IPaletteResolver parseImpl(Object _value, IPaletteResolver _fallback) {
        switch (this.type) {
            case Cat: {
                if (!(_value instanceof ICatPaletteResolver)) break;
                return (ICatPaletteResolver)_value;
            }
            case Cont: {
                if (!(_value instanceof IContPaletteResolver)) break;
                return (IContPaletteResolver)_value;
            }
            case CustomCat: {
                if (!(_value instanceof ICustomCatPaletteResolver)) break;
                return (ICustomCatPaletteResolver)_value;
            }
            case CustomCont: {
                if (!(_value instanceof ICustomContPaletteResolver)) break;
                return (ICustomContPaletteResolver)_value;
            }
            default: {
                throw new Error("Unsupported PaletteType: " + (Object)((Object)this.type));
            }
        }
        try {
            if (_value instanceof String) {
                return PalettePropertyDef.parse(this.type, (String)_value, this.allowNull, _fallback);
            }
            if (_value instanceof List) {
                return PalettePropertyDef.parse(this.type, (List)_value, this.allowNull, _fallback);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return _fallback;
    }

    public static IPaletteResolver parse(PaletteType _type, String _value, boolean _allowNull, IPaletteResolver _fallback) {
        if (_value != null) {
            switch (_type) {
                case Cat: {
                    return new CatPaletteResolver(_value);
                }
                case CustomCat: {
                    return new CustomCatPaletteResolver(_value);
                }
                case Cont: 
                case CustomCont: {
                    String linear = _value;
                    String divergent = null;
                    int i = _value.indexOf("|");
                    if (i >= 0) {
                        linear = _value.substring(0, i);
                        divergent = _value.substring(i + 1);
                    }
                    if (_type == PaletteType.Cont) {
                        return new ContPaletteResolver(linear, divergent);
                    }
                    return new CustomContPaletteResolver(linear, divergent);
                }
            }
            throw new Error("Unsupported PaletteType: " + (Object)((Object)_type));
        }
        if (!_allowNull) {
            if (_fallback == null) {
                throw new Error("Invalid fallback resolver provided");
            }
            return _fallback;
        }
        return null;
    }

    public static IPaletteResolver parse(PaletteType _type, List<?> _value, boolean _allowNull, IPaletteResolver _fallback) {
        if (_value != null) {
            switch (_type) {
                case Cat: {
                    return new CatPaletteResolver(_value);
                }
                case CustomCat: {
                    return new CustomCatPaletteResolver(_value);
                }
                case Cont: 
                case CustomCont: {
                    List linear = _value;
                    List divergent = null;
                    if (_value.size() == 2 && _value.get(0) instanceof List) {
                        linear = (List)_value.get(0);
                        divergent = (List)_value.get(1);
                    }
                    if (_type == PaletteType.Cont) {
                        return new ContPaletteResolver(linear, divergent);
                    }
                    return new CustomContPaletteResolver(linear, divergent);
                }
            }
            throw new Error("Unsupported PaletteType: " + (Object)((Object)_type));
        }
        if (!_allowNull) {
            if (_fallback == null) {
                throw new Error("Invalid fallback resolver provided");
            }
            return _fallback;
        }
        return null;
    }
}

