/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.vizdef;

import java.util.ArrayList;
import java.util.List;

public class PropertyOverride {
    public static final String DEFAULT_CAPTION;
    public static final String DEFAULT_DESCRIPTION;
    public static final Object DEFAULT_VALUE;
    public static final List<String> DEFAULT_ALIASES;
    public static final PropertyOverride Empty;
    private final String caption;
    private final String description;
    private final Object defaultValue;
    private final List<String> aliases;

    public String getCaption(String _actual) {
        return this.caption == DEFAULT_CAPTION ? _actual : this.caption;
    }

    public String getDescription(String _actual) {
        return this.description == DEFAULT_DESCRIPTION ? _actual : this.description;
    }

    public Object getDefaultValue(Object _actual) {
        return this.defaultValue == DEFAULT_VALUE ? _actual : this.defaultValue;
    }

    public List<String> getAliases(List<String> _actual) {
        return this.aliases == DEFAULT_ALIASES ? _actual : PropertyOverride.mergeAliases(this.aliases, _actual);
    }

    public boolean isEmpty() {
        return this == Empty || this.caption == DEFAULT_CAPTION && this.description == DEFAULT_DESCRIPTION && this.defaultValue == DEFAULT_VALUE && this.aliases == DEFAULT_ALIASES;
    }

    private PropertyOverride(String _caption, String _description, Object _defaultValue, List<String> _aliases) {
        this.caption = _caption;
        this.description = _description;
        this.defaultValue = _defaultValue;
        this.aliases = _aliases;
    }

    public static PropertyOverride create(String _caption, String _description, Object _defaultValue, List<String> _aliases) {
        if (_caption == DEFAULT_CAPTION && _description == DEFAULT_DESCRIPTION && _defaultValue == DEFAULT_VALUE && _aliases == DEFAULT_ALIASES) {
            return Empty;
        }
        return new PropertyOverride(_caption, _description, _defaultValue, _aliases);
    }

    private static List<String> mergeAliases(List<String> _aliases, List<String> _merge) {
        if (_merge == null || _merge.size() == 0 || _merge == _aliases) {
            return _aliases;
        }
        ArrayList<String> clone = _aliases == null ? new ArrayList<String>() : new ArrayList<String>(_aliases);
        for (String alias : _merge) {
            if (clone.contains(alias)) continue;
            clone.add(alias);
        }
        return clone;
    }

    public static PropertyOverride merge(PropertyOverride _current, PropertyOverride _merge) {
        if (_current == null || _current.isEmpty()) {
            return _merge == null || _merge.isEmpty() ? Empty : _merge;
        }
        if (_merge == null || _merge.isEmpty()) {
            return _current;
        }
        return new PropertyOverride(_merge.getCaption(_current.caption), _merge.getDescription(_current.description), _merge.getDefaultValue(_current.defaultValue), _merge.getAliases(_current.aliases));
    }

    static {
        DEFAULT_DESCRIPTION = DEFAULT_CAPTION = new String();
        DEFAULT_VALUE = new Object();
        DEFAULT_ALIASES = null;
        Empty = new PropertyOverride(DEFAULT_CAPTION, DEFAULT_DESCRIPTION, DEFAULT_VALUE, DEFAULT_ALIASES);
    }
}

