/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.vizdef;

import com.ibm.vipr.vizdef.Aggregation;
import com.ibm.vipr.vizdef.DefaultMapping;
import com.ibm.vipr.vizdef.FieldRole;
import com.ibm.vipr.vizdef.SlotOverride;
import com.ibm.vipr.vizdef.SlotSubType;
import com.ibm.vipr.vizdef.SlotType;
import java.util.Collections;
import java.util.List;

public class SlotDef {
    public final SlotType type;
    public final SlotSubType subType;
    public final boolean subTypeOptional;
    public final String name;
    public final boolean optional;
    public final String caption;
    public final String description;
    public final List<String> channels;
    public final boolean multiDataItem;
    public final int maxLevels;
    public final Aggregation aggregation;
    public final boolean suppressMissing;
    public final FieldRole role;
    public final DefaultMapping defaultMapping;
    public final boolean hidden;

    SlotDef(SlotType _type, SlotSubType _subType, boolean _subTypeOptional, String _name, boolean _optional, String _caption, String _description, boolean _multiDataItem, List<String> _channels, int _maxLevels, Aggregation _aggregation, boolean _suppressMissing, FieldRole _role, DefaultMapping _defaultMapping, boolean _hidden) {
        if (_type == null) {
            throw new IllegalArgumentException("_type cannot be null");
        }
        if (_subType == null) {
            throw new IllegalArgumentException("_subType cannot be null, use SlotSubType.None instead");
        }
        if (_aggregation == null) {
            throw new IllegalArgumentException("_aggregation cannot be null, use Aggregation.Auto for Cont or Any slots, and Aggregation.None for Cat slots");
        }
        if (_type == SlotType.Cat && _aggregation != Aggregation.None) {
            throw new IllegalArgumentException("_aggregation must be Aggregation.None for Cat slots");
        }
        if (_role == null) {
            throw new IllegalArgumentException("_role cannot be null, use FieldRole.Other instead");
        }
        if (_defaultMapping == null) {
            throw new IllegalArgumentException("_defaultMapping cannot be null, use DefaultMapping.None instead");
        }
        this.type = _type;
        this.subType = _subType;
        this.subTypeOptional = _subTypeOptional;
        this.name = _name;
        this.optional = _optional;
        this.caption = _caption;
        this.description = _description;
        this.multiDataItem = _multiDataItem;
        this.channels = Collections.unmodifiableList(_channels);
        this.maxLevels = _maxLevels;
        this.aggregation = _aggregation;
        this.suppressMissing = _suppressMissing;
        this.role = _role;
        this.defaultMapping = _defaultMapping;
        this.hidden = _hidden;
    }

    SlotDef override(SlotOverride _override) {
        if (_override.isEmpty().booleanValue()) {
            return this;
        }
        SlotType type = _override.getType(this.type);
        if (type != this.type && this.type != SlotType.Any) {
            throw new Error("Only the type of Any slots can be overridden");
        }
        boolean optional = _override.getOptional(this.optional);
        if (optional != this.optional && !this.optional) {
            throw new Error("Cannot make a mandatory slot optional");
        }
        Aggregation aggregation = _override.getAggregation(this.aggregation);
        if (aggregation != this.aggregation) {
            if (type == SlotType.Cat) {
                throw new Error("Cannot override aggregation for a Cat slot");
            }
            if (aggregation == Aggregation.None) {
                throw new Error("Cannot override aggregation to be None");
            }
        }
        return new SlotDef(type, this.subType, this.subTypeOptional, this.name, optional, _override.getCaption(this.caption), _override.getDescription(this.description), this.multiDataItem, this.channels, this.maxLevels, aggregation, _override.getSuppressMissing(this.suppressMissing), _override.getRole(this.role), _override.getDefaultMapping(this.defaultMapping), _override.getHidden(this.hidden));
    }

    public String toString() {
        return this.name;
    }
}

