/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.vizdef;

import com.ibm.vipr.vizdef.Aggregation;
import com.ibm.vipr.vizdef.DefaultMapping;
import com.ibm.vipr.vizdef.FieldRole;
import com.ibm.vipr.vizdef.SlotDef;
import com.ibm.vipr.vizdef.SlotSubType;
import com.ibm.vipr.vizdef.SlotType;
import java.util.List;

public class SlotRef {
    public final SlotType type;
    public final SlotSubType subType;
    public final boolean subTypeOptional;
    public final String name;
    public final boolean optional;
    public final String caption;
    public final String description;
    public final boolean multiDataItem;
    public final List<String> channels;
    public final int maxLevels;
    public final Aggregation aggregation;
    public final boolean suppressMissing;
    public final FieldRole role;
    public final DefaultMapping defaultMapping;
    public final boolean hidden;
    public final int dataSetIndex;
    private SlotRef reference;

    static SlotRef create(SlotDef _slot, boolean _optional, int _dataSetIndex) {
        return new SlotRef(_slot.type, _slot.subType, _slot.subTypeOptional, _slot.name, _optional, _slot.caption, _slot.description, _slot.multiDataItem, _slot.channels, _slot.maxLevels, _slot.aggregation, _slot.suppressMissing, _slot.role, _slot.defaultMapping, _slot.hidden, _dataSetIndex);
    }

    SlotRef(SlotType _type, SlotSubType _subType, boolean _subTypeOptional, String _name, boolean _optional, String _caption, String _description, boolean _multiDataItem, List<String> _channels, int _maxLevels, Aggregation _aggregation, boolean _suppressMissing, FieldRole _role, DefaultMapping _defaultMapping, boolean _hidden, int _dataSetIndex) {
        if (_type == null) {
            throw new IllegalArgumentException("_type cannot be null");
        }
        if (_subType == null) {
            throw new IllegalArgumentException("_subType cannot be null, use SlotSubType.None instead");
        }
        if (_aggregation == null) {
            throw new IllegalArgumentException("_aggregation cannot be null, use Aggregation.Auto for Cont or Any slots, and Aggregation.None for Cat slots");
        }
        if (_type == SlotType.Cat && _aggregation != Aggregation.None) {
            throw new IllegalArgumentException("_aggregation must be Aggregation.None for Cat slots");
        }
        if (_role == null) {
            throw new IllegalArgumentException("_role cannot be null, use FieldRole.Other instead");
        }
        if (_defaultMapping == null) {
            throw new IllegalArgumentException("_defaultMapping cannot be null, use DefaultMapping.None instead");
        }
        this.type = _type;
        this.subType = _subType;
        this.subTypeOptional = _subTypeOptional;
        this.name = _name;
        this.optional = _optional;
        this.caption = _caption;
        this.description = _description;
        this.multiDataItem = _multiDataItem;
        this.channels = _channels;
        this.maxLevels = _maxLevels;
        this.aggregation = _aggregation;
        this.suppressMissing = _suppressMissing;
        this.role = _role;
        this.defaultMapping = _defaultMapping;
        this.hidden = _hidden;
        this.dataSetIndex = _dataSetIndex;
        this.reference = null;
    }

    public SlotRef getReference() {
        return this.reference;
    }

    void setReference(SlotRef _reference) {
        if (this.subType != SlotSubType.Reference) {
            throw new Error("Reference can only be set on slots with SlotSubType.Reference");
        }
        if (this.reference != null) {
            throw new Error("Reference can only be set once");
        }
        if (_reference == this) {
            throw new Error("A slot cannot reference itself");
        }
        if (_reference == null) {
            throw new Error("Setting a null reference is not allowed");
        }
        if (_reference.type != this.type) {
            throw new Error("A " + (Object)((Object)this.type) + " slot can only reference a slot of the same type");
        }
        if (this.name.equals(_reference.name)) {
            throw new Error("Slot " + this.name + " cannot reference a slot with the same name");
        }
        this.reference = _reference;
    }
}

