/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.vizdef;

import com.ibm.vipr.property.PropertyVisibility;
import com.ibm.vipr.vizdef.PropertyDef;
import com.ibm.vipr.vizdef.PropertyOverride;
import com.ibm.vipr.vizdef.SlotDef;
import com.ibm.vipr.vizdef.SlotOverride;
import java.util.List;
import java.util.Map;

public class UserConfig {
    private final List<String> includeProps;
    private final List<String> excludeProps;
    private final Map<String, PropertyOverride> propOverrides;
    private final List<String> includeSlots;
    private final List<String> excludeSlots;
    private final Map<String, SlotOverride> slotOverrides;

    private static boolean containsAny(List<String> _target, String _name, List<String> _aliases) {
        return _target != null && (_target.contains(_name) || _aliases != null && _aliases.stream().anyMatch(_a -> _target.contains(_a)));
    }

    public boolean isEmpty() {
        return !(this.includeProps != null || this.excludeProps != null && !this.excludeProps.isEmpty() || this.propOverrides != null && !this.propOverrides.isEmpty() || this.includeSlots != null || this.excludeSlots != null && !this.excludeSlots.isEmpty() || this.slotOverrides != null && !this.slotOverrides.isEmpty());
    }

    public boolean isSlotListed(SlotDef _slot) {
        boolean include = this.includeSlots == null || this.includeSlots.contains(_slot.name);
        boolean exclude = this.excludeSlots != null && this.excludeSlots.contains(_slot.name);
        return include && !exclude;
    }

    public PropertyVisibility getImplicitVisibility() {
        return this.includeProps == null ? PropertyVisibility.Listed : PropertyVisibility.Excluded;
    }

    public PropertyVisibility getPropertyVisibility(PropertyDef _property, PropertyVisibility _implicitVisibility) {
        if (_property.visibility == PropertyVisibility.Configuration) {
            return _property.visibility;
        }
        if (UserConfig.containsAny(this.excludeProps, _property.name, _property.aliases)) {
            return PropertyVisibility.Excluded;
        }
        if (UserConfig.containsAny(this.includeProps, _property.name, _property.aliases)) {
            return PropertyVisibility.Listed;
        }
        return _implicitVisibility == PropertyVisibility.Listed && _property.deprecated ? _property.visibility : _implicitVisibility;
    }

    public PropertyOverride getPropertyOverride(PropertyDef _prop) {
        PropertyOverride result = PropertyOverride.Empty;
        if (_prop == null || this.propOverrides == null || this.propOverrides.size() == 0) {
            return result;
        }
        if (_prop.aliases != null) {
            for (String alias : _prop.aliases) {
                result = PropertyOverride.merge(result, this.propOverrides.get(alias));
            }
        }
        return PropertyOverride.merge(result, this.propOverrides.get(_prop.name));
    }

    public SlotOverride getSlotOverride(SlotDef _slot) {
        if (_slot == null || this.slotOverrides == null || this.slotOverrides.isEmpty()) {
            return SlotOverride.Empty;
        }
        return this.slotOverrides.containsKey(_slot.name) ? this.slotOverrides.get(_slot.name) : SlotOverride.Empty;
    }

    private UserConfig(List<String> _includeProps, List<String> _excludeProps, Map<String, PropertyOverride> _propOverrides, List<String> _includeSlots, List<String> _excludeSlots, Map<String, SlotOverride> _slotOverrides) {
        this.includeProps = _includeProps;
        this.excludeProps = _excludeProps;
        this.propOverrides = _propOverrides;
        this.includeSlots = _includeSlots;
        this.excludeSlots = _excludeSlots;
        this.slotOverrides = _slotOverrides;
    }

    public static UserConfig create(List<String> _includeProps, List<String> _excludeProps, Map<String, PropertyOverride> _propOverrides, List<String> _includeSlots, List<String> _excludeSlots, Map<String, SlotOverride> _slotOverrides) {
        return new UserConfig(_includeProps, _excludeProps, _propOverrides, _includeSlots, _excludeSlots, _slotOverrides);
    }
}

