/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.vizdef;

import com.ibm.vipr.property.PropertyType;
import com.ibm.vipr.property.PropertyVisibility;
import com.ibm.vipr.vizdef.CapabilityDef;
import com.ibm.vipr.vizdef.DataSetDef;
import com.ibm.vipr.vizdef.GeoSegmentDef;
import com.ibm.vipr.vizdef.GeoSegmentRef;
import com.ibm.vipr.vizdef.GeoSlotDef;
import com.ibm.vipr.vizdef.GeoSlotRef;
import com.ibm.vipr.vizdef.GroupPropertyDef;
import com.ibm.vipr.vizdef.MetaDataEntryDef;
import com.ibm.vipr.vizdef.PalettePropertyDef;
import com.ibm.vipr.vizdef.PropertyDef;
import com.ibm.vipr.vizdef.PropertyOverride;
import com.ibm.vipr.vizdef.SlotDef;
import com.ibm.vipr.vizdef.SlotGroupDef;
import com.ibm.vipr.vizdef.SlotRef;
import com.ibm.vipr.vizdef.SlotSubType;
import com.ibm.vipr.vizdef.TemporalSlotDef;
import com.ibm.vipr.vizdef.TemporalSlotRef;
import com.ibm.vipr.vizdef.UserConfig;
import com.ibm.vipr.vizdef.ValuePropertyDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class VizDef {
    private static final List<String> Empty = Collections.unmodifiableList(new ArrayList(0));
    public final VizDef source;
    public final List<SlotGroupDef> slotGroups;
    public final List<SlotDef> slots;
    public final List<DataSetDef> dataSets;
    public final List<PropertyDef> properties;
    public final List<ValuePropertyDef<?>> configuration;
    public final CapabilityDef capabilities;
    public final List<MetaDataEntryDef> metaDataEntries;
    private final Map<String, PropertyDef> propertyMap;
    private final Map<String, SlotDef> slotMap;
    private final Map<String, DataSetDef> dataSetMap;
    private final Map<String, MetaDataEntryDef> metaDataEntryMap;

    private static SlotDef findSlotDef(List<SlotDef> _list, String _name) {
        for (SlotDef slot : _list) {
            if (!slot.name.equals(_name)) continue;
            return slot;
        }
        return null;
    }

    private static DataSetDef findDataSetDef(ArrayList<DataSetDef> _dataSets, String _name) {
        for (DataSetDef dataSet : _dataSets) {
            if (!dataSet.name.equals(_name)) continue;
            return dataSet;
        }
        return null;
    }

    private static List<SlotGroupDef> filterSlots(List<SlotGroupDef> _groups, UserConfig _config, List<SlotDef> _allSlots) {
        ArrayList<SlotGroupDef> result = new ArrayList<SlotGroupDef>(_groups.size());
        boolean emptyConfig = _config == null || _config.isEmpty();
        for (SlotGroupDef group : _groups) {
            ArrayList<SlotDef> slots = new ArrayList<SlotDef>(group.slots.size());
            for (SlotDef slot : group.slots) {
                boolean list;
                if (!emptyConfig) {
                    if (slot.subType == SlotSubType.GeoSpatial) {
                        GeoSlotDef geoSlot = (GeoSlotDef)slot;
                        List<GeoSegmentDef> segments = geoSlot.segments;
                        segments = new ArrayList<GeoSegmentDef>(segments.size());
                        for (GeoSegmentDef segment : geoSlot.segments) {
                            list = _config.isSlotListed(segment = segment.override(_config.getSlotOverride(segment)));
                            if (!list && !segment.optional) {
                                list = true;
                            }
                            if (!list) continue;
                            segments.add(segment);
                        }
                        slot = geoSlot.override(_config.getSlotOverride(slot), segments);
                    } else {
                        slot = slot.override(_config.getSlotOverride(slot));
                    }
                }
                boolean bl = list = emptyConfig || _config.isSlotListed(slot);
                if (!list && !slot.optional) {
                    list = true;
                }
                if (!list) continue;
                if (!slot.hidden) {
                    slots.add(slot);
                }
                _allSlots.add(slot);
            }
            if (slots.size() <= 0) continue;
            result.add(new SlotGroupDef(group.caption, group.description, slots));
        }
        return result;
    }

    private static List<DataSetDef> filterDataSets(List<DataSetDef> _dataSets, List<SlotDef> _slots) {
        int dataSetIndex = 0;
        ArrayList<DataSetDef> dataSets = new ArrayList<DataSetDef>();
        ArrayList<SlotRefWithReference> slotsWithReference = new ArrayList<SlotRefWithReference>();
        for (DataSetDef dataSet : _dataSets) {
            boolean keepDataSet = true;
            ArrayList<SlotRef> slotRefs = new ArrayList<SlotRef>();
            for (SlotRef slotRef : dataSet.slots) {
                SlotDef slotDef = VizDef.findSlotDef(_slots, slotRef.name);
                if (slotDef == null) {
                    if (!slotRef.optional && !dataSet.optional) {
                        throw new Error("Trying to exclude mandatory slot ref " + slotRef.name + " on non-optional data set " + dataSet.name);
                    }
                    if (slotRef.optional || !dataSet.optional) continue;
                    keepDataSet = false;
                    continue;
                }
                SlotRef newSlotRef = VizDef.createSlotRef(slotDef, slotRef.optional, dataSetIndex);
                slotRefs.add(newSlotRef);
                SlotRef reference = slotRef.getReference();
                if (reference == null) continue;
                slotsWithReference.add(new SlotRefWithReference(newSlotRef, _dataSets.get((int)slotRef.dataSetIndex).name, reference.name));
            }
            if (!keepDataSet || slotRefs.size() <= 0) continue;
            dataSets.add(new DataSetDef(dataSetIndex++, slotRefs, dataSet.name, dataSet.optional, dataSet.suppressMissing, dataSet.needsSorted, dataSet.requiresValues, dataSet.uniqueDataPoints, dataSet.caption));
        }
        for (SlotRefWithReference slotRefLink : slotsWithReference) {
            SlotRef slotRef;
            DataSetDef dataSet = VizDef.findDataSetDef(dataSets, slotRefLink.dataSetName);
            SlotRef slotRef2 = slotRef = dataSet != null ? dataSet.getSlot(slotRefLink.slotName) : null;
            if (slotRef == null) {
                throw new Error("Configuration excluded the slot \"" + slotRefLink.slotName + "\" on data set \"" + slotRefLink.dataSetName + "\", yet slot \"" + slotRefLink.slot.name + "\" references it");
            }
            slotRefLink.slot.setReference(slotRef);
        }
        return dataSets;
    }

    private static List<PropertyDef> mapProperties(List<PropertyDef> _properties, UserConfig _config, PropertyVisibility _implicitVisibility, List<String> _parentTags, List<SlotDef> _slots) {
        ArrayList<PropertyDef> result = new ArrayList<PropertyDef>(_properties.size());
        for (PropertyDef node : _properties) {
            PropertyVisibility visibility;
            List<String> tags = VizDef.mergeTags(_parentTags, node.tags);
            PropertyOverride override = _config == null ? PropertyOverride.Empty : _config.getPropertyOverride(node);
            PropertyVisibility propertyVisibility = visibility = _config == null ? node.visibility : _config.getPropertyVisibility(node, _implicitVisibility);
            if (node.type == PropertyType.Group) {
                GroupPropertyDef group = (GroupPropertyDef)node;
                result.add(group.override(override, tags, null, VizDef.mapProperties(group.properties, _config, visibility, tags, _slots)));
                continue;
            }
            if (node.type == PropertyType.Palette && ((PalettePropertyDef)node).slot != null && VizDef.findSlotDef(_slots, ((PalettePropertyDef)node).slot.name) != null) {
                visibility = PropertyVisibility.Listed;
            }
            result.add(((ValuePropertyDef)node).override(override, tags, visibility));
        }
        return result;
    }

    private static List<ValuePropertyDef<?>> mapConfiguration(List<ValuePropertyDef<?>> _properties, UserConfig _config) {
        ArrayList result = new ArrayList(_properties.size());
        for (ValuePropertyDef<?> node : _properties) {
            result.add(node.override(_config == null ? PropertyOverride.Empty : _config.getPropertyOverride(node), node.tags, node.visibility));
        }
        return result;
    }

    private static List<String> mergeTags(List<String> tags1, List<String> tags2) {
        if (tags1.isEmpty()) {
            return tags2;
        }
        if (tags2.isEmpty()) {
            return tags1;
        }
        HashSet<String> merged = new HashSet<String>(tags1);
        merged.addAll(tags2);
        return new ArrayList<String>(merged);
    }

    private static void addProperties(Map<String, PropertyDef> _map, Iterable<? extends PropertyDef> _properties) {
        for (PropertyDef propertyDef : _properties) {
            if (propertyDef.type == PropertyType.Group) {
                VizDef.addProperties(_map, ((GroupPropertyDef)propertyDef).properties);
            }
            _map.put(propertyDef.name, propertyDef);
            for (String alias : propertyDef.aliases) {
                _map.put(alias, propertyDef);
            }
        }
    }

    public static VizDef applyUserConfig(VizDef _vizDef, UserConfig _config) {
        VizDef source = _vizDef.source != null ? _vizDef.source : _vizDef;
        List<SlotGroupDef> slotGroups = source.slotGroups;
        List<SlotDef> slots = source.slots;
        List<DataSetDef> dataSets = source.dataSets;
        List<PropertyDef> properties = source.properties;
        List<ValuePropertyDef<?>> configuration = source.configuration;
        properties = VizDef.mapProperties(_vizDef.properties, _config, _config == null ? PropertyVisibility.Listed : _config.getImplicitVisibility(), Empty, slots);
        configuration = VizDef.mapConfiguration(_vizDef.configuration, _config);
        if (_config != null && !_config.isEmpty()) {
            slots = new ArrayList<SlotDef>(slots.size());
            slotGroups = VizDef.filterSlots(slotGroups, _config, slots);
            dataSets = VizDef.filterDataSets(source.dataSets, slots);
        }
        return new VizDef(source, slotGroups, slots, dataSets, properties, configuration, _vizDef.capabilities, _vizDef.metaDataEntries);
    }

    public VizDef extend(SlotGroupDef _slotGroup, Iterable<PropertyDef> _properties, Iterable<ValuePropertyDef<?>> _configuration) {
        VizDef source = this.source != null ? this.source : this;
        List<SlotGroupDef> slotGroups = source.slotGroups;
        List<SlotDef> slots = source.slots;
        List<DataSetDef> dataSets = source.dataSets;
        List<PropertyDef> properties = source.properties;
        List<ValuePropertyDef<?>> configuration = source.configuration;
        if (_slotGroup != null) {
            slotGroups = new ArrayList<SlotGroupDef>(slotGroups);
            slotGroups.add(_slotGroup);
            slots = new ArrayList<SlotDef>(slots);
            slots.addAll(_slotGroup.slots);
            dataSets = new ArrayList<DataSetDef>(dataSets);
            int dataSetCount = dataSets.size();
            for (int iDataSet = 0; iDataSet < dataSetCount; ++iDataSet) {
                DataSetDef dataSetDef = dataSets.get(iDataSet);
                ArrayList<SlotRef> dataSetSlots = new ArrayList<SlotRef>(dataSetDef.slots.size() + _slotGroup.slots.size());
                for (SlotRef slotRef : dataSetDef.slots) {
                    dataSetSlots.add(slotRef);
                }
                for (SlotDef slot : _slotGroup.slots) {
                    dataSetSlots.add(VizDef.createSlotRef(slot, slot.optional, iDataSet));
                }
                dataSets.set(iDataSet, new DataSetDef(dataSetDef.index, dataSetSlots, dataSetDef.name, dataSetDef.optional, dataSetDef.suppressMissing, dataSetDef.needsSorted, dataSetDef.requiresValues, dataSetDef.uniqueDataPoints, dataSetDef.caption));
            }
        }
        if (_properties != null) {
            properties = VizDef.extendProperties(properties, _properties, source.propertyMap);
        }
        if (_configuration != null) {
            configuration = this.extendConfiguration(configuration, _configuration, source.propertyMap);
        }
        return new VizDef(null, slotGroups, slots, dataSets, properties, configuration, source.capabilities, source.metaDataEntries);
    }

    public static SlotRef createSlotRef(SlotDef _slot, boolean _optional, int _index) {
        switch (_slot.subType) {
            case GeoSpatial: {
                GeoSlotDef geoSlot = (GeoSlotDef)_slot;
                return GeoSlotRef.create(geoSlot, _optional, GeoSegmentRef.defsToRefs(geoSlot.segments, _index), _index);
            }
            case Temporal: {
                return TemporalSlotRef.create((TemporalSlotDef)_slot, _optional, _index);
            }
        }
        return SlotRef.create(_slot, _optional, _index);
    }

    private static List<PropertyDef> extendProperties(List<PropertyDef> _properties, Iterable<PropertyDef> _toMerge, Map<String, PropertyDef> _lookup) {
        ArrayList<PropertyDef> result = new ArrayList<PropertyDef>(_properties);
        for (PropertyDef mergeNode : _toMerge) {
            PropertyDef toAdd;
            PropertyDef existing = _lookup.get(mergeNode.name);
            int at = result.size();
            if (existing != null) {
                if (existing.type != PropertyType.Group || mergeNode.type != PropertyType.Group) {
                    throw new Error("VizDef extend property name conflict");
                }
                at = _properties.indexOf(existing);
                toAdd = ((GroupPropertyDef)existing).clone(_properties);
            } else {
                toAdd = mergeNode.type == PropertyType.Group ? ((GroupPropertyDef)mergeNode).clone(_properties) : mergeNode;
            }
            if (at < result.size()) {
                result.set(at, toAdd);
                continue;
            }
            result.add(toAdd);
        }
        return result;
    }

    private List<ValuePropertyDef<?>> extendConfiguration(List<ValuePropertyDef<?>> _configuration, Iterable<ValuePropertyDef<?>> _toMerge, Map<String, PropertyDef> _lookup) {
        ArrayList result = new ArrayList(_configuration);
        for (ValuePropertyDef<?> mergeNode : _toMerge) {
            if (_lookup.containsKey(mergeNode.name)) {
                throw new Error("VizDef extend property name conflict");
            }
            result.add(mergeNode);
        }
        return result;
    }

    static VizDef create(List<SlotGroupDef> _slotGroups, List<SlotDef> _slots, List<DataSetDef> _dataSets, List<PropertyDef> _properties, List<ValuePropertyDef<?>> _configuration, CapabilityDef _capabilities, List<MetaDataEntryDef> _metaDataEntries) {
        return new VizDef(null, _slotGroups, _slots, _dataSets, _properties, _configuration, _capabilities, _metaDataEntries);
    }

    private VizDef(VizDef _source, List<SlotGroupDef> _slotGroups, List<SlotDef> _slots, List<DataSetDef> _dataSets, List<PropertyDef> _properties, List<ValuePropertyDef<?>> _configuration, CapabilityDef _capabilities, List<MetaDataEntryDef> _metaDataEntries) {
        this.slotGroups = Collections.unmodifiableList(_slotGroups);
        this.slots = Collections.unmodifiableList(_slots);
        this.dataSets = Collections.unmodifiableList(_dataSets);
        this.properties = Collections.unmodifiableList(_properties);
        this.configuration = Collections.unmodifiableList(_configuration);
        this.capabilities = _capabilities;
        this.metaDataEntries = Collections.unmodifiableList(_metaDataEntries);
        this.source = _source;
        this.propertyMap = new HashMap<String, PropertyDef>();
        VizDef.addProperties(this.propertyMap, this.properties);
        VizDef.addProperties(this.propertyMap, this.configuration);
        this.slotMap = new HashMap<String, SlotDef>();
        this.slots.forEach(_slot -> this.slotMap.put(_slot.name, (SlotDef)_slot));
        this.dataSetMap = new HashMap<String, DataSetDef>();
        this.dataSets.forEach(_ds -> this.dataSetMap.put(_ds.name, (DataSetDef)_ds));
        this.metaDataEntryMap = new HashMap<String, MetaDataEntryDef>();
        this.metaDataEntries.forEach(_entry -> this.metaDataEntryMap.put(_entry.name, (MetaDataEntryDef)_entry));
    }

    public PropertyDef getProperty(String _name) {
        return this.propertyMap.get(_name);
    }

    public SlotDef getSlot(String _name) {
        return this.slotMap.get(_name);
    }

    public DataSetDef getDataSet(String _name) {
        return this.dataSetMap.get(_name);
    }

    public MetaDataEntryDef getMetaDataEntry(String _name) {
        return this.metaDataEntryMap.get(_name);
    }

    private static class SlotRefWithReference {
        public final SlotRef slot;
        public final String dataSetName;
        public final String slotName;

        public SlotRefWithReference(SlotRef _slot, String _dataSetName, String _slotName) {
            this.slot = _slot;
            this.dataSetName = _dataSetName;
            this.slotName = _slotName;
        }
    }
}

