/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.vizdef;

import com.ibm.vipr.api.IPaletteResolver;
import com.ibm.vipr.api.PaletteType;
import com.ibm.vipr.info.InfoType;
import com.ibm.vipr.internal.util.VIPRNls;
import com.ibm.vipr.internal.util.XmlParser;
import com.ibm.vipr.property.EnumValue;
import com.ibm.vipr.property.PropertyType;
import com.ibm.vipr.property.PropertyVisibility;
import com.ibm.vipr.util.CatPaletteResolver;
import com.ibm.vipr.util.ContPaletteResolver;
import com.ibm.vipr.util.CustomCatPaletteResolver;
import com.ibm.vipr.util.CustomContPaletteResolver;
import com.ibm.vipr.vizdef.Aggregation;
import com.ibm.vipr.vizdef.BooleanPropertyDef;
import com.ibm.vipr.vizdef.CapabilityDef;
import com.ibm.vipr.vizdef.ColorPropertyDef;
import com.ibm.vipr.vizdef.DataSetDef;
import com.ibm.vipr.vizdef.DecorationDef;
import com.ibm.vipr.vizdef.DefaultMapping;
import com.ibm.vipr.vizdef.EnumPropertyDef;
import com.ibm.vipr.vizdef.FieldRole;
import com.ibm.vipr.vizdef.FontPropertyDef;
import com.ibm.vipr.vizdef.GeoSegmentDef;
import com.ibm.vipr.vizdef.GeoSlotDef;
import com.ibm.vipr.vizdef.GeoSpatialPart;
import com.ibm.vipr.vizdef.GroupPropertyDef;
import com.ibm.vipr.vizdef.LengthPropertyDef;
import com.ibm.vipr.vizdef.MetaDataEntryDef;
import com.ibm.vipr.vizdef.NumberPropertyDef;
import com.ibm.vipr.vizdef.PalettePropertyDef;
import com.ibm.vipr.vizdef.PropertyDef;
import com.ibm.vipr.vizdef.SlotDef;
import com.ibm.vipr.vizdef.SlotGroupDef;
import com.ibm.vipr.vizdef.SlotRef;
import com.ibm.vipr.vizdef.SlotSubType;
import com.ibm.vipr.vizdef.SlotType;
import com.ibm.vipr.vizdef.StringPropertyDef;
import com.ibm.vipr.vizdef.TemporalAttributeDef;
import com.ibm.vipr.vizdef.TemporalLevel;
import com.ibm.vipr.vizdef.TemporalSlotDef;
import com.ibm.vipr.vizdef.ValuePropertyDef;
import com.ibm.vipr.vizdef.VizDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VizDefParser {
    private static final List<IPaletteResolver> DefaultCatResolvers = Arrays.asList(new CatPaletteResolver("#319bd4;#86c43b;#f5ce22;#cf6c1b;#9380e8;#8555b5;#52d9bc;#24a399;#14665e;#a4bceb;#77a3e0;#396cb3;#1d4273;#c8d119;#acb336;#828a16;#5a610f;#e8b7cb;#e086b6;#b33681;#73154d"), new CatPaletteResolver("#5aaafa;#4178be;#af6ee8;#a6266e;#d74108;#ff7832;#fdd600;#00b4a0;#008571;#264a60;#7cc7ff;#7c1c58;#ff3ca0;#e71d32;#a53725;#efc100;#be9b00;#8cd211;#4b8400"), new CatPaletteResolver("#4d7aad;#86a9d9;#ce202c;#264a60;#5596e6;#959595;#464646;#4178be;#6d120f;#aeaeae;#645a5a;#dec0b2;#4178be;#a53725;#c7c7c7;#8c7300;#734098;#264a60;#739433;#1896bc"), new CatPaletteResolver("#1ec0d7;#0992da;#aeb6b6;#1dcdd8;#72b8f1;#e4ae80;#eccab7;#6b9bb3;#99d0dc;#c5baae;#1eadc8;#de9f5b;#ebac92;#e09085;#a8662d;#0193b8;#417380;#8fcbfd;#148fd3;#00b4a0"));
    private static final List<IPaletteResolver> DefaultCustomCatResolvers = Arrays.asList(new CustomCatPaletteResolver("#319bd4;#86c43b;#f5ce22;#cf6c1b;#9380e8;#8555b5;#52d9bc;#24a399;#14665e;#a4bceb;#77a3e0;#396cb3;#1d4273;#c8d119;#acb336;#828a16;#5a610f;#e8b7cb;#e086b6;#b33681;#73154d"), new CustomCatPaletteResolver("#5aaafa;#4178be;#af6ee8;#a6266e;#d74108;#ff7832;#fdd600;#00b4a0;#008571;#264a60;#7cc7ff;#7c1c58;#ff3ca0;#e71d32;#a53725;#efc100;#be9b00;#8cd211;#4b8400"), new CustomCatPaletteResolver("#4d7aad;#86a9d9;#ce202c;#264a60;#5596e6;#959595;#464646;#4178be;#6d120f;#aeaeae;#645a5a;#dec0b2;#4178be;#a53725;#c7c7c7;#8c7300;#734098;#264a60;#739433;#1896bc"), new CustomCatPaletteResolver("#1ec0d7;#0992da;#aeb6b6;#1dcdd8;#72b8f1;#e4ae80;#eccab7;#6b9bb3;#99d0dc;#c5baae;#1eadc8;#de9f5b;#ebac92;#e09085;#a8662d;#0193b8;#417380;#8fcbfd;#148fd3;#00b4a0"));
    private static final List<IPaletteResolver> DefaultContResolvers = Arrays.asList(new ContPaletteResolver("#c0e6ff;#7cc7ff;#5aaafa;#5596e6;#4178be;#325c80;#264a60", "#ce202c;#ff5050;#f79d9d;#e8bfc9;#e9e0e0;#b4d8f0;#7cc7ff;#5596e6;#4178be"), new ContPaletteResolver("#c8f08f;#b4e051;#8cd211;#5aa700;#4b8400;#2d660a;#144d14", "#4178be;#5596e6;#7cc7ff;#b4d8f0;#dfe9e9;#bbe085;#8cd211;#5aa700;#4b8400"), new ContPaletteResolver("#a7fae6;#6eedd8;#41d6c3;#00b4a0;#008571;#006d5d;#005448", "#008571;#00b4a0;#41d6c3;#65dbc7;#dfe9e9;#d7aaff;#ba8ff7;#af6ee8;#9855d4"));
    private static final List<IPaletteResolver> DefaultCustomContResolvers = Arrays.asList(new CustomContPaletteResolver("#c0e6ff;#7cc7ff;#5aaafa;#5596e6;#4178be;#325c80;#264a60", "#ce202c;#ff5050;#f79d9d;#e8bfc9;#e9e0e0;#b4d8f0;#7cc7ff;#5596e6;#4178be"), new CustomContPaletteResolver("#c8f08f;#b4e051;#8cd211;#5aa700;#4b8400;#2d660a;#144d14", "#4178be;#5596e6;#7cc7ff;#b4d8f0;#dfe9e9;#bbe085;#8cd211;#5aa700;#4b8400"), new CustomContPaletteResolver("#a7fae6;#6eedd8;#41d6c3;#00b4a0;#008571;#006d5d;#005448", "#008571;#00b4a0;#41d6c3;#65dbc7;#dfe9e9;#d7aaff;#ba8ff7;#af6ee8;#9855d4"));
    private static final List<Node> EMPTY_NODES = Collections.unmodifiableList(new ArrayList(0));
    private static final List<String> EMPTY_STRINGS = Collections.unmodifiableList(new ArrayList(0));
    private static final Pattern reSlot = Pattern.compile("^slot$", 2);
    private static final Pattern reSlotGroup = Pattern.compile("^group$", 2);
    private static final Pattern reDataSet = Pattern.compile("^dataset$", 2);
    private static final Pattern reMetaData = Pattern.compile("^metadataentry$", 2);
    private static final Pattern reSegment = Pattern.compile("^segment$", 2);
    private static final Pattern reAttribute = Pattern.compile("^attribute$", 2);
    private static final Pattern rePossibleValue = Pattern.compile("^possiblevalue$", 2);
    private static final Pattern reDecoration = Pattern.compile("^decoration$", 2);
    private static final Pattern reDecorations = Pattern.compile("^decorations$", 2);
    private static final Pattern reRef = Pattern.compile("^ref$", 2);
    private static final Pattern reValidType = Pattern.compile("^(?:boolean|number|string|array)$");

    private static List<IPaletteResolver> getDefaultResolvers(PaletteType _type) {
        switch (_type) {
            case Cat: {
                return DefaultCatResolvers;
            }
            case CustomCat: {
                return DefaultCustomCatResolvers;
            }
            case Cont: {
                return DefaultContResolvers;
            }
            case CustomCont: {
                return DefaultCustomContResolvers;
            }
        }
        throw new Error("Invalid PaletteType: " + (Object)((Object)_type));
    }

    private static SlotDef findSlot(List<SlotDef> _slots, String _name) {
        ListIterator<SlotDef> it = _slots.listIterator();
        while (it.hasNext()) {
            SlotDef slot = it.next();
            if (!slot.name.equalsIgnoreCase(_name)) continue;
            return slot;
        }
        return null;
    }

    private static boolean hasMandatoryContSlot(List<SlotRef> _slots) {
        int len = _slots.size();
        for (int i = 0; i < len; ++i) {
            SlotRef slot = _slots.get(i);
            if (slot.optional || slot.type != SlotType.Cont) continue;
            return true;
        }
        return false;
    }

    private static TemporalAttributeDef attributeDefFromXml(Node _node) {
        String levelStr = XmlParser.stringAttr(_node, "level", null);
        TemporalLevel level = TemporalLevel.parse(levelStr);
        if (level == null) {
            throw new Error("Invalid Level: " + levelStr);
        }
        boolean optional = XmlParser.boolAttr(_node, "optional", false);
        return new TemporalAttributeDef(level, optional);
    }

    private static GeoSegmentDef segmentDefFromXml(Node _node, String _parentName, DefaultMapping _mapping, boolean _hidden, boolean _suppressMissing, Aggregation _parentAggregation, FieldRole _parentRole, VIPRNls _nls) {
        String roleStr;
        FieldRole role;
        if (_node == null) {
            return null;
        }
        String partStr = XmlParser.stringAttr(_node, "part", null);
        GeoSpatialPart part = GeoSpatialPart.parse(partStr);
        if (part == null) {
            throw new Error("Invalid part \"" + (Object)((Object)part) + "\", must be latitude, longitude, featureId or caption");
        }
        String caption = _nls.resolve(XmlParser.stringAttr(_node, "caption", partStr));
        String description = _nls.resolve(XmlParser.stringAttr(_node, "description", null));
        boolean optional = XmlParser.boolAttr(_node, "optional", false);
        String aggregationStr = XmlParser.stringAttr(_node, "aggregation", null);
        Aggregation aggregation = Aggregation.parse(aggregationStr);
        if (aggregation == null) {
            if (aggregationStr != null) {
                throw new Error("Invalid Aggregation: " + aggregationStr);
            }
            aggregation = part == GeoSpatialPart.Latitude || part == GeoSpatialPart.Longitude ? Aggregation.None : _parentAggregation;
        }
        if ((role = FieldRole.parse(roleStr = XmlParser.stringAttr(_node, "role", _parentRole.value()))) == null) {
            throw new Error("Invalid FieldRole: " + roleStr);
        }
        return GeoSegmentDef.create(_parentName, _mapping, _hidden, _suppressMissing, optional, caption, description, aggregation, role, part);
    }

    private static SlotDef slotDefFromXml(Node _slotNode, VIPRNls _nls) {
        String defaultMappingStr;
        DefaultMapping defaultMapping;
        String name = XmlParser.stringAttr(_slotNode, "name", null);
        if (name == null) {
            throw new Error("A slot name is mandatory");
        }
        String typeStr = XmlParser.stringAttr(_slotNode, "type", null);
        if (typeStr == null) {
            throw new Error("A slot type is mandatory (slot: " + name + ")");
        }
        SlotType type = SlotType.parse(typeStr);
        if (type == null) {
            throw new Error("Invalid Slot type: " + typeStr + " (slot: " + name + ")");
        }
        String subTypeStr = XmlParser.stringAttr(_slotNode, "subType", SlotSubType.None.value());
        SlotSubType subType = SlotSubType.parse(subTypeStr);
        if (subType == null) {
            throw new Error("Invalid SlotSubType: " + subTypeStr + " (slot: " + name + ")");
        }
        if ((subType == SlotSubType.GeoSpatial || subType == SlotSubType.Temporal) && type != SlotType.Cat) {
            throw new Error("SlotSubType " + (Object)((Object)subType) + " is only valid for SlotType.Cat");
        }
        boolean subTypeOptional = XmlParser.boolAttr(_slotNode, "subTypeOptional", false);
        String caption = _nls.resolve(XmlParser.stringAttr(_slotNode, "caption", name));
        String description = _nls.resolve(XmlParser.stringAttr(_slotNode, "description", null));
        boolean optional = XmlParser.boolAttr(_slotNode, "optional", type != SlotType.Cont);
        List<String> channel = XmlParser.commaSeparatedAttr(_slotNode, "channel", EMPTY_STRINGS);
        boolean multiDataItem = XmlParser.boolAttr(_slotNode, "multi", false);
        int maxLevels = type == SlotType.Cont ? 1 : Integer.parseInt(XmlParser.stringAttr(_slotNode, "maxLevels", "-1"));
        String aggregationStr = XmlParser.stringAttr(_slotNode, "aggregation", null);
        Aggregation aggregation = Aggregation.parse(aggregationStr);
        if (aggregation == null) {
            if (aggregationStr != null) {
                throw new Error("Invalid Aggregation: " + aggregationStr + " (slot: " + name + ")");
            }
            Aggregation aggregation2 = aggregation = type == SlotType.Cat ? Aggregation.None : Aggregation.Auto;
        }
        if (type == SlotType.Cat && aggregation != Aggregation.None) {
            throw new Error("A Cat slot cannot have an aggregation other than Aggregation.None, found: " + (Object)((Object)aggregation) + " (slot: " + name + ")");
        }
        String roleStr = XmlParser.stringAttr(_slotNode, "role", null);
        FieldRole role = FieldRole.parse(roleStr);
        if (role == null) {
            if (roleStr != null) {
                throw new Error("Invalid FieldRole: " + roleStr + " (slot: " + name + ")");
            }
            role = FieldRole.Other;
        }
        if ((defaultMapping = DefaultMapping.parse(defaultMappingStr = XmlParser.stringAttr(_slotNode, "defaultMapping", DefaultMapping.None.value()))) == null) {
            throw new Error("Invalid DefaultMapping: " + defaultMappingStr + " (slot: " + name + ")");
        }
        boolean suppressMissing = type != SlotType.Cont && XmlParser.boolAttr(_slotNode, "suppressMissing", false);
        boolean hidden = XmlParser.boolAttr(_slotNode, "hidden", false);
        switch (subType) {
            case GeoSpatial: {
                List<Node> segmentNodes = XmlParser.filterChildElementsByTag(_slotNode, reSegment);
                if (segmentNodes.isEmpty()) {
                    throw new Error("No segments found (slot: " + name + ")");
                }
                ArrayList<GeoSegmentDef> segments = new ArrayList<GeoSegmentDef>(segmentNodes.size());
                int len = segmentNodes.size();
                for (int i = 0; i < len; ++i) {
                    segments.add(VizDefParser.segmentDefFromXml(segmentNodes.get(i), name, defaultMapping, hidden, suppressMissing, aggregation, role, _nls));
                }
                return new GeoSlotDef(subTypeOptional, name, optional, caption, description, multiDataItem, channel, maxLevels, aggregation, suppressMissing, role, defaultMapping, segments, hidden);
            }
            case Temporal: {
                List<Node> attributeNodes = XmlParser.filterChildElementsByTag(_slotNode, reAttribute);
                if (attributeNodes.isEmpty()) {
                    throw new Error("No attributes found (slot: " + name + ")");
                }
                ArrayList<TemporalAttributeDef> attributes = new ArrayList<TemporalAttributeDef>(attributeNodes.size());
                int len = attributeNodes.size();
                for (int i = 0; i < len; ++i) {
                    attributes.add(VizDefParser.attributeDefFromXml(attributeNodes.get(i)));
                }
                return new TemporalSlotDef(subTypeOptional, name, optional, caption, description, multiDataItem, channel, maxLevels, aggregation, suppressMissing, role, defaultMapping, attributes, hidden);
            }
        }
        return new SlotDef(type, subType, subTypeOptional, name, optional, caption, description, multiDataItem, channel, maxLevels, aggregation, suppressMissing, role, defaultMapping, hidden);
    }

    private static SlotGroupDef slotGroupDefFromXml(Node _slotGroupNode, VIPRNls _nls) {
        if (_slotGroupNode == null) {
            return null;
        }
        String caption = XmlParser.stringAttr(_slotGroupNode, "caption", null);
        if (caption == null) {
            throw new Error("A SlotGroup must have a caption");
        }
        caption = _nls.resolve(caption);
        String description = _nls.resolve(XmlParser.stringAttr(_slotGroupNode, "description", null));
        List<Node> slotNodes = XmlParser.filterChildElementsByTag(_slotGroupNode, reSlot);
        ArrayList<SlotDef> slots = new ArrayList<SlotDef>(slotNodes.size());
        int len = slotNodes.size();
        for (int i = 0; i < len; ++i) {
            slots.add(VizDefParser.slotDefFromXml(slotNodes.get(i), _nls));
        }
        return new SlotGroupDef(caption, description, slots);
    }

    /*
     * WARNING - void declaration
     */
    private static DataSetDef dataSetDefFromXml(Node _dataSetNode, int _dataSetIndex, SlotResolver _resolver, VIPRNls _nls, int _dataSetCount, List<SlotRefWithReference> _references) {
        void var10_14;
        String iterate;
        if (_dataSetNode == null) {
            return null;
        }
        boolean dataSetOptional = XmlParser.boolAttr(_dataSetNode, "optional", false);
        List<Node> slotNodes = XmlParser.filterChildElementsByTag(_dataSetNode, reRef);
        ArrayList<SlotRef> slots = new ArrayList<SlotRef>(slotNodes.size());
        for (Node node : slotNodes) {
            String slotName = XmlParser.stringAttr(node, "slot", null);
            if (slotName == null) {
                throw new Error("Slot reference missing slot property");
            }
            SlotDef slot = _resolver.resolve(slotName);
            if (slot == null) {
                throw new Error("Could not resolve slot " + slotName);
            }
            boolean slotRefOptional = XmlParser.boolAttr(node, "optional", slot.optional);
            if (!dataSetOptional && !slotRefOptional && slot.optional) {
                throw new Error("Slot reference \"" + slotName + "\" is not optional and used on a non optional DataSet, yet the referenced slot is marked optional");
            }
            SlotRef ref = VizDef.createSlotRef(slot, slotRefOptional, _dataSetIndex);
            slots.add(ref);
            slotName = XmlParser.stringAttr(node, "reference", null);
            if (slotName == null) continue;
            int idx = slotName.indexOf(58);
            if (idx < 0) {
                throw new Error("Invalid slot reference: " + slotName + ", syntax is dataSetName:slotName");
            }
            _references.add(new SlotRefWithReference(ref, slotName.substring(0, idx), slotName.substring(idx + 1)));
        }
        switch (iterate = XmlParser.stringAttr(_dataSetNode, "iterate", "default").toLowerCase()) {
            case "default": 
            case "sorted": 
            case "all": {
                break;
            }
            default: {
                throw new Error("Invalid iterate value: " + iterate);
            }
        }
        String string = "data";
        if (_dataSetCount > 1) {
            String string2 = string + _dataSetIndex;
        }
        String string3 = XmlParser.stringAttr(_dataSetNode, "name", (String)var10_14);
        boolean suppressMissing = !"all".equals(iterate);
        boolean uniqueDataPoints = XmlParser.boolAttr(_dataSetNode, "uniqueDataPoints", true);
        if (!suppressMissing && !uniqueDataPoints) {
            throw new Error("DataSets with iterate=\"all\" must have uniqueDataPoints true (the default)");
        }
        return new DataSetDef(_dataSetIndex, slots, string3, dataSetOptional, suppressMissing, !"default".equals(iterate), XmlParser.boolAttr(_dataSetNode, "requiresValues", VizDefParser.hasMandatoryContSlot(slots)), uniqueDataPoints, _nls.resolve(XmlParser.stringAttr(_dataSetNode, "caption", _nls.get("dataset_defaultName"))));
    }

    private static DecorationDef decorationDefFromXml(Node _decorationNode, SlotResolver _slotResolver) {
        if (_decorationNode == null) {
            return null;
        }
        SlotDef targetSlot = null;
        SlotDef referenceSlot = null;
        String name = XmlParser.stringAttr(_decorationNode, "name", null);
        String type = XmlParser.stringAttr(_decorationNode, "type", null);
        if (type == null) {
            throw new Error("Decoration " + name + " is missing a type");
        }
        if (!reValidType.matcher(type).matches()) {
            throw new Error("Decoration " + name + " has an unsupported type: " + type);
        }
        type = type.toLowerCase();
        List<String> target = XmlParser.commaSeparatedAttr(_decorationNode, "target", null);
        if (target == null || target.size() == 0) {
            throw new Error("Decoration " + name + " is missing targets, at least 1 target is required");
        }
        String targetSlotName = XmlParser.stringAttr(_decorationNode, "targetSlot", null);
        if (targetSlotName != null && (targetSlot = _slotResolver.resolve(targetSlotName)) == null) {
            throw new Error("Decoration " + name + " references non-existing slot: " + targetSlotName + " in the targetSlot definition");
        }
        String referenceSlotName = XmlParser.stringAttr(_decorationNode, "referenceSlot", null);
        if (referenceSlotName != null && (referenceSlot = _slotResolver.resolve(referenceSlotName)) == null) {
            throw new Error("Decoration " + name + " references non-existing slot: " + referenceSlotName + " in the referenceSlot definition");
        }
        ArrayList<InfoType> targets = new ArrayList<InfoType>(target.size());
        int len = target.size();
        for (int i = 0; i < len; ++i) {
            String entry = target.get(i);
            InfoType infoType = InfoType.parse(entry);
            if (infoType == null) {
                throw new Error("Invalid decoration target: " + entry);
            }
            targets.add(infoType);
        }
        boolean deprecated = XmlParser.boolAttr(_decorationNode, "deprecated", false);
        return new DecorationDef(name, type, targets, targetSlot, referenceSlot, deprecated);
    }

    private static PropertyDef propertyDefFromXml(Node _propertyNode, boolean _configuration, List<SlotDef> _slots, VIPRNls _nls, Map<PaletteType, Integer> _ofType) {
        PropertyVisibility visibility;
        if (_propertyNode == null) {
            return null;
        }
        String name = XmlParser.stringAttr(_propertyNode, "name", "");
        if (name.isEmpty()) {
            throw new Error("A property or group must have a name");
        }
        String typeStr = _propertyNode.getNodeName().toLowerCase();
        PropertyType type = null;
        if ("property".equals(typeStr) && (typeStr = XmlParser.stringAttr(_propertyNode, "type", null)) == null) {
            throw new Error("Property " + name + " is missing a type");
        }
        type = PropertyType.parse(typeStr);
        if (type == null) {
            throw new Error("Invalid type: " + typeStr);
        }
        String caption = _nls.resolve(XmlParser.stringAttr(_propertyNode, "caption", name));
        String description = _nls.resolve(XmlParser.stringAttr(_propertyNode, "description", null));
        List<String> aliases = XmlParser.commaSeparatedAttr(_propertyNode, "alias", EMPTY_STRINGS);
        List<String> tags = XmlParser.commaSeparatedAttr(_propertyNode, "tags", EMPTY_STRINGS);
        PropertyVisibility propertyVisibility = visibility = _configuration ? PropertyVisibility.Configuration : PropertyVisibility.Listed;
        if (type == PropertyType.Group) {
            List<Node> propNodes = XmlParser.filterChildElements(_propertyNode);
            int len = propNodes.size();
            if (len < 1) {
                throw new Error("Empty group: " + name);
            }
            boolean deprecated = true;
            boolean allExcluded = !_configuration;
            ArrayList<PropertyDef> props = new ArrayList<PropertyDef>(len);
            for (int i = 0; i < len; ++i) {
                PropertyDef child = VizDefParser.propertyDefFromXml(propNodes.get(i), _configuration, _slots, _nls, _ofType);
                if (deprecated && !child.deprecated) {
                    deprecated = false;
                }
                if (allExcluded && child.visibility != PropertyVisibility.Excluded) {
                    allExcluded = false;
                }
                props.add(child);
            }
            if (allExcluded) {
                visibility = PropertyVisibility.Excluded;
            }
            return new GroupPropertyDef(name, caption, description, aliases, tags, visibility, deprecated, props);
        }
        boolean deprecated = XmlParser.boolAttr(_propertyNode, "deprecated", false);
        boolean allowNull = XmlParser.boolAttr(_propertyNode, "allowNull", false);
        String defaultValueStr = XmlParser.stringAttr(_propertyNode, "defaultValue", null);
        boolean serviceWritable = XmlParser.boolAttr(_propertyNode, "writable", false);
        if (deprecated && serviceWritable) {
            throw new Error("Deprecated property " + name + " cannot be writable, its value must be updated via the deprecated property API");
        }
        boolean requiresData = XmlParser.boolAttr(_propertyNode, "requiresData", false);
        if (!_configuration && deprecated) {
            visibility = PropertyVisibility.Excluded;
        }
        switch (type) {
            case Boolean: {
                return new BooleanPropertyDef(name, caption, description, aliases, tags, visibility, deprecated, allowNull, BooleanPropertyDef.parse(defaultValueStr, allowNull, null), serviceWritable, requiresData);
            }
            case Color: {
                return new ColorPropertyDef(name, caption, description, aliases, tags, visibility, deprecated, allowNull, ColorPropertyDef.parse(defaultValueStr, allowNull, null), serviceWritable, requiresData);
            }
            case Enum: {
                List<Node> possibleValueNodes = XmlParser.filterChildElementsByTag(_propertyNode, rePossibleValue);
                if (possibleValueNodes.size() == 0) {
                    throw new Error("An enum type should have at least 1 possible value.");
                }
                ArrayList<EnumValue> possibleValues = new ArrayList<EnumValue>(possibleValueNodes.size());
                int len = possibleValueNodes.size();
                for (int i = 0; i < len; ++i) {
                    Node node = possibleValueNodes.get(i);
                    String enumName = XmlParser.getTextContent(node);
                    EnumValue enumValue = new EnumValue(enumName, _nls.resolve(XmlParser.stringAttr(node, "caption", enumName)), _nls.resolve(XmlParser.stringAttr(node, "description", null)));
                    possibleValues.add(enumValue);
                }
                return new EnumPropertyDef(name, caption, description, aliases, tags, visibility, deprecated, allowNull, EnumPropertyDef.parse(defaultValueStr, allowNull, possibleValues, null), serviceWritable, requiresData, possibleValues);
            }
            case Font: {
                return new FontPropertyDef(name, caption, description, aliases, tags, visibility, deprecated, allowNull, FontPropertyDef.parse(defaultValueStr, allowNull, null), serviceWritable, requiresData);
            }
            case Length: {
                return new LengthPropertyDef(name, caption, description, aliases, tags, visibility, deprecated, allowNull, LengthPropertyDef.parse(defaultValueStr, allowNull, null), serviceWritable, requiresData, XmlParser.boolAttr(_propertyNode, "allowNegative", false));
            }
            case Number: {
                return new NumberPropertyDef(name, caption, description, aliases, tags, visibility, deprecated, allowNull, NumberPropertyDef.parse(defaultValueStr, allowNull, null), serviceWritable, requiresData, NumberPropertyDef.parse(XmlParser.stringAttr(_propertyNode, "minValue", null), true, null), NumberPropertyDef.parse(XmlParser.stringAttr(_propertyNode, "maxValue", null), true, null));
            }
            case Palette: {
                SlotDef slot = null;
                String slotName = XmlParser.stringAttr(_propertyNode, "slot", null);
                String palTypeStr = XmlParser.stringAttr(_propertyNode, "type", null);
                PaletteType palType = PaletteType.parse(palTypeStr);
                if (slotName != null) {
                    slot = VizDefParser.findSlot(_slots, slotName);
                    if (slot == null) {
                        throw new Error("Could not resolve slot " + slotName);
                    }
                    if (palType == null) {
                        switch (slot.type) {
                            case Cat: {
                                palType = PaletteType.Cat;
                                break;
                            }
                            case Cont: {
                                palType = PaletteType.Cont;
                                break;
                            }
                            default: {
                                throw new Error("Cannot omit Palette type for a Slot of type any");
                            }
                        }
                    }
                }
                if (palType == null) {
                    throw new Error("Invalid PaletteType: " + typeStr);
                }
                int ordinal = _ofType.containsKey((Object)type) ? _ofType.get((Object)type) : 0;
                _ofType.put(palType, ordinal + 1);
                List<IPaletteResolver> resolvers = VizDefParser.getDefaultResolvers(palType);
                IPaletteResolver defaultValue = PalettePropertyDef.parse(palType, defaultValueStr, allowNull, resolvers.get(ordinal % resolvers.size()));
                return new PalettePropertyDef(name, caption, description, aliases, tags, visibility, deprecated, allowNull, defaultValue, serviceWritable, requiresData, slot, palType, XmlParser.numberAttr(_propertyNode, "min", null, false), XmlParser.numberAttr(_propertyNode, "max", null, false));
            }
            case String: {
                return new StringPropertyDef(name, caption, description, aliases, tags, visibility, deprecated, allowNull, StringPropertyDef.parse(defaultValueStr, allowNull, null), serviceWritable, requiresData);
            }
        }
        throw new Error("Unhandled type: " + (Object)((Object)type));
    }

    private static CapabilityDef capabilityDefFromXml(Node _capabilitiesNode, SlotResolver _slotResolver) {
        ArrayList<DecorationDef> decorations;
        if (_capabilitiesNode == null) {
            return null;
        }
        Node decorationsNode = XmlParser.findChildElementByTag(_capabilitiesNode, reDecorations);
        if (decorationsNode != null) {
            List<Node> decorationNodes = XmlParser.filterChildElementsByTag(decorationsNode, reDecoration);
            decorations = new ArrayList(decorationNodes.size());
            int len = decorationNodes.size();
            for (int i = 0; i < len; ++i) {
                DecorationDef decoration = VizDefParser.decorationDefFromXml(decorationNodes.get(i), _slotResolver);
                if (decoration == null) continue;
                decorations.add(decoration);
            }
        } else {
            decorations = new ArrayList<DecorationDef>(0);
        }
        return new CapabilityDef(decorations);
    }

    private static MetaDataEntryDef metaDataEntryDefFromXml(Node _metaNode) {
        if (_metaNode == null) {
            return null;
        }
        String name = XmlParser.stringAttr(_metaNode, "name", null);
        if (name == null) {
            throw new Error("A meta data entry must have a name");
        }
        return new MetaDataEntryDef(name, XmlParser.stringAttr(_metaNode, "value", null));
    }

    public static VizDef fromXML(Document _doc, VIPRNls _nls) {
        DataSetDef dataSetDef;
        int i;
        int len;
        if (_doc == null) {
            return null;
        }
        Element root = _doc.getDocumentElement();
        String versionStr = XmlParser.stringAttr(root, "version", null);
        if (versionStr == null) {
            throw new Error("Invalid VizDef: missing version");
        }
        double version = Double.parseDouble(versionStr);
        if (version < 3.0) {
            throw new Error(String.format("Invalid VizDef version: %s", versionStr));
        }
        List<Node> slotNodes = EMPTY_NODES;
        List<Node> slotGroupNodes = EMPTY_NODES;
        List<Node> dataSetNodes = EMPTY_NODES;
        List<Node> propertyNodes = EMPTY_NODES;
        List<Node> configNodes = EMPTY_NODES;
        Node capabilityNode = null;
        List<Node> metaDataNodes = EMPTY_NODES;
        block16: for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            switch (node.getNodeName().toLowerCase()) {
                case "slots": {
                    slotNodes = XmlParser.filterChildElementsByTag(node, reSlot);
                    slotGroupNodes = XmlParser.filterChildElementsByTag(node, reSlotGroup);
                    if (slotGroupNodes.isEmpty()) continue block16;
                    if (!slotNodes.isEmpty()) {
                        throw new Error("VizDef has a slot outside of a group node.");
                    }
                    slotNodes = EMPTY_NODES;
                    continue block16;
                }
                case "datasets": {
                    dataSetNodes = XmlParser.filterChildElementsByTag(node, reDataSet);
                    continue block16;
                }
                case "properties": {
                    propertyNodes = XmlParser.filterChildElements(node);
                    continue block16;
                }
                case "configuration": {
                    configNodes = XmlParser.filterChildElements(node);
                    continue block16;
                }
                case "capabilities": {
                    capabilityNode = node;
                    continue block16;
                }
                case "metadata": {
                    metaDataNodes = XmlParser.filterChildElementsByTag(node, reMetaData);
                }
            }
        }
        ArrayList<SlotGroupDef> slotGroups = new ArrayList<SlotGroupDef>();
        ArrayList<SlotDef> slots = new ArrayList<SlotDef>();
        if (!slotNodes.isEmpty()) {
            len = slotNodes.size();
            for (i = 0; i < len; ++i) {
                slots.add(VizDefParser.slotDefFromXml(slotNodes.get(i), _nls));
            }
            slotGroups.add(new SlotGroupDef("Data", null, slots));
        } else {
            len = slotGroupNodes.size();
            for (i = 0; i < len; ++i) {
                SlotGroupDef group = VizDefParser.slotGroupDefFromXml(slotGroupNodes.get(i), _nls);
                slotGroups.add(group);
            }
        }
        HashMap<String, DataSetDef> dataSetByName = new HashMap<String, DataSetDef>();
        ArrayList<DataSetDef> dataSets = new ArrayList<DataSetDef>(dataSetNodes.size());
        ArrayList<SlotRefWithReference> references = new ArrayList<SlotRefWithReference>();
        SlotResolver resolver = new SlotResolver(slotGroups);
        int len2 = dataSetNodes.size();
        for (int i2 = 0; i2 < len2; ++i2) {
            dataSetDef = VizDefParser.dataSetDefFromXml(dataSetNodes.get(i2), i2, resolver, _nls, len2, references);
            if (dataSetByName.containsKey(dataSetDef.name)) {
                throw new Error("DataSet name must be unique, found duplicate name: " + dataSetDef.name);
            }
            dataSetByName.put(dataSetDef.name, dataSetDef);
            dataSets.add(dataSetDef);
        }
        for (SlotRefWithReference slotRefLink : references) {
            dataSetDef = (DataSetDef)dataSetByName.get(slotRefLink.dataSetName);
            if (dataSetDef == null) {
                throw new Error("Could not resolve data set " + slotRefLink.dataSetName + ", data sets must be referenced by name.");
            }
            SlotRef ref = dataSetDef.getSlot(slotRefLink.slotName);
            if (ref == null) {
                throw new Error("Could not resolve referenced slot " + slotRefLink.slotName + " on data set " + dataSetDef.name);
            }
            slotRefLink.slot.setReference(ref);
        }
        HashMap<PaletteType, Integer> ofType = new HashMap<PaletteType, Integer>();
        ArrayList<PropertyDef> properties = new ArrayList<PropertyDef>(propertyNodes.size());
        int len3 = propertyNodes.size();
        for (int i3 = 0; i3 < len3; ++i3) {
            properties.add(VizDefParser.propertyDefFromXml(propertyNodes.get(i3), false, slots, _nls, ofType));
        }
        ArrayList configuration = new ArrayList(configNodes.size());
        int len4 = configNodes.size();
        for (int i4 = 0; i4 < len4; ++i4) {
            PropertyDef node = VizDefParser.propertyDefFromXml(configNodes.get(i4), true, slots, _nls, ofType);
            configuration.add((ValuePropertyDef)node);
        }
        CapabilityDef capabilities = VizDefParser.capabilityDefFromXml(capabilityNode, resolver);
        if (capabilities == null) {
            capabilities = new CapabilityDef();
        }
        ArrayList<MetaDataEntryDef> metaData = new ArrayList<MetaDataEntryDef>(metaDataNodes.size());
        int len5 = metaDataNodes.size();
        for (int i5 = 0; i5 < len5; ++i5) {
            metaData.add(VizDefParser.metaDataEntryDefFromXml(metaDataNodes.get(i5)));
        }
        return VizDef.create(slotGroups, slots, dataSets, properties, configuration, capabilities, metaData);
    }

    private static class SlotResolver {
        private final List<SlotGroupDef> slotGroups;

        public SlotResolver(List<SlotGroupDef> _slotGroups) {
            this.slotGroups = _slotGroups;
        }

        public SlotDef resolve(String _name) {
            for (SlotGroupDef group : this.slotGroups) {
                for (SlotDef slot : group.slots) {
                    if (!slot.name.equals(_name)) continue;
                    return slot;
                }
            }
            return null;
        }
    }

    private static class SlotRefWithReference {
        public final SlotRef slot;
        public final String dataSetName;
        public final String slotName;

        public SlotRefWithReference(SlotRef _slot, String _dataSetName, String _slotName) {
            this.slot = _slot;
            this.dataSetName = _dataSetName;
            this.slotName = _slotName;
        }
    }
}

