/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.schema.definition;

import com.ibm.ba.vis.schema.definition.Definition;
import com.ibm.ba.vis.schema.definition.NoopUpgrade;
import com.ibm.ba.vis.schema.definition.Upgrade;
import com.ibm.ba.vis.schema.definition.V1V2DefinitionUpgrade;
import com.ibm.ba.vis.schema.definition.V2V3DefinitionUpgrade;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.collections.map.MultiKeyMap;

public class DefinitionUpgrader {
    private final MultiKeyMap map;

    public DefinitionUpgrader() {
        V1V2DefinitionUpgrade v1v2Converter = new V1V2DefinitionUpgrade();
        V2V3DefinitionUpgrade v2v3Converter = new V2V3DefinitionUpgrade();
        NoopUpgrade noopUpgrade = new NoopUpgrade();
        this.map = new MultiKeyMap();
        this.map.put((Object)"application/vnd.vis.ibm.com.definition.1+xml", (Object)"application/vnd.vis.ibm.com.definition.2+xml", (Object)v1v2Converter);
        this.map.put((Object)"application/vnd.vis.ibm.com.definition.2+xml", (Object)"application/vnd.vis.ibm.com.definition.3_1+xml", (Object)v2v3Converter);
        this.map.put((Object)"application/vnd.vis.ibm.com.definition.1+xml", (Object)"application/vnd.vis.ibm.com.definition.1+xml", (Object)noopUpgrade);
        this.map.put((Object)"application/vnd.vis.ibm.com.definition.2+xml", (Object)"application/vnd.vis.ibm.com.definition.2+xml", (Object)noopUpgrade);
        this.map.put((Object)"application/vnd.vis.ibm.com.definition.3+xml", (Object)"application/vnd.vis.ibm.com.definition.3_1+xml", (Object)v2v3Converter);
        this.map.put((Object)"application/vnd.vis.ibm.com.definition.3_1+xml", (Object)"application/vnd.vis.ibm.com.definition.3_1+xml", (Object)noopUpgrade);
        this.map.put((Object)"application/vnd.vis.ibm.com.definition.1+xml", (Object)"*/*", (Object)noopUpgrade);
        this.map.put((Object)"application/vnd.vis.ibm.com.definition.2+xml", (Object)"*/*", (Object)noopUpgrade);
        this.map.put((Object)"application/vnd.vis.ibm.com.definition.3+xml", (Object)"*/*", (Object)noopUpgrade);
        this.map.put((Object)"application/vnd.vis.ibm.com.definition.3_1+xml", (Object)"*/*", (Object)noopUpgrade);
    }

    DefinitionUpgrader(MultiKeyMap map) {
        this.map = map;
    }

    public InputStream upgradeToLatestVer(InputStream definitionStream) {
        try {
            BufferedInputStream buffer = new BufferedInputStream(definitionStream);
            buffer.mark(512);
            String inputVersion = Definition.getVersion(buffer);
            buffer.reset();
            if (inputVersion.equals("application/vnd.vis.ibm.com.definition.2+xml") || inputVersion.equals("application/vnd.vis.ibm.com.definition.3+xml") || inputVersion.equals("application/vnd.vis.ibm.com.definition.3_1+xml")) {
                Upgrade upgrade = this.getUpgrade(inputVersion, "application/vnd.vis.ibm.com.definition.3_1+xml");
                InputStream definitionStreamV3 = upgrade.upgrade(buffer);
                return definitionStreamV3;
            }
            if (inputVersion.equals("application/vnd.vis.ibm.com.definition.1+xml")) {
                Upgrade upgrade = this.getUpgrade("application/vnd.vis.ibm.com.definition.1+xml", "application/vnd.vis.ibm.com.definition.2+xml");
                InputStream definitionStreamV2 = upgrade.upgrade(buffer);
                upgrade = this.getUpgrade("application/vnd.vis.ibm.com.definition.2+xml", "application/vnd.vis.ibm.com.definition.3_1+xml");
                InputStream definitionStreamV3 = upgrade.upgrade(definitionStreamV2);
                return definitionStreamV3;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Upgrade getUpgrade(String fromVersion, String toVersion) {
        Upgrade upgrader = (Upgrade)this.map.get((Object)fromVersion, (Object)toVersion);
        if (upgrader == null) {
            throw new UnsupportedOperationException("Unsupported definition upgrade; from=" + fromVersion + " , to=" + toVersion);
        }
        return upgrader;
    }
}

