/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.schema.definition;

import com.ibm.ba.vis.schema.definition.Definition;
import com.ibm.ba.vis.schema.definition.DefinitionValidator;
import com.ibm.ba.vis.schema.definition.SaxDefinitionValidator;
import com.ibm.ba.vis.vgs.config.VGSConfiguration;
import java.io.InputStream;

public class DefinitionValidatorFactory {
    private static final DefinitionValidatorFactory INSTANCE = new DefinitionValidatorFactory();

    DefinitionValidatorFactory() {
    }

    public DefinitionValidator getValidatorInstance(InputStream inputStream) {
        VGSConfiguration vgsConfig = VGSConfiguration.getInstance();
        try {
            String version = Definition.getVersion(inputStream);
            if ("application/vnd.vis.ibm.com.definition.1+xml".equals(version)) {
                return SaxDefinitionValidator.getInstance(vgsConfig.getChartTypeDefinitionSchema());
            }
            if ("application/vnd.vis.ibm.com.definition.2+xml".equals(version)) {
                return SaxDefinitionValidator.getInstance(vgsConfig.getVisualizationDefinitionSchema());
            }
            if ("application/vnd.vis.ibm.com.definition.3+xml".equals(version)) {
                return SaxDefinitionValidator.getInstance(vgsConfig.getVisualizationDefinitionSchema3());
            }
            if ("application/vnd.vis.ibm.com.definition.3_1+xml".equals(version)) {
                return SaxDefinitionValidator.getInstance(vgsConfig.getVisualizationDefinitionSchema3_1());
            }
            throw new IllegalArgumentException("Unknown definition version");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DefinitionValidatorFactory getInstance() {
        return INSTANCE;
    }
}

