/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.schema.definition;

import com.ibm.ba.vis.schema.definition.Upgrade;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._1.ChartTypeDefinition;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._1.Description;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._1.Label;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._1.Properties;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.CategorySlot;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.GroupProperties;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.ObjectFactory;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.Properties;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.Set;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.Tooltip;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.ValueSlot;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.VisualizationDefinition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class V1V2DefinitionUpgrade
implements Upgrade {
    static final String DEFINITION_V1 = "com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._1";
    static final String DEFINITION_V2 = "com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2";
    private final JAXBContext v1context;
    private final JAXBContext v2context;

    V1V2DefinitionUpgrade() {
        try {
            this.v1context = JAXBContext.newInstance((String)DEFINITION_V1);
            this.v2context = JAXBContext.newInstance((String)DEFINITION_V2);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream upgrade(InputStream source) {
        try {
            Unmarshaller um = this.v1context.createUnmarshaller();
            ChartTypeDefinition v1Definition = (ChartTypeDefinition)um.unmarshal(source);
            VisualizationDefinition v2Definition = this.upgrade(v1Definition);
            Marshaller m = this.v2context.createMarshaller();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            m.marshal((Object)v2Definition, (OutputStream)baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private VisualizationDefinition upgrade(ChartTypeDefinition v1Definition) {
        ObjectFactory f = new ObjectFactory();
        VisualizationDefinition definition = f.createVisualizationDefinition();
        definition.setName(v1Definition.getName());
        definition.setDefinitionVersion(BigInteger.valueOf(2L));
        definition.setSupportsDefaultDataFormatting(v1Definition.isSupportsDefaultDataFormatting());
        definition.setLabel(this.createLabel(f, v1Definition.getLabel()));
        definition.setDescription(this.createDescription(f, v1Definition.getDescription()));
        definition.setTooltip(this.createTooltip(f, v1Definition.getTooltip()));
        this.upgradeAuthor(definition, v1Definition);
        this.upgradeTags(f, definition, v1Definition);
        this.upgradeAdapters(f, definition, v1Definition);
        this.upgradeDataSets(f, definition, v1Definition);
        this.upgradeProperties(f, definition, v1Definition);
        return definition;
    }

    private void upgradeTags(ObjectFactory f, VisualizationDefinition definition, ChartTypeDefinition v1Definition) {
        VisualizationDefinition.Tags tags = f.createVisualizationDefinitionTags();
        ChartTypeDefinition.Tags v1Tags = v1Definition.getTags();
        if (v1Tags != null) {
            List<ChartTypeDefinition.Tags.Tag> v1TagList = v1Tags.getTag();
            for (ChartTypeDefinition.Tags.Tag v1Tag : v1TagList) {
                VisualizationDefinition.Tags.Tag tag = f.createVisualizationDefinitionTagsTag();
                tag.setIds(v1Tag.getIds());
                tag.setValue(v1Tag.getValue());
                tags.getTag().add(tag);
            }
        }
        definition.setTags(tags);
    }

    private void upgradeAuthor(VisualizationDefinition definition, ChartTypeDefinition v1Definition) {
        definition.setAuthor(v1Definition.getAuthor());
    }

    private Tooltip createTooltip(ObjectFactory f, com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._1.Tooltip v1Tooltip) {
        if (v1Tooltip == null) {
            return null;
        }
        Tooltip tooltip = f.createTooltip();
        tooltip.setValue(v1Tooltip.getValue());
        tooltip.setIds(v1Tooltip.getIds());
        return tooltip;
    }

    private com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.Description createDescription(ObjectFactory f, Description v1Description) {
        if (v1Description == null) {
            return null;
        }
        com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.Description description = f.createDescription();
        description.setValue(v1Description.getValue());
        description.setIds(v1Description.getIds());
        return description;
    }

    private com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.Label createLabel(ObjectFactory f, Label v1Label) {
        if (v1Label == null) {
            return null;
        }
        com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.Label label = f.createLabel();
        label.setValue(v1Label.getValue());
        label.setIds(v1Label.getIds());
        return label;
    }

    private void upgradeProperties(ObjectFactory f, VisualizationDefinition definition, ChartTypeDefinition v1Definition) {
        com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.Properties properties = this.createProperties(f, v1Definition.getProperties());
        definition.setProperties(properties);
    }

    private com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.Properties createProperties(ObjectFactory f, Properties v1Props) {
        com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.Properties properties = f.createProperties();
        List<Object> propList = properties.getStringPropertyOrIntegerPropertyOrDecimalProperty();
        List<Object> v1PropList = null;
        if (v1Props != null) {
            v1PropList = v1Props.getStringPropertyOrIntegerPropertyOrDecimalProperty();
            for (Object object : v1PropList) {
                Object dProp;
                if (object instanceof Properties.IntegerProperty) {
                    Properties.IntegerProperty v1IntProp = (Properties.IntegerProperty)object;
                    GroupProperties.IntegerProperty iProp = this.createIntegerProperty(f, v1IntProp);
                    propList.add(iProp);
                    continue;
                }
                if (object instanceof Properties.EnumProperty) {
                    Properties.EnumProperty v1EnumProp = (Properties.EnumProperty)object;
                    GroupProperties.EnumProperty eProp = this.createEnumProperty(f, v1EnumProp);
                    propList.add(eProp);
                    continue;
                }
                if (object instanceof Properties.StringProperty) {
                    Properties.StringProperty v1StringProp = (Properties.StringProperty)object;
                    GroupProperties.StringProperty sProp = this.createStringProp(f, v1StringProp);
                    propList.add(sProp);
                    continue;
                }
                if (object instanceof Properties.DecimalProperty) {
                    Properties.DecimalProperty v1DecimalProp = (Properties.DecimalProperty)object;
                    dProp = this.createDecimalProp(f, v1DecimalProp);
                    propList.add(dProp);
                    continue;
                }
                if (object instanceof Properties.BooleanProperty) {
                    Properties.BooleanProperty v1BooleanProp = (Properties.BooleanProperty)object;
                    dProp = this.createBooleanProp(f, v1BooleanProp);
                    propList.add(dProp);
                    continue;
                }
                if (!(object instanceof Properties.PropertiesGroup)) continue;
                Properties.PropertiesGroup v1PropertiesGroup = (Properties.PropertiesGroup)object;
                Properties.PropertiesGroup propGroup = this.createPropertiesGroup(f, v1PropertiesGroup);
                propList.add(propGroup);
            }
        }
        return properties;
    }

    private Properties.PropertiesGroup createPropertiesGroup(ObjectFactory f, Properties.PropertiesGroup v1PropertiesGroup) {
        Properties.PropertiesGroup pGroup = f.createPropertiesPropertiesGroup();
        pGroup.setName(v1PropertiesGroup.getName());
        pGroup.setLabel(this.createLabel(f, v1PropertiesGroup.getLabel()));
        pGroup.setDescription(this.createDescription(f, v1PropertiesGroup.getDescription()));
        pGroup.setTooltip(this.createTooltip(f, v1PropertiesGroup.getTooltip()));
        com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._2.Properties properties = this.createProperties(f, v1PropertiesGroup.getProperties());
        List<Object> props = properties.getStringPropertyOrIntegerPropertyOrDecimalProperty();
        GroupProperties groupProperties = f.createGroupProperties();
        List<Object> groupPropertiesList = groupProperties.getPropertyTypes();
        for (Object prop : props) {
            if (prop instanceof Properties.PropertiesGroup) continue;
            groupPropertiesList.add(prop);
        }
        pGroup.setGroupProperties(groupProperties);
        return pGroup;
    }

    private GroupProperties.BooleanProperty createBooleanProp(ObjectFactory f, Properties.BooleanProperty v1BooleanProp) {
        GroupProperties.BooleanProperty bProp = f.createGroupPropertiesBooleanProperty();
        bProp.setName(v1BooleanProp.getName());
        bProp.setLabel(this.createLabel(f, v1BooleanProp.getLabel()));
        bProp.setDescription(this.createDescription(f, v1BooleanProp.getDescription()));
        bProp.setTooltip(this.createTooltip(f, v1BooleanProp.getTooltip()));
        bProp.setOutputType(this.getOutputType(v1BooleanProp.getOutputType()));
        return bProp;
    }

    private GroupProperties.DecimalProperty createDecimalProp(ObjectFactory f, Properties.DecimalProperty v1DecimalProp) {
        GroupProperties.DecimalProperty dProp = f.createGroupPropertiesDecimalProperty();
        dProp.setName(v1DecimalProp.getName());
        dProp.setLabel(this.createLabel(f, v1DecimalProp.getLabel()));
        dProp.setDescription(this.createDescription(f, v1DecimalProp.getDescription()));
        dProp.setTooltip(this.createTooltip(f, v1DecimalProp.getTooltip()));
        dProp.setDefaultDecimal(v1DecimalProp.getDefault());
        dProp.setOutputType(this.getOutputType(v1DecimalProp.getOutputType()));
        return dProp;
    }

    private GroupProperties.IntegerProperty createIntegerProperty(ObjectFactory f, Properties.IntegerProperty v1IntProp) {
        GroupProperties.IntegerProperty iProp = f.createGroupPropertiesIntegerProperty();
        String name = v1IntProp.getName();
        iProp.setName(name);
        iProp.setLabel(this.createLabel(f, v1IntProp.getLabel()));
        iProp.setDescription(this.createDescription(f, v1IntProp.getDescription()));
        iProp.setTooltip(this.createTooltip(f, v1IntProp.getTooltip()));
        iProp.setDefaultInteger(v1IntProp.getDefault());
        iProp.setOutputType(this.getOutputType(v1IntProp.getOutputType()));
        if (name.equalsIgnoreCase("width") || name.equalsIgnoreCase("height")) {
            iProp.setMin(BigInteger.ZERO);
            iProp.setMax(BigInteger.valueOf(999999999L));
        }
        return iProp;
    }

    private GroupProperties.EnumProperty createEnumProperty(ObjectFactory f, Properties.EnumProperty v1EnumProp) {
        GroupProperties.EnumProperty eProp = f.createGroupPropertiesEnumProperty();
        eProp.setName(v1EnumProp.getName());
        eProp.setLabel(this.createLabel(f, v1EnumProp.getLabel()));
        eProp.setDescription(this.createDescription(f, v1EnumProp.getDescription()));
        eProp.setTooltip(this.createTooltip(f, v1EnumProp.getTooltip()));
        eProp.setDefaultValue(v1EnumProp.getDefault());
        GroupProperties.EnumProperty.EnumValues enumValues = f.createGroupPropertiesEnumPropertyEnumValues();
        List<GroupProperties.EnumProperty.EnumValues.EnumValue> enumValueList = enumValues.getEnumValue();
        Properties.EnumProperty.EnumValues v1EnumValues = v1EnumProp.getEnumValues();
        List<Properties.EnumProperty.EnumValues.EnumValue> v1EnumList = v1EnumValues.getEnumValue();
        for (Properties.EnumProperty.EnumValues.EnumValue v1EnumValue : v1EnumList) {
            GroupProperties.EnumProperty.EnumValues.EnumValue enumValue = f.createGroupPropertiesEnumPropertyEnumValuesEnumValue();
            enumValue.setValue(v1EnumValue.getValue());
            enumValue.setLabel(this.createLabel(f, v1EnumValue.getLabel()));
            enumValue.setDescription(this.createDescription(f, v1EnumValue.getDescription()));
            enumValue.setTooltip(this.createTooltip(f, v1EnumValue.getTooltip()));
            enumValueList.add(enumValue);
        }
        eProp.setEnumValues(enumValues);
        if ("animationEffect".equalsIgnoreCase(v1EnumProp.getName())) {
            eProp.setOutputType("interactive");
        } else {
            eProp.setOutputType(this.getOutputType(v1EnumProp.getOutputType()));
        }
        return eProp;
    }

    private String getOutputType(String setOutputType) {
        String outputType = setOutputType;
        if (outputType != null && "javascript".equalsIgnoreCase(outputType)) {
            outputType = "interactive";
        }
        return outputType;
    }

    private GroupProperties.StringProperty createStringProp(ObjectFactory f, Properties.StringProperty v1StringProp) {
        GroupProperties.StringProperty sProp = f.createGroupPropertiesStringProperty();
        sProp.setName(v1StringProp.getName());
        sProp.setLabel(this.createLabel(f, v1StringProp.getLabel()));
        sProp.setDescription(this.createDescription(f, v1StringProp.getDescription()));
        sProp.setTooltip(this.createTooltip(f, v1StringProp.getTooltip()));
        sProp.setDefaultString(v1StringProp.getDefault());
        sProp.setOutputType(this.getOutputType(v1StringProp.getOutputType()));
        return sProp;
    }

    private void upgradeDataSets(ObjectFactory f, VisualizationDefinition definition, ChartTypeDefinition v1Definition) {
        VisualizationDefinition.DataSets datasets = f.createVisualizationDefinitionDataSets();
        VisualizationDefinition.Slots slots = f.createVisualizationDefinitionSlots();
        ChartTypeDefinition.DataSets v1DataSets = v1Definition.getDataSets();
        List<ChartTypeDefinition.DataSets.DataSet> v1DataSetList = v1DataSets.getDataSet();
        for (ChartTypeDefinition.DataSets.DataSet v1DataSet : v1DataSetList) {
            VisualizationDefinition.DataSets.DataSet dataSet = this.createDataSet(f, v1DataSet);
            this.createSlot(f, slots, v1DataSet);
            datasets.getDataSet().add(dataSet);
        }
        definition.setDataSets(datasets);
        definition.setSlots(slots);
    }

    private void createSlot(ObjectFactory f, VisualizationDefinition.Slots slots, ChartTypeDefinition.DataSets.DataSet v1DataSet) {
        ChartTypeDefinition.DataSets.DataSet.ValuesEdge valuesEdge;
        ChartTypeDefinition.DataSets.DataSet.CategoryEdges edges = v1DataSet.getCategoryEdges();
        if (edges != null) {
            List<ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge> edgesList = edges.getCategoryEdge();
            for (ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge categoryEdge : edgesList) {
                ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels catLevels = categoryEdge.getCategoryLevels();
                List<ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel> catLevelList = catLevels.getCategoryLevel();
                for (ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel categoryLevel : catLevelList) {
                    ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel.CategoryFields catFields = categoryLevel.getCategoryFields();
                    List<ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel.CategoryFields.CategoryField> catFieldsList = catFields.getCategoryField();
                    for (ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel.CategoryFields.CategoryField categoryField : catFieldsList) {
                        CategorySlot cSlot = this.createCategorySlot(f, categoryField);
                        slots.getCategorySlotOrValueSlotOrSlotGroup().add(cSlot);
                    }
                }
            }
        }
        if ((valuesEdge = v1DataSet.getValuesEdge()) != null) {
            ChartTypeDefinition.DataSets.DataSet.ValuesEdge.ValueFields valueFields = valuesEdge.getValueFields();
            List<ChartTypeDefinition.DataSets.DataSet.ValuesEdge.ValueFields.ValueField> valueFieldList = valueFields.getValueField();
            for (ChartTypeDefinition.DataSets.DataSet.ValuesEdge.ValueFields.ValueField valueField : valueFieldList) {
                ValueSlot vSlot = this.createValueSlot(f, valueField);
                slots.getCategorySlotOrValueSlotOrSlotGroup().add(vSlot);
            }
        }
    }

    private ValueSlot createValueSlot(ObjectFactory f, ChartTypeDefinition.DataSets.DataSet.ValuesEdge.ValueFields.ValueField valueField) {
        ValueSlot vSlot = f.createValueSlot();
        vSlot.setName(valueField.getName());
        vSlot.setSupportsRange(valueField.isSupportsRange());
        vSlot.setLabel(this.createLabel(f, valueField.getLabel()));
        vSlot.setTooltip(this.createTooltip(f, valueField.getTooltip()));
        return vSlot;
    }

    private CategorySlot createCategorySlot(ObjectFactory f, ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel.CategoryFields.CategoryField categoryField) {
        CategorySlot cSlot = f.createCategorySlot();
        cSlot.setName(categoryField.getName());
        cSlot.setCategoryValues(categoryField.getCategoryValues());
        cSlot.setLabel(this.createLabel(f, categoryField.getLabel()));
        cSlot.setTooltip(this.createTooltip(f, categoryField.getTooltip()));
        return cSlot;
    }

    private VisualizationDefinition.DataSets.DataSet createDataSet(ObjectFactory f, ChartTypeDefinition.DataSets.DataSet v1DataSet) {
        VisualizationDefinition.DataSets.DataSet dataSet = f.createVisualizationDefinitionDataSetsDataSet();
        dataSet.setName(v1DataSet.getName());
        dataSet.setLabel(this.createLabel(f, v1DataSet.getLabel()));
        dataSet.setTooltip(this.createTooltip(f, v1DataSet.getTooltip()));
        dataSet.setOptionalOverride(v1DataSet.isOptionalOverride());
        dataSet.setHasChartElements(v1DataSet.isHasChartElements());
        ChartTypeDefinition.DataSets.DataSet.CategoryEdges edges = v1DataSet.getCategoryEdges();
        if (edges != null) {
            VisualizationDefinition.DataSets.DataSet.CategoryAxes axes = f.createVisualizationDefinitionDataSetsDataSetCategoryAxes();
            List<ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge> edgesList = edges.getCategoryEdge();
            for (ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge categoryEdge : edgesList) {
                VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis axis = this.createCategoryAxis(f, categoryEdge);
                axes.getCategoryAxis().add(axis);
            }
            dataSet.setCategoryAxes(axes);
        }
        VisualizationDefinition.DataSets.DataSet.ValueAxis valueAxis = this.createValueAxis(f, v1DataSet);
        dataSet.setValueAxis(valueAxis);
        return dataSet;
    }

    private VisualizationDefinition.DataSets.DataSet.ValueAxis createValueAxis(ObjectFactory f, ChartTypeDefinition.DataSets.DataSet v1DataSet) {
        VisualizationDefinition.DataSets.DataSet.ValueAxis valueAxis = null;
        ChartTypeDefinition.DataSets.DataSet.ValuesEdge valuesEdge = v1DataSet.getValuesEdge();
        if (valuesEdge != null) {
            valueAxis = f.createVisualizationDefinitionDataSetsDataSetValueAxis();
            VisualizationDefinition.DataSets.DataSet.ValueAxis.ValueAxisSet vas = f.createVisualizationDefinitionDataSetsDataSetValueAxisValueAxisSet();
            valueAxis.setValueAxisSet(vas);
            ChartTypeDefinition.DataSets.DataSet.ValuesEdge.ValueFields valueFields = valuesEdge.getValueFields();
            List<ChartTypeDefinition.DataSets.DataSet.ValuesEdge.ValueFields.ValueField> valueFieldList = valueFields.getValueField();
            for (ChartTypeDefinition.DataSets.DataSet.ValuesEdge.ValueFields.ValueField valueField : valueFieldList) {
                VisualizationDefinition.DataSets.DataSet.ValueAxis.ValueAxisSet.ValueAxisValue vav = f.createVisualizationDefinitionDataSetsDataSetValueAxisValueAxisSetValueAxisValue();
                vav.setRefSlot(valueField.getName());
                vas.getValueAxisValue().add(vav);
            }
            valueAxis.setLabel(this.createLabel(f, valuesEdge.getLabel()));
            valueAxis.setTooltip(this.createTooltip(f, valuesEdge.getTooltip()));
        }
        return valueAxis;
    }

    private VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis createCategoryAxis(ObjectFactory f, ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge categoryEdge) {
        VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis axis = f.createVisualizationDefinitionDataSetsDataSetCategoryAxesCategoryAxis();
        axis.setName(categoryEdge.getName());
        axis.setLabel(this.createLabel(f, categoryEdge.getLabel()));
        axis.setTooltip(this.createTooltip(f, categoryEdge.getTooltip()));
        ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels catLevels = categoryEdge.getCategoryLevels();
        List<ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel> catLevelList = catLevels.getCategoryLevel();
        VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis.AxisStructure structure = f.createVisualizationDefinitionDataSetsDataSetCategoryAxesCategoryAxisAxisStructure();
        if (catLevelList.size() == 1) {
            ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel catLevel = catLevelList.get(0);
            ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel.CategoryFields catFields = catLevel.getCategoryFields();
            List<ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel.CategoryFields.CategoryField> catFieldsList = catFields.getCategoryField();
            if (catFieldsList.size() == 1) {
                ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel.CategoryFields.CategoryField catField = catFieldsList.get(0);
                Set set = this.createSet(f, catField);
                structure.setSet(set);
            } else {
                VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis.AxisStructure.Union union = f.createVisualizationDefinitionDataSetsDataSetCategoryAxesCategoryAxisAxisStructureUnion();
                for (ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel.CategoryFields.CategoryField categoryField : catFieldsList) {
                    Set set = this.createSet(f, categoryField);
                    union.getSet().add(set);
                }
                structure.setUnion(union);
            }
        } else {
            VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis.AxisStructure.Nest nest = f.createVisualizationDefinitionDataSetsDataSetCategoryAxesCategoryAxisAxisStructureNest();
            for (ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel categoryLevel : catLevelList) {
                ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel.CategoryFields catFields = categoryLevel.getCategoryFields();
                List<ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel.CategoryFields.CategoryField> catFieldsList = catFields.getCategoryField();
                if (catFieldsList == null || catFieldsList.size() <= 0) continue;
                ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel.CategoryFields.CategoryField categoryField = catFieldsList.get(0);
                Set set = this.createSet(f, categoryField);
                nest.getSet().add(set);
            }
            structure.setNest(nest);
        }
        axis.setAxisStructure(structure);
        return axis;
    }

    private Set createSet(ObjectFactory f, ChartTypeDefinition.DataSets.DataSet.CategoryEdges.CategoryEdge.CategoryLevels.CategoryLevel.CategoryFields.CategoryField catField) {
        Set set = f.createSet();
        set.setRefSlot(catField.getName());
        return set;
    }

    private void upgradeAdapters(ObjectFactory f, VisualizationDefinition definition, ChartTypeDefinition v1Definition) {
        definition.setAdapter(v1Definition.getAdapter());
    }
}

