/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.schema.definition;

import com.ctc.wstx.stax.WstxEventFactory;
import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.ibm.ba.vis.schema.definition.Upgrade;
import com.ibm.ba.vis.vgs.error.ErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class V2V3DefinitionUpgrade
implements Upgrade {
    private static final String CHART_TYPE_DEFINITION_3_1 = "chartTypeDefinition.3_1";
    private static final XMLOutputFactory xmlOutputFactory = new WstxOutputFactory();
    private static final XMLInputFactory xmlInputFactory = new WstxInputFactory();
    private static final XMLEventFactory eventFactory = new WstxEventFactory();

    @Override
    public InputStream upgrade(InputStream source) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XMLEventReader reader = xmlInputFactory.createXMLEventReader(source, "UTF-8");
            XMLEventWriter writer = xmlOutputFactory.createXMLEventWriter(baos, "UTF-8");
            block6: while (reader.hasNext()) {
                XMLEvent event = (XMLEvent)reader.next();
                switch (event.getEventType()) {
                    case 7: {
                        continue block6;
                    }
                    case 1: {
                        this.updateStartElem(writer, event);
                        continue block6;
                    }
                }
                writer.add(event);
            }
            writer.flush();
            writer.close();
            reader.close();
        }
        catch (XMLStreamException e) {
            throw new GalleryServiceException((ErrorCode)GalleryAPIErrorCode.corruptedBundleDefinition, (Throwable)e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private void updateStartElem(XMLEventWriter writer, XMLEvent event) throws XMLStreamException {
        String elementName = event.asStartElement().getName().getLocalPart();
        if ("visualizationDefinition".equals(elementName)) {
            this.updateVisualizationDefinitionStartElement(writer, event);
        } else {
            writer.add(event);
        }
    }

    private void updateVisualizationDefinitionStartElement(XMLEventWriter writer, XMLEvent event) throws XMLStreamException {
        QName qName = event.asStartElement().getName();
        String prefix = qName.getPrefix();
        String namespace = qName.getNamespaceURI();
        if (!namespace.contains(CHART_TYPE_DEFINITION_3_1)) {
            if (namespace.contains("chartTypeDefinition.2")) {
                namespace = namespace.replace("chartTypeDefinition.2", CHART_TYPE_DEFINITION_3_1);
            } else if (namespace.contains("chartTypeDefinition.3")) {
                namespace = namespace.replace("chartTypeDefinition.3", CHART_TYPE_DEFINITION_3_1);
            }
        }
        writer.add(eventFactory.createStartElement(prefix, namespace, qName.getLocalPart()));
        writer.add(eventFactory.createNamespace(prefix, namespace));
        Iterator<Attribute> iterator = event.asStartElement().getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if ("definitionVersion".equals(attribute.getName().getLocalPart())) {
                writer.add(eventFactory.createAttribute("definitionVersion", "3_1"));
                continue;
            }
            writer.add(eventFactory.createAttribute(attribute.getName().getLocalPart(), attribute.getValue()));
        }
    }
}

