/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.ibm.ba.vis.adapter.Adapter;
import com.ibm.ba.vis.service.Manifest;
import com.ibm.ba.vis.service.Messages;
import com.ibm.ba.vis.service.VisualizationException;
import com.ibm.ba.vis.service.adapter.AdapterManager;
import com.ibm.ba.vis.service.adapter.DefaultAdapterManager;
import com.ibm.ba.vis.service.definition.Definition;
import com.ibm.ba.vis.service.definition.DefinitionFactory;
import com.ibm.ba.vis.service.definition.VisDefinitionFactory;
import com.ibm.ba.vis.service.gallery.Gallery;
import com.ibm.ba.vis.service.instance.Instance;
import com.ibm.ba.vis.service.instance.InstanceFactory;
import com.ibm.ba.vis.service.instance.VisInstanceFactory;
import com.ibm.json.java.JSONObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class VisualizationOutputService {
    private static final String WARMUP = "warmup/";
    private static final Logger logger = LoggerFactory.getLogger(VisualizationOutputService.class);
    private final InstanceFactory instanceFactory;
    private final DefinitionFactory definitionFactory;
    private final AdapterManager adapterManager;
    private boolean forceAndaleFont = false;

    public VisualizationOutputService() {
        this(new VisInstanceFactory(), new VisDefinitionFactory(), new DefaultAdapterManager());
    }

    VisualizationOutputService(InstanceFactory instanceFactory, DefinitionFactory definitionFactory, AdapterManager adapterManager) {
        this.instanceFactory = instanceFactory;
        this.definitionFactory = definitionFactory;
        this.adapterManager = adapterManager;
    }

    public Map<String, byte[]> generate(Gallery gallery, String instanceSpecXml, String format, Map<String, String> headers) throws VisualizationException {
        this.validateInput(instanceSpecXml, format);
        instanceSpecXml = instanceSpecXml.replace("chartInstance.3/", "chartInstance.3_1/");
        try {
            MDC.put((String)"session", (String)UUID.randomUUID().toString());
            long start = -1L;
            if (logger.isInfoEnabled()) {
                logger.info("Requested format: " + format);
                logger.info("Instance xml: " + instanceSpecXml);
                start = System.currentTimeMillis();
            }
            Instance visInstance = this.instanceFactory.getInstance(instanceSpecXml);
            String bundleId = visInstance.getBundleId();
            ZipInputStream implementation = null;
            Definition definition = null;
            JSONObject definitionJSON = gallery.getDefinitionJSON(bundleId);
            if (definitionJSON != null) {
                definition = this.definitionFactory.getDefinition(definitionJSON);
            } else {
                InputStream definitionIS;
                if (bundleId.contains(WARMUP)) {
                    String folder = CCLConfigurationFactory.getInstance().resolveEffectivePath("../configuration/warmup/cgs/" + bundleId.substring(WARMUP.length()));
                    File definitionFile = new File(folder + "/definition.xml");
                    definitionIS = new BufferedInputStream(new FileInputStream(definitionFile));
                } else {
                    definitionIS = gallery.getDefinition(bundleId);
                }
                definition = this.definitionFactory.getDefinition(definitionIS);
            }
            Adapter adapter = this.adapterManager.getAdapter(definition, format);
            adapter.setBundleName(bundleId);
            if (!"com.ibm.cognos.adapters.rave2.RAVEChartAdapter".equals(definition.getAdapterId()) && !"com.ibm.cognos.adapters.vida.VIDAChartAdapter".equals(definition.getAdapterId())) {
                if (bundleId.contains(WARMUP)) {
                    String folder = CCLConfigurationFactory.getInstance().resolveEffectivePath("../configuration/warmup/cgs/" + bundleId.substring(WARMUP.length()));
                    File impl = new File(folder + "/implementation.zip");
                    implementation = new ZipInputStream(new FileInputStream(impl));
                } else {
                    implementation = gallery.getImplementation(bundleId);
                }
            }
            adapter.setData(visInstance.getData(), definition.getOptionalOverride());
            if (this.forceAndaleFont) {
                adapter.setForceAndaleFont(true);
            }
            if (definition.supportsDataFormatting()) {
                adapter.setFormatter(visInstance.getFormatter());
            }
            adapter.setProperties(visInstance.getProperties());
            adapter.setLocale(visInstance.getInstanceLocale());
            Map output = null;
            output = definitionJSON != null ? adapter.generate(definitionJSON, gallery.getFolder(), format, headers) : adapter.generate(implementation, format);
            if ("interactive".equalsIgnoreCase(format)) {
                this.createManifest(output, definition);
            }
            if (logger.isInfoEnabled()) {
                long end = System.currentTimeMillis();
                logger.info("Output generated in " + (end - start) + " ms");
                logger.info("Generated output " + output.keySet().toString());
            }
            Map map = output;
            return map;
        }
        catch (Throwable t) {
            String msg = Messages.getString("visoutputServiceError");
            logger.error(msg, t);
            throw new VisualizationException(msg, t);
        }
        finally {
            MDC.remove((String)"session");
        }
    }

    private void validateInput(String instanceSpecXml, String format) {
        if (StringUtils.isBlank((String)instanceSpecXml) || StringUtils.isBlank((String)format)) {
            String msg = Messages.getString("invalidInputToVisoutputService");
            logger.error("Requested format: " + format);
            logger.error("Instance xml: " + instanceSpecXml);
            logger.error(msg);
            throw new VisualizationException(msg);
        }
    }

    private void createManifest(Map<String, byte[]> output, Definition definition) {
        Manifest manifest = new Manifest(output.keySet(), definition.getAdapterId(), definition.getName());
        output.put("manifest.xml", manifest.asXML().getBytes(Charsets.UTF_8));
    }

    public void setForceAndaleFont(boolean forceAndaleFont) {
        this.forceAndaleFont = forceAndaleFont;
    }
}

