/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service;

import com.ibm.ba.vis.service.GalleryFacade;
import com.ibm.ba.vis.service.VisualizationOutputService;
import com.ibm.ba.vis.service.VisualizationService;
import com.ibm.ba.vis.service.gallery.Gallery;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.util.LoaderUtil;

public class VisualizationServiceFactory {
    private static final VisualizationOutputService service;

    public static VisualizationService getService(Gallery gallery, Map<String, String> headers) {
        return new GalleryFacade(service, gallery, headers);
    }

    static {
        try {
            ClassLoader loader = LoaderUtil.getThreadContextClassLoader();
            URL url = Loader.getResource((String)"log4j2-vis.xml", (ClassLoader)loader);
            if (url != null) {
                Configurator.reconfigure((URI)url.toURI());
            }
        }
        catch (URISyntaxException e) {
            System.err.println("[VisualizationServiceFactory] Failed to load Log4J2 configuration");
            e.printStackTrace(System.err);
        }
        service = new VisualizationOutputService();
    }
}

