/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.instance;

import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.ba.vis.service.instance.DataSetFormatterFactory;
import com.ibm.ba.vis.service.instance.InstanceDataFormat;
import com.ibm.ba.vis.service.instance.InstanceFormatForRow;
import com.ibm.ba.vis.service.instance.InstanceValueField;
import com.ibm.ba.vis.service.instance.format.Format;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class DataSetFormatter
implements Formatter {
    private final DataSetFormatterFactory factory;
    private final InstanceDataFormat defaultFormat;
    private final Map<String, InstanceValueField> fields;
    private final Locale locale;
    private static int[] icuRounding = new int[]{2, 3, 1, 0, 6, 5, 4};
    private int m_roundMode = 7;

    public void setNumericRounding(int round) {
        this.m_roundMode = round;
    }

    public int getNumericRounding() {
        return this.m_roundMode;
    }

    public DataSetFormatter(InstanceDataFormat defaultFormat, Map<String, InstanceValueField> fields, Locale locale) {
        this(new DataSetFormatterFactory(), defaultFormat, fields, locale);
    }

    DataSetFormatter(DataSetFormatterFactory factory, InstanceDataFormat defaultFormat, Map<String, InstanceValueField> fields, Locale locale) {
        this.factory = factory;
        this.defaultFormat = defaultFormat;
        this.fields = fields;
        this.locale = locale;
    }

    public String formatNumber(Number value, int rowIndex, String fieldId, int measureIndex) {
        Format format = this.getFormatter(rowIndex, fieldId, measureIndex);
        return format.format(value);
    }

    public String formatNumber(Number value, int rowIndex, String fieldId) {
        Format format = this.getFormatter(rowIndex, fieldId, 0);
        return format.format(value);
    }

    public String getPattern(int rowIndex, String fieldId) {
        Format format = this.getFormatter(rowIndex, fieldId, 0);
        return format.getPattern();
    }

    private Format getFormatter(int rowIndex, String fieldId, int measureIndex) {
        InstanceDataFormat fieldDataFormat;
        InstanceDataFormat dataFormat = this.defaultFormat;
        InstanceValueField field = this.fields.get(fieldId);
        if (field != null && (fieldDataFormat = this.getDataFormatForField(rowIndex, field, measureIndex)) != null && (fieldDataFormat.getCurrencyFormat() != null || fieldDataFormat.getNumberFormat() != null || fieldDataFormat.getPercentFormat() != null)) {
            dataFormat = fieldDataFormat;
        }
        Format format = this.factory.getFormat(dataFormat, this.locale, this.m_roundMode);
        return format;
    }

    private InstanceDataFormat getDataFormatForField(int rowIndex, InstanceValueField field, int measureIndex) {
        InstanceDataFormat dataFormat = null;
        List<InstanceFormatForRow> rowFormats = field.getDataFormatForRows();
        dataFormat = rowFormats != null && rowFormats.size() > 0 ? this.getDataFormatForFieldRow(rowIndex, field, rowFormats) : field.getDataFormat(measureIndex);
        return dataFormat;
    }

    private InstanceDataFormat getDataFormatForFieldRow(int rowIndex, InstanceValueField field, List<InstanceFormatForRow> rowList) {
        InstanceDataFormat dataFormat = null;
        block0: for (InstanceFormatForRow dataFormatForRow : rowList) {
            String rows = dataFormatForRow.getRows();
            StringTokenizer tokenizer = new StringTokenizer(rows, ",");
            while (tokenizer.hasMoreTokens()) {
                String row = tokenizer.nextToken().trim();
                if (!row.equalsIgnoreCase(Integer.toString(rowIndex))) continue;
                dataFormat = dataFormatForRow.getDataFormat();
                continue block0;
            }
        }
        if (dataFormat == null) {
            dataFormat = field.getDataFormat();
        }
        return dataFormat;
    }

    public static int convertToICURounding(int rsvpRounding) {
        int result = 7;
        if (rsvpRounding < icuRounding.length) {
            result = icuRounding[rsvpRounding];
        }
        return result;
    }
}

