/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.instance;

import com.ibm.ba.vis.service.instance.CognosI18NResources;
import com.ibm.ba.vis.service.instance.InstanceCurrencyFormat;
import com.ibm.ba.vis.service.instance.InstanceDataFormat;
import com.ibm.ba.vis.service.instance.InstanceNumberFormat;
import com.ibm.ba.vis.service.instance.InstancePercentFormat;
import com.ibm.ba.vis.service.instance.format.Format;
import com.ibm.ba.vis.service.instance.format.I18NResources;
import com.ibm.ba.vis.service.instance.format.IcuChfCurrencyFormat;
import com.ibm.ba.vis.service.instance.format.IcuCurrencyFormat;
import com.ibm.ba.vis.service.instance.format.IcuNumberFormat;
import com.ibm.ba.vis.service.instance.format.IcuPercentFormat;
import java.util.Locale;

class DataSetFormatterFactory {
    private final I18NResources resources;

    public DataSetFormatterFactory() {
        this.resources = new CognosI18NResources();
    }

    DataSetFormatterFactory(I18NResources resources) {
        this.resources = resources;
    }

    Format getFormat(InstanceDataFormat dataFormat, Locale locale) {
        return this.getFormat(dataFormat, locale, 7);
    }

    Format getFormat(InstanceDataFormat dataFormat, Locale locale, int roundingMode) {
        Format format = null;
        InstanceNumberFormat nFormat = dataFormat.getNumberFormat();
        if (nFormat != null) {
            format = this.buildNumberFormat(nFormat, locale, roundingMode);
        } else {
            InstanceCurrencyFormat cFormat = dataFormat.getCurrencyFormat();
            if (cFormat != null) {
                format = this.buildCurrencyFormat(cFormat, locale, roundingMode);
            } else {
                InstancePercentFormat pFormat = dataFormat.getPercentFormat();
                if (pFormat != null) {
                    format = this.buildPercentFormat(pFormat, locale, roundingMode);
                }
            }
        }
        return format;
    }

    private Format buildNumberFormat(InstanceNumberFormat nFormat, Locale locale, int roundingMode) {
        IcuNumberFormat format = new IcuNumberFormat(locale, this.resources);
        format.setWhenMissing(nFormat.getWhenMissing());
        format.setNegativeSign(nFormat.getSign(), nFormat.isUseTrailingSign());
        format.setMaxDigits(nFormat.getMaxDigits());
        format.setMinDigits(nFormat.getMinDigits());
        format.setPaddingCharacter(nFormat.getPaddingCharacter());
        format.setScale(nFormat.getScale());
        format.setUseGrouping(nFormat.isUseGrouping());
        format.setGroupDelimiter(nFormat.getGroupDelimiter());
        format.setGroupSize(nFormat.getGroupSize());
        format.setGroupSecondarySize(nFormat.getGroupSecondarySize());
        format.setWhenNegative(nFormat.getWhenNegative());
        format.setWhenZero(nFormat.getWhenZero());
        format.setDecimalSize(nFormat.getDecimalSize());
        format.setDecimalDelimiter(nFormat.getDecimalDelimiter());
        format.setDigitShaping(nFormat.getDigitShaping());
        format.setUseScientific(nFormat.isUseScientific());
        format.setExponentSize(nFormat.getExponentSize());
        format.setExponentSymbol(nFormat.getExponentSymbol());
        format.setRoundingMode(roundingMode);
        return format;
    }

    private Format buildCurrencyFormat(InstanceCurrencyFormat cFormat, Locale locale, int roundingMode) {
        String currencyCode = cFormat.getCurrencyCode();
        String currencySymbol = cFormat.getCurrencySymbol();
        IcuCurrencyFormat format = currencyCode != null && "CHF".equalsIgnoreCase(currencyCode) || currencySymbol != null && this.resources.getSymbolForCurrencyCode("CHF").equalsIgnoreCase(currencySymbol) ? new IcuChfCurrencyFormat(locale, this.resources) : new IcuCurrencyFormat(locale, this.resources);
        format.setWhenMissing(cFormat.getWhenMissing());
        format.setMaxDigits(cFormat.getMaxDigits());
        format.setMinDigits(cFormat.getMinDigits());
        format.setPaddingCharacter(cFormat.getPaddingCharacter());
        format.setScale(cFormat.getScale());
        format.setUseGrouping(cFormat.isUseGrouping());
        format.setGroupDelimiter(cFormat.getGroupDelimiter());
        format.setGroupSize(cFormat.getGroupSize());
        format.setGroupSecondarySize(cFormat.getGroupSecondarySize());
        format.setWhenNegative(cFormat.getWhenNegative());
        format.setWhenZero(cFormat.getWhenZero());
        format.setDigitShaping(cFormat.getDigitShaping());
        format.setCurrencyCode(cFormat.getCurrencyCode());
        boolean useInternationSymbol = cFormat.isUseIntlSymbol() == null ? Boolean.FALSE : cFormat.isUseIntlSymbol();
        if (useInternationSymbol) {
            format.setCurrency(cFormat.getSign(), cFormat.isUseTrailingSign(), cFormat.getIntlCurrencySymbol(), cFormat.isUseTrailingSymbol());
        } else {
            format.setCurrency(cFormat.getSign(), cFormat.isUseTrailingSign(), cFormat.getCurrencySymbol(), cFormat.isUseTrailingSymbol());
        }
        format.setDecimalSize(cFormat.getDecimalSize());
        format.setDecimalDelimiter(cFormat.getDecimalDelimiter());
        format.setRoundingMode(roundingMode);
        return format;
    }

    private Format buildPercentFormat(InstancePercentFormat pFormat, Locale locale, int roundingMode) {
        IcuPercentFormat format = new IcuPercentFormat(locale, this.resources);
        format.setWhenMissing(pFormat.getWhenMissing());
        format.setMaxDigits(pFormat.getMaxDigits());
        format.setMinDigits(pFormat.getMinDigits());
        format.setPaddingCharacter(pFormat.getPaddingCharacter());
        format.setScale(pFormat.getScale());
        format.setUseGrouping(pFormat.isUseGrouping());
        format.setGroupDelimiter(pFormat.getGroupDelimiter());
        format.setGroupSize(pFormat.getGroupSize());
        format.setGroupSecondarySize(pFormat.getGroupSecondarySize());
        format.setWhenNegative(pFormat.getWhenNegative());
        format.setWhenZero(pFormat.getWhenZero());
        format.setDecimalSize(pFormat.getDecimalSize());
        format.setDecimalDelimiter(pFormat.getDecimalDelimiter());
        format.setDigitShaping(pFormat.getDigitShaping());
        format.setScale(pFormat.getPercentScale() != null ? Short.valueOf(pFormat.getPercentScale().shortValue()) : null);
        format.setPercentFormat(pFormat.getSign(), pFormat.isUseTrailingSign(), pFormat.getPercentSymbol());
        format.setRoundingMode(roundingMode);
        return format;
    }
}

