/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.instance._1;

import com.ibm.ba.vis.adapter.DataSet;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.ba.vis.service.instance.DataSetFormatter;
import com.ibm.ba.vis.service.instance.Instance;
import com.ibm.ba.vis.service.instance.InstanceValueField;
import com.ibm.ba.vis.service.instance._1.ChartInstanceDataFormatProxy;
import com.ibm.ba.vis.service.instance._1.ChartInstanceValueFieldProxy;
import com.ibm.ba.vis.service.instance._1.DataSetInstanceProxy;
import com.ibm.xmlns.prod.ba.visbundle.chartinstance._1.ChartInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ChartInstanceProxy
implements Instance {
    private final ChartInstance instance;

    public ChartInstanceProxy(ChartInstance instance) {
        this.instance = instance;
    }

    @Override
    public String getBundleId() {
        return this.instance.getType();
    }

    @Override
    public Map<String, DataSet> getData() {
        HashMap<String, DataSet> data = new HashMap<String, DataSet>();
        ChartInstance.DataSetInstances dataSets = this.instance.getDataSetInstances();
        if (dataSets != null) {
            List dataSetInstances = dataSets.getDataSetInstance();
            for (ChartInstance.DataSetInstances.DataSetInstance dataSetInstance : dataSetInstances) {
                DataSetInstanceProxy dataSetInstanceProxy = new DataSetInstanceProxy(dataSetInstance);
                data.put(dataSetInstance.getName(), dataSetInstanceProxy);
            }
        }
        return data;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ChartInstance.ChartPropertyValues cpv = this.instance.getChartPropertyValues();
        if (cpv != null) {
            List values = cpv.getChartPropertyValue();
            for (ChartInstance.ChartPropertyValues.ChartPropertyValue value : values) {
                properties.put(value.getName(), value.getValue());
            }
        }
        return properties;
    }

    @Override
    public Formatter getFormatter() {
        HashMap<String, InstanceValueField> fields = new HashMap<String, InstanceValueField>();
        ChartInstance.DataSetInstances dataSets = this.instance.getDataSetInstances();
        if (dataSets != null) {
            List dataSetInstances = dataSets.getDataSetInstance();
            for (ChartInstance.DataSetInstances.DataSetInstance dataSetInstance : dataSetInstances) {
                ChartInstance.DataSetInstances.DataSetInstance.DataSetFields dataSetFields = dataSetInstance.getDataSetFields();
                if (dataSetFields == null) continue;
                List oList = dataSetFields.getCategoryFieldOrValueField();
                for (Object o : oList) {
                    if (!(o instanceof ChartInstance.DataSetInstances.DataSetInstance.DataSetFields.ValueField)) continue;
                    ChartInstance.DataSetInstances.DataSetInstance.DataSetFields.ValueField field = (ChartInstance.DataSetInstances.DataSetInstance.DataSetFields.ValueField)o;
                    ChartInstanceValueFieldProxy fieldProxy = new ChartInstanceValueFieldProxy(field);
                    fields.put(field.getName(), fieldProxy);
                }
            }
        }
        ChartInstanceDataFormatProxy formatProxy = new ChartInstanceDataFormatProxy(this.instance.getDataFormat());
        return new DataSetFormatter(formatProxy, fields, this.getInstanceLocale());
    }

    @Override
    public Locale getInstanceLocale() {
        return Locale.getDefault();
    }
}

