/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.instance.format;

import com.cognos.i18n.ToolkitResources;
import com.ibm.ba.vis.service.instance.format.I18NResources;
import com.ibm.ba.vis.service.instance.format.IcuDecimalFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Currency;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class IcuCurrencyFormat
extends IcuDecimalFormat {
    public IcuCurrencyFormat(Locale locale, I18NResources resources) {
        super((DecimalFormat)NumberFormat.getCurrencyInstance((Locale)locale), resources);
    }

    public void setCurrency(String sign, Boolean useTrailingSign, String currencySymbol, Boolean useTrailingSymbol) {
        DecimalFormatSymbols symbols = this.getFormat().getDecimalFormatSymbols();
        if (currencySymbol == null || currencySymbol.length() <= 0) {
            currencySymbol = symbols.getCurrencySymbol();
        }
        if (currencySymbol == null || currencySymbol.length() <= 0 || currencySymbol.equals("\u00a4")) {
            String lcid = ToolkitResources.getLCIDForLocale((String)symbols.getLocale().getLanguage());
            String currencyCode = ToolkitResources.getISOCurrencyCodeForLCID((String)lcid);
            symbols.setCurrency(Currency.getInstance((String)currencyCode));
            currencySymbol = Currency.getInstance((String)currencyCode).getSymbol();
        }
        Boolean bl = useTrailingSign = useTrailingSign == null ? Boolean.FALSE : useTrailingSign;
        if (useTrailingSymbol == null) {
            NumberFormat nf = NumberFormat.getCurrencyInstance((Locale)symbols.getLocale());
            useTrailingSymbol = nf.format(0L).startsWith("0");
        }
        this.setNegativeFormat(sign, useTrailingSign, currencySymbol, useTrailingSymbol);
        this.setPositiveFormat(currencySymbol, useTrailingSymbol);
    }

    @Override
    public void setDecimalDelimiter(String decimalDelimiter) {
        if (decimalDelimiter != null) {
            DecimalFormatSymbols formatSymbols = this.getFormat().getDecimalFormatSymbols();
            formatSymbols.setMonetaryDecimalSeparator(decimalDelimiter.charAt(0));
            this.getFormat().setDecimalFormatSymbols(formatSymbols);
        }
    }

    @Override
    public void setGroupDelimiter(String groupDelimiter) {
        if (groupDelimiter != null) {
            DecimalFormatSymbols formatSymbols = this.getFormat().getDecimalFormatSymbols();
            formatSymbols.setMonetaryGroupingSeparator(groupDelimiter.charAt(0));
            this.getFormat().setDecimalFormatSymbols(formatSymbols);
        }
    }

    private void setNegativeFormat(String sign, Boolean useTrailingSign, String currencySymbol, Boolean useTrailingSymbol) {
        String prefix = this.getFormat().getNegativePrefix();
        String suffix = this.getFormat().getNegativeSuffix();
        if (sign != null) {
            if ("()".equals(sign)) {
                if (useTrailingSymbol.booleanValue()) {
                    prefix = "(";
                    suffix = currencySymbol + ")";
                } else {
                    prefix = "(" + currencySymbol;
                    suffix = ")";
                }
            } else if (useTrailingSign.booleanValue() && useTrailingSymbol.booleanValue()) {
                prefix = "";
                suffix = currencySymbol + sign;
            } else if (!useTrailingSign.booleanValue() && !useTrailingSymbol.booleanValue()) {
                prefix = sign + currencySymbol;
                suffix = "";
            } else if (useTrailingSign.booleanValue() && !useTrailingSymbol.booleanValue()) {
                prefix = currencySymbol;
                suffix = sign;
            } else {
                prefix = sign;
                suffix = currencySymbol;
            }
        } else if (useTrailingSymbol.booleanValue()) {
            prefix = StringUtils.substringBefore((String)prefix, (String)currencySymbol);
            suffix = currencySymbol + suffix;
        }
        this.getFormat().setNegativePrefix(prefix);
        this.getFormat().setNegativeSuffix(suffix);
    }

    private void setPositiveFormat(String currencySymbol, Boolean useTrailingSymbol) {
        if (useTrailingSymbol.booleanValue()) {
            this.getFormat().setPositivePrefix("");
            this.getFormat().setPositiveSuffix(currencySymbol);
        } else {
            this.getFormat().setPositivePrefix(currencySymbol);
            this.getFormat().setPositiveSuffix("");
        }
    }

    public void setCurrencyCode(String currencyCode) {
        if (StringUtils.isNotEmpty((String)currencyCode)) {
            DecimalFormatSymbols symbols = this.getFormat().getDecimalFormatSymbols();
            String symbol = this.getResources().getSymbolForCurrencyCode(currencyCode);
            if (symbol != null) {
                symbols.setCurrencySymbol(symbol);
                this.getFormat().setCurrency(Currency.getInstance((String)currencyCode));
            } else {
                symbols.setCurrencySymbol(currencyCode);
            }
            this.getFormat().setDecimalFormatSymbols(symbols);
        }
    }
}

