/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.service.instance.format;

import com.ibm.ba.vis.service.instance.format.Format;
import com.ibm.ba.vis.service.instance.format.I18NResources;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.ULocale;
import java.math.BigInteger;

public abstract class IcuDecimalFormat
implements Format {
    private static final Integer ZERO = 0;
    private final DecimalFormat format;
    private final I18NResources resources;
    private String whenMissing = "";
    private Short scale = 0;
    private String whenZero;

    public IcuDecimalFormat(DecimalFormat format, I18NResources resources) {
        this.format = format;
        this.resources = resources;
        this.format.setExponentSignAlwaysShown(true);
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    I18NResources getResources() {
        return this.resources;
    }

    @Override
    public String format(Number number) {
        if (number == null) {
            return this.whenMissing;
        }
        if (ZERO.equals(number) && this.whenZero != null) {
            return this.whenZero;
        }
        double pow = Math.pow(10.0, this.getScale());
        double value = number.doubleValue() * pow;
        return this.format.format(value);
    }

    @Override
    public String getPattern() {
        return this.format.toPattern();
    }

    public void setWhenMissing(String value) {
        this.whenMissing = value;
    }

    public void setDigitShaping(String digitShape) {
        if (digitShape != null) {
            DecimalFormatSymbols symbols = this.format.getDecimalFormatSymbols();
            if ("national".equals(digitShape)) {
                ULocale locale = this.format.getLocale(ULocale.ACTUAL_LOCALE);
                String id = locale.toString();
                symbols.setZeroDigit(this.resources.getZeroDigit(id).charValue());
            } else {
                symbols.setZeroDigit('0');
            }
        }
    }

    public void setDecimalSize(BigInteger decimalSize) {
        if (decimalSize != null) {
            this.format.setMinimumFractionDigits(decimalSize.intValue());
            this.format.setMaximumFractionDigits(decimalSize.intValue());
        }
    }

    public void setDecimalDelimiter(String decimalDelimiter) {
        if (decimalDelimiter != null) {
            DecimalFormatSymbols formatSymbols = this.format.getDecimalFormatSymbols();
            formatSymbols.setDecimalSeparator(decimalDelimiter.charAt(0));
            this.format.setDecimalFormatSymbols(formatSymbols);
        }
    }

    public void setMaxDigits(BigInteger maxDigits) {
        if (maxDigits != null) {
            this.format.setMaximumSignificantDigits(maxDigits.intValue());
        }
    }

    public void setMinDigits(BigInteger minDigits) {
        if (minDigits != null) {
            this.format.setMinimumSignificantDigits(minDigits.intValue());
        }
    }

    public void setPaddingCharacter(String padChar) {
        if (padChar != null) {
            this.format.setPadCharacter(padChar.charAt(0));
            this.format.setPadPosition(1);
        }
    }

    public void setScale(Short scale) {
        if (scale != null) {
            this.scale = scale;
        }
    }

    int getScale() {
        return this.scale.intValue();
    }

    public void setUseGrouping(Boolean useGrouping) {
        if (useGrouping != null) {
            this.format.setGroupingUsed(useGrouping.booleanValue());
        }
    }

    public void setGroupDelimiter(String groupDelimiter) {
        if (groupDelimiter != null) {
            DecimalFormatSymbols formatSymbols = this.format.getDecimalFormatSymbols();
            formatSymbols.setGroupingSeparator(groupDelimiter.charAt(0));
            this.format.setDecimalFormatSymbols(formatSymbols);
        }
    }

    public void setGroupSize(BigInteger groupSize) {
        if (groupSize != null) {
            this.format.setGroupingSize(groupSize.intValue());
        }
    }

    public void setGroupSecondarySize(BigInteger groupSecondarySize) {
        if (groupSecondarySize != null) {
            this.format.setSecondaryGroupingSize(groupSecondarySize.intValue());
        }
    }

    public void setWhenNegative(String negativePattern) {
        if (negativePattern != null) {
            this.format.applyLocalizedPattern(negativePattern);
        }
    }

    public void setWhenZero(String value) {
        this.whenZero = value;
    }

    public void setRoundingMode(int roundingMode) {
        if (roundingMode != 7) {
            this.format.setRoundingMode(roundingMode);
        }
    }
}

