/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.XMLInputExtensions;

import com.ibm.aurora.visCoach.core.inputs.InputManager;
import com.ibm.aurora.visCoach.core.inputs.InputScopeObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class XMLInputScopeObject
extends InputScopeObject {
    private Map<String, Node> _inputsMap = null;
    private List<String> _inputNames = null;

    public XMLInputScopeObject(InputManager inputManager) {
        super(inputManager);
        this._inputsMap = new HashMap<String, Node>();
        this._inputNames = new ArrayList<String>();
    }

    protected XMLInputScopeObject(XMLInputScopeObject iScopeObject) {
        super((InputScopeObject)iScopeObject);
        this._inputsMap = new HashMap<String, Node>(iScopeObject._inputsMap.size());
        this._inputsMap.putAll(iScopeObject._inputsMap);
        this._inputNames = new ArrayList<String>(iScopeObject._inputNames.size());
        this._inputNames.addAll(iScopeObject._inputNames);
    }

    public XMLInputScopeObject clone() {
        return new XMLInputScopeObject(this);
    }

    public void setInput(String tag, Node input) {
        String inputName = this.getInputRootName(tag);
        if (!this._inputsMap.containsKey(inputName)) {
            this._inputNames.add(inputName);
        }
        this._inputsMap.put(inputName, input);
    }

    public Node getInput(String tag) {
        String inputName = this.getInputRootName(tag);
        return this._inputsMap.get(inputName);
    }

    public List<String> getInputNames() {
        return this._inputNames;
    }

    public void moveInput(String oldTag, String newTag) {
        Node input = this._inputsMap.get(oldTag);
        this._inputsMap.remove(oldTag);
        this._inputsMap.put(newTag, input);
        for (int i = 0; i < this._inputNames.size(); ++i) {
            if (!this._inputNames.get(i).equals(oldTag)) continue;
            this._inputNames.remove(i);
            this._inputNames.add(i, newTag);
        }
    }

    private String getInputRootName(String tag) {
        String inputName = tag;
        if (inputName == null) {
            inputName = this._inputNames.get(0);
        }
        return inputName;
    }
}

