/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.utils;

import com.ibm.aurora.visCoach.core.utils.ILocalizer;
import com.ibm.aurora.visCoach.utils.MessageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Localizer
implements ILocalizer {
    private static final String _parameterStartIndicator = "(\"";
    private static final String _parameterEndIndicator = "\")";
    private static final String _parameterDelimeter = "\",\"";
    private static final String _localizedPrefix = "MSG.";
    private final String _locale;

    public Localizer(String locale) {
        this._locale = locale;
    }

    public String getLocale() {
        return this._locale;
    }

    public List<String> localize(List<String> keys) {
        ArrayList<String> result = new ArrayList<String>(keys.size());
        for (String key : keys) {
            result.add(this.localize(key));
        }
        return result;
    }

    public String localize(String input) {
        if (input != null) {
            String localizedString = input.replaceAll("(\\r|\\n|\\t)", "");
            if (localizedString.startsWith(_localizedPrefix)) {
                int parameterStartPos = localizedString.indexOf(_parameterStartIndicator);
                if (parameterStartPos != -1) {
                    String msgId = localizedString.substring(_localizedPrefix.length(), parameterStartPos);
                    localizedString = localizedString.substring(parameterStartPos + _parameterStartIndicator.length(), localizedString.lastIndexOf(_parameterEndIndicator));
                    StringTokenizer tokenizer = new StringTokenizer(localizedString, _parameterDelimeter, false);
                    Object[] parameters = new String[tokenizer.countTokens()];
                    int i = 0;
                    while (tokenizer.hasMoreElements()) {
                        parameters[i++] = tokenizer.nextToken();
                    }
                    return MessageManager.convert(msgId, this._locale, parameters);
                }
                String msgId = localizedString.substring(_localizedPrefix.length());
                return MessageManager.convert(msgId, this._locale);
            }
            return localizedString;
        }
        return null;
    }
}

