/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.visTemplate;

import com.ibm.aurora.visCoach.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.visCoach.core.rules.RulesManager;
import com.ibm.aurora.visCoach.core.rules.VisRule;
import com.ibm.aurora.visCoach.core.visTemplate.VisTemplateInputStreamParser;
import com.ibm.aurora.visCoach.core.visTemplate.VisTemplateService;
import com.ibm.aurora.visCoach.core.visTemplate.VisTemplateSourceParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class VisCoachTemplateService
extends VisTemplateService {
    private static final String RESOURCE_TEMPLATES = "/specs/specslist.txt";
    private Map<String, InputStream> _inputs = null;

    public VisCoachTemplateService(String filePath, ParameterFactory parameterFactory, RulesManager<? extends VisRule> rulesManager) {
        super(filePath, parameterFactory, rulesManager);
        this.loadBaseTemplates();
    }

    private void loadBaseTemplates() {
        this._inputs = new HashMap<String, InputStream>();
        String path = RESOURCE_TEMPLATES.substring(0, RESOURCE_TEMPLATES.lastIndexOf(47) + 1);
        BufferedReader bReader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(RESOURCE_TEMPLATES)));
        try {
            String resourceName;
            while ((resourceName = bReader.readLine()) != null) {
                InputStream resource = ((Object)((Object)this)).getClass().getResourceAsStream(path + resourceName);
                if (resource == null) continue;
                this._inputs.put(resourceName, resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected VisTemplateSourceParser getSourceParser(String name) {
        InputStream is = this._inputs.get(name);
        if (is != null) {
            return new VisTemplateInputStreamParser(is);
        }
        return super.getSourceParser(name);
    }

    public boolean containsTemplate(String id) {
        if (this._inputs.containsKey(id)) {
            return true;
        }
        return super.containsTemplate(id);
    }
}

