/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.xPathParameters;

import com.ibm.aurora.visCoach.XMLInputExtensions.XMLInputScopeObject;
import com.ibm.aurora.visCoach.core.inputs.InputScopeObject;
import com.ibm.aurora.visCoach.core.parameter.VisCoachParameterCreationException;
import com.ibm.aurora.visCoach.core.parameter.VisParentParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IMultiResolvableParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IResolutionGroupMember;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IScorableParameter;
import com.ibm.aurora.visCoach.core.rules.RulesManager;
import com.ibm.aurora.visCoach.xPathRulesExtensions.XPathVisRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class VisNodeParameter
extends VisParentParameter
implements IScorableParameter,
IScopeParameter,
IMultiResolvableParameter {
    public static final String type = "node";
    private Node _node = null;
    private float _score = 0.0f;
    private boolean _isMultiVariable = false;
    private String _resolutionGroupTag;
    protected final XPathVisRule _rule;
    private boolean _enumerateAllPossibilities = true;

    public VisNodeParameter(String name, RulesManager<XPathVisRule> rulesManager, Map<String, String> attributes) throws VisCoachParameterCreationException {
        super(name);
        String ruleName = this.getAttribute("rule", attributes);
        if (ruleName != null) {
            this._rule = (XPathVisRule)rulesManager.getRule(ruleName);
            this._isMultiVariable = "true".equals(this.getAttribute("allRemaining", attributes));
            this._enumerateAllPossibilities = !"false".equals(this.getAttribute("enumerateVariations", attributes));
            String groupName = this.getAttribute("group", attributes);
            if (groupName != null) {
                this._resolutionGroupTag = groupName;
            }
        } else {
            throw new VisCoachParameterCreationException("rule attribute is missing", this.getName());
        }
    }

    public VisNodeParameter(VisNodeParameter parameter) throws VisCoachParameterCreationException {
        super((VisParentParameter)parameter);
        this._node = parameter._node;
        this._rule = parameter._rule;
        this._score = parameter._score;
        this._resolutionGroupTag = parameter._resolutionGroupTag;
        this._isMultiVariable = parameter._isMultiVariable;
        this._enumerateAllPossibilities = parameter._enumerateAllPossibilities;
    }

    public VisNodeParameter(VisNodeParameter parameter, boolean shallow) throws VisCoachParameterCreationException {
        super((VisParentParameter)parameter, shallow);
        this._node = parameter._node;
        this._rule = parameter._rule;
        this._score = parameter._score;
        this._resolutionGroupTag = parameter._resolutionGroupTag;
        this._isMultiVariable = parameter._isMultiVariable;
        this._enumerateAllPossibilities = parameter._enumerateAllPossibilities;
    }

    public float getScore() {
        return this._score;
    }

    public String getScoreDescription() {
        return this._rule.getDescription();
    }

    public boolean isResolved() {
        return this._node != null;
    }

    public InputScopeObject getScope(InputScopeObject outerScope) {
        if (XMLInputScopeObject.class.isInstance(outerScope)) {
            XMLInputScopeObject newScope = ((XMLInputScopeObject)outerScope).clone();
            newScope.setInput(this._rule.getInputRootName(), this._node);
            return newScope;
        }
        return null;
    }

    public boolean allowsMultipleVariationsAtOnce() {
        return this._isMultiVariable;
    }

    protected void setAllowsMultipleVariationsAtOnce(boolean allowsMultipleVariationsAtOnce) {
        this._isMultiVariable = allowsMultipleVariationsAtOnce;
    }

    public List<InputScopeObject> resolvePossibleVariations(InputScopeObject scopeList) {
        if (XMLInputScopeObject.class.isInstance(scopeList)) {
            String inputRootName = this._rule.getInputRootName();
            Node scope = ((XMLInputScopeObject)scopeList).getInput(inputRootName);
            ArrayList<InputScopeObject> possibleVariations = new ArrayList<InputScopeObject>();
            List<Node> nodeOptions = this._rule.resolveNodeListRuleExpression(scope);
            for (Node node : nodeOptions) {
                XMLInputScopeObject possibleScope = ((XMLInputScopeObject)scopeList).clone();
                possibleScope.setInput(inputRootName, node);
                possibleVariations.add(possibleScope);
            }
            return possibleVariations;
        }
        return null;
    }

    public void resolve(InputScopeObject scopeList) {
        if (XMLInputScopeObject.class.isInstance(scopeList)) {
            Node scope = ((XMLInputScopeObject)scopeList).getInput(this._rule.getInputRootName());
            this.resolveNode(scope);
            this._score = this._rule.getScore(scopeList);
        }
    }

    protected void resolveNode(Node scope) {
        this._node = scope;
    }

    public String getResolutionGroupName() {
        return this._resolutionGroupTag;
    }

    public void setToResolutionGroup(IResolutionGroupMember resolutionGroupParameter) {
        this._resolutionGroupTag = resolutionGroupParameter.getResolutionGroupName();
    }

    public boolean allowsEnumerateAllPossiblities() {
        return this._enumerateAllPossibilities;
    }

    public boolean validateMatchesAttributes(Map<String, String> attributes) {
        String ruleName = this.getAttribute("rule", attributes);
        if (ruleName != null && !this._rule.getId().equals(ruleName)) {
            return false;
        }
        String allRemaining = this.getAttribute("allRemaining", attributes);
        if (allRemaining != null && this._isMultiVariable != "true".equals(allRemaining)) {
            return false;
        }
        String groupName = this.getAttribute("group", attributes);
        if (groupName != null && !groupName.equals(this._resolutionGroupTag)) {
            return false;
        }
        String enumerateAllVariations = this.getAttribute("enumerateVariations", attributes);
        if (enumerateAllVariations != null && !"false".equals(enumerateAllVariations) != this._enumerateAllPossibilities) {
            return false;
        }
        return super.validateMatchesAttributes(attributes);
    }
}

