/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.xPathParameters;

import com.ibm.aurora.visCoach.XMLInputExtensions.XMLInputScopeObject;
import com.ibm.aurora.visCoach.core.inputs.InputScopeObject;
import com.ibm.aurora.visCoach.core.parameter.VisCoachParameterCreationException;
import com.ibm.aurora.visCoach.core.parameter.VisParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IScorableParameter;
import com.ibm.aurora.visCoach.core.rules.RulesManager;
import com.ibm.aurora.visCoach.xPathRulesExtensions.XPathVisRule;
import java.util.Map;

public class VisScoreParameter
extends VisParameter
implements IScorableParameter {
    public static final String type = "score";
    private float _score = 0.0f;
    private float _weight = 0.0f;
    private boolean _hasWeight = false;
    private boolean _resolved = false;
    protected final XPathVisRule _rule;

    public VisScoreParameter(String name, RulesManager<XPathVisRule> rulesManager, Map<String, String> attributes) throws VisCoachParameterCreationException {
        super(name);
        String ruleName = this.getAttribute("rule", attributes);
        if (ruleName != null) {
            this._rule = (XPathVisRule)rulesManager.getRule(ruleName);
            String weight = this.getAttribute("weight", attributes);
            if (weight != null) {
                this._hasWeight = true;
                this._weight = Float.parseFloat(weight);
            }
        } else {
            throw new VisCoachParameterCreationException("rule attribute is missing", this.getName());
        }
    }

    public VisScoreParameter(VisScoreParameter parameter) {
        super((VisParameter)parameter);
        this._score = parameter._score;
        this._rule = parameter._rule;
        this._resolved = parameter._resolved;
        this._weight = parameter._weight;
        this._hasWeight = parameter._hasWeight;
    }

    public float getScore() {
        return this._score;
    }

    public String getScoreDescription() {
        return this._rule.getDescription();
    }

    public void resolve(InputScopeObject scopeList) {
        if (XMLInputScopeObject.class.isInstance(scopeList)) {
            this._score = this._hasWeight ? this._rule.getScore(scopeList, this._weight) : this._rule.getScore(scopeList);
            this._resolved = true;
        }
    }

    public boolean isResolved() {
        return this._resolved;
    }

    public boolean validateMatchesAttributes(Map<String, String> attributes) {
        String ruleName = this.getAttribute("rule", attributes);
        if (ruleName != null && !this._rule.getId().equals(ruleName)) {
            return false;
        }
        String weight = this.getAttribute("weight", attributes);
        if (weight != null && Float.parseFloat(weight) != this._weight) {
            return false;
        }
        return super.validateMatchesAttributes(attributes);
    }
}

