/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.xPathParameters;

import com.ibm.aurora.visCoach.XMLInputExtensions.XMLInputScopeObject;
import com.ibm.aurora.visCoach.core.inputs.InputScopeObject;
import com.ibm.aurora.visCoach.core.parameter.VisCoachParameterCreationException;
import com.ibm.aurora.visCoach.core.parameter.VisValueParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IResolvableParameter;
import com.ibm.aurora.visCoach.core.rules.RulesManager;
import com.ibm.aurora.visCoach.xPathRulesExtensions.XPathVisRule;
import java.util.Map;
import org.w3c.dom.Node;

public abstract class VisXPathValueParameter
extends VisValueParameter
implements IResolvableParameter {
    protected final XPathVisRule _rule;
    protected boolean _resolved = false;
    private boolean _valueResolved = false;
    private Node _scopedNode = null;

    public VisXPathValueParameter(String name, RulesManager<XPathVisRule> rulesManager, Map<String, String> attributes, boolean ruleRequired) throws VisCoachParameterCreationException {
        super(name);
        String ruleName = this.getAttribute("rule", attributes);
        if (ruleName != null) {
            this._rule = (XPathVisRule)rulesManager.getRule(ruleName);
        } else {
            this._rule = null;
            if (ruleRequired) {
                throw new VisCoachParameterCreationException("rule attribute is missing", this.getName());
            }
        }
    }

    public VisXPathValueParameter(VisXPathValueParameter parameter) {
        super((VisValueParameter)parameter);
        this._rule = parameter._rule;
        this._resolved = parameter._resolved;
        this._valueResolved = parameter._valueResolved;
        this._scopedNode = parameter._scopedNode;
    }

    public final void resolve(InputScopeObject scopeList) {
        if (XMLInputScopeObject.class.isInstance(scopeList)) {
            if (this._rule != null) {
                this._scopedNode = ((XMLInputScopeObject)scopeList).getInput(this._rule.getInputRootName());
            }
            this.setResolved();
        }
    }

    protected void generateValue() {
        if (!this._valueResolved) {
            this.resolveNode(this._scopedNode);
            this._valueResolved = true;
        }
    }

    protected abstract void resolveNode(Node var1);

    public boolean isResolved() {
        return this._resolved;
    }

    private void setResolved() {
        this._resolved = true;
    }

    public boolean validateMatchesAttributes(Map<String, String> attributes) {
        String ruleName = this.getAttribute("rule", attributes);
        if (ruleName != null && !this._rule.getId().equals(ruleName)) {
            return false;
        }
        return super.validateMatchesAttributes(attributes);
    }
}

