/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.xPathRulesExtensions;

import com.ibm.aurora.visCoach.XMLInputExtensions.XMLInputManager;
import com.ibm.aurora.visCoach.XMLInputExtensions.XMLInputScopeObject;
import com.ibm.aurora.visCoach.core.inputs.InputManager;
import com.ibm.aurora.visCoach.core.inputs.InputScopeObject;
import com.ibm.aurora.visCoach.core.rules.VisRule;
import com.ibm.aurora.visCoach.core.utils.xmlHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathVisRule
extends VisRule {
    private XPathExpression _oExpression = null;
    private XPathExpression _oScoreExpression = null;
    private XPathExpression _oNodeIdxpression = null;
    private String _sInputRoot = null;

    public XPathVisRule(String id) {
        super(id);
    }

    public XPathVisRule(XPathVisRule visRule) {
        super((VisRule)visRule);
        this._oExpression = visRule._oExpression;
        this._oScoreExpression = visRule._oScoreExpression;
        this._sInputRoot = visRule._sInputRoot;
    }

    public void setRuleExpression(XPath xpath, String ruleExpression) throws XPathExpressionException {
        if (null != ruleExpression) {
            this._oExpression = xpath.compile(ruleExpression);
        }
    }

    public void setScoreExpression(XPath xpath, String scoreExpression) throws XPathExpressionException {
        if (null != scoreExpression) {
            this._oScoreExpression = xpath.compile(scoreExpression);
        }
    }

    public void setNodeIdentifierExpression(XPath xpath, String nodeExpression) throws XPathExpressionException {
        if (null != nodeExpression) {
            this._oNodeIdxpression = xpath.compile(nodeExpression);
        }
    }

    public void setWeight(float fWeight) {
        super.setWeight(fWeight);
        this.setHasScore(true);
    }

    public String getInputRootName() {
        return this._sInputRoot;
    }

    public void setInputRootName(String inputRoot) {
        this._sInputRoot = inputRoot;
    }

    public boolean isResolvable(InputManager inputs) {
        if (XMLInputManager.class.isInstance(inputs)) {
            return this.isResolvable(((XMLInputManager)inputs).getRootScope());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResolvable(InputScopeObject scopeObj) {
        if (XMLInputScopeObject.class.isInstance(scopeObj)) {
            Node scope = ((XMLInputScopeObject)scopeObj).getInput(this.getInputRootName());
            try {
                XPathExpression xPathExpression = this._oExpression;
                synchronized (xPathExpression) {
                    return (Boolean)this._oExpression.evaluate(scope, XPathConstants.BOOLEAN);
                }
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public float getScore(InputManager inputs) {
        if (XMLInputManager.class.isInstance(inputs)) {
            return this.getScore(((XMLInputManager)inputs).getRootScope());
        }
        return 0.0f;
    }

    public float getScore(InputScopeObject scopeObj) {
        return this.getScore(scopeObj, this.getWeight(), this.hasWeight());
    }

    public float getScore(InputScopeObject scopeObj, float weight) {
        return this.getScore(scopeObj, weight, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getScore(InputScopeObject scopeObj, float weight, boolean hasWeight) {
        if (this.isResolvable(scopeObj)) {
            Node scope = ((XMLInputScopeObject)scopeObj).getInput(this.getInputRootName());
            if (this._oScoreExpression != null) {
                try {
                    float score;
                    XPathExpression xPathExpression = this._oScoreExpression;
                    synchronized (xPathExpression) {
                        score = ((Double)this._oScoreExpression.evaluate(scope, XPathConstants.NUMBER)).floatValue();
                    }
                    if (hasWeight) {
                        score *= weight;
                    }
                    return score;
                }
                catch (XPathExpressionException e) {
                    e.printStackTrace();
                }
            }
        }
        return 0.0f;
    }

    public boolean resolveBooleanRuleExpression(Node node) {
        return xmlHelper.resolveXPathBoolean((Node)node, (XPathExpression)this._oExpression);
    }

    public float resolveNumberRuleExpression(Node node) {
        return xmlHelper.resolveXPathNumber((Node)node, (XPathExpression)this._oExpression);
    }

    public Node resolveNodeRuleExpression(Node node) {
        return xmlHelper.resolveNodeXpath((Node)node, (XPathExpression)this._oExpression);
    }

    public String resolveStringRuleExpression(Node node) {
        return xmlHelper.resolveXPathString((Node)node, (XPathExpression)this._oExpression);
    }

    public List<Node> resolveNodeListRuleExpression(Node node) {
        NodeList results = xmlHelper.resolveNodeListXpath((Node)node, (XPathExpression)this._oExpression);
        ArrayList<Node> orderedResults = new ArrayList<Node>();
        for (int i = 0; i < results.getLength(); ++i) {
            orderedResults.add(results.item(i));
        }
        if (this._oNodeIdxpression != null) {
            NodeComparator nodeComparator = new NodeComparator(this._oNodeIdxpression);
            Collections.sort(orderedResults, nodeComparator);
        }
        return orderedResults;
    }

    private class NodeComparator
    implements Comparator<Node> {
        private XPathExpression _oSortExpression = null;

        public NodeComparator(XPathExpression sortExpression) {
            this._oSortExpression = sortExpression;
        }

        @Override
        public int compare(Node n1, Node n2) {
            String n1tag = xmlHelper.resolveXPathString((Node)n1, (XPathExpression)this._oSortExpression);
            String n2tag = xmlHelper.resolveXPathString((Node)n2, (XPathExpression)this._oSortExpression);
            return n1tag.compareTo(n2tag);
        }
    }
}

