/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core;

import com.ibm.aurora.visCoach.core.IVariationsInitializationHandle;
import com.ibm.aurora.visCoach.core.TemplateGroupRec;
import com.ibm.aurora.visCoach.core.VisCoachException;
import com.ibm.aurora.visCoach.core.inputs.InputManager;
import com.ibm.aurora.visCoach.core.logging.DefaultDebugLogger;
import com.ibm.aurora.visCoach.core.logging.IDebugLogger;
import com.ibm.aurora.visCoach.core.output.IVariationMatchRecFactory;
import com.ibm.aurora.visCoach.core.output.OutputManager;
import com.ibm.aurora.visCoach.core.output.VariationGroupRec;
import com.ibm.aurora.visCoach.core.output.templateMatchRec;
import com.ibm.aurora.visCoach.core.output.variationMatchRec;
import com.ibm.aurora.visCoach.core.parameter.VisParentParameter;
import com.ibm.aurora.visCoach.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.visCoach.core.parameter.parameterFactory.VisCoachCoreParameterRegistrationHandler;
import com.ibm.aurora.visCoach.core.rules.RulesManager;
import com.ibm.aurora.visCoach.core.rules.VisRule;
import com.ibm.aurora.visCoach.core.score.ScoreManager;
import com.ibm.aurora.visCoach.core.score.ScoreRec;
import com.ibm.aurora.visCoach.core.utils.ILocalizer;
import com.ibm.aurora.visCoach.core.variationengine.VariationManager;
import com.ibm.aurora.visCoach.core.visTemplate.VisTemplate;
import com.ibm.aurora.visCoach.core.visTemplate.VisTemplateService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VisCoachCore {
    private VisTemplateService _templatesService = null;
    private final RulesManager<? extends VisRule> _rulesManager;
    private final ScoreManager _scoreManager;
    private final IDebugLogger _debugLogger;
    private final ParameterFactory _parameterFactory;
    private boolean bHideZeroScoreOrLower;

    public VisCoachCore(RulesManager<? extends VisRule> rulesManager) {
        this(rulesManager, null);
        this.bHideZeroScoreOrLower = false;
    }

    public VisCoachCore(RulesManager<? extends VisRule> rulesManager, IDebugLogger debugLogger) {
        this._rulesManager = rulesManager;
        this._scoreManager = new ScoreManager(this._rulesManager);
        this._debugLogger = debugLogger == null ? new DefaultDebugLogger() : debugLogger;
        this._parameterFactory = new ParameterFactory();
        new VisCoachCoreParameterRegistrationHandler().register(this._parameterFactory);
        this.bHideZeroScoreOrLower = false;
    }

    public void setTemplateService(VisTemplateService templateService) {
        this._templatesService = templateService;
    }

    public ParameterFactory getParameterFactory() {
        return this._parameterFactory;
    }

    public IVariationsInitializationHandle initializeFromInput(InputManager inputManager) {
        this._debugLogger.writeLine("Initializing Inputs");
        return new VariationManager(this._parameterFactory, inputManager);
    }

    public List<templateMatchRec> getTemplateMatches(IVariationsInitializationHandle handle, ILocalizer localizer) {
        this._debugLogger.writeLine("Obtaining Template Matches for locale ");
        ArrayList<templateMatchRec> templateMatches = new ArrayList<templateMatchRec>();
        Set<String> templateIds = this._rulesManager.getTemplateIds();
        if (templateIds != null) {
            for (String templateId : templateIds) {
                VisTemplate template = null;
                try {
                    template = this._templatesService.getTemplateById(templateId);
                    if (template == null) continue;
                    this._debugLogger.writeLine("Validating Template (" + template.getId() + ")");
                    boolean bResult = this._scoreManager.validateTemplate(handle.getInputManager(), template.getId());
                    if (bResult && template.isResolvable()) {
                        ScoreRec scoreRec = this._scoreManager.scoreTemplate(handle.getInputManager(), template.getId());
                        if (!this.bHideZeroScoreOrLower || scoreRec.score > 0.0f) {
                            templateMatchRec result = new templateMatchRec();
                            result.templateId = template.getId();
                            result.score = scoreRec.score;
                            result.setProperties(this._rulesManager.getTemplateProperties(template.getId()));
                            result.scoreDescriptions = localizer.localize(scoreRec.descriptions);
                            templateMatches.add(result);
                            this._debugLogger.writeLine("Template (" + template.getId() + ") Valid with Score: " + scoreRec.score);
                            continue;
                        }
                        this._debugLogger.writeLine("Template (" + template.getId() + ") Skipped with Score: " + scoreRec.score);
                        continue;
                    }
                    this._debugLogger.writeLine("Template (" + template.getId() + ") Invalid");
                }
                catch (VisCoachException e) {
                    e.printStackTrace();
                    this._debugLogger.writeLine("Exception in template(" + template.getId() + "): " + e.getMessage());
                }
            }
            this._debugLogger.writeLine("Sorting Templates");
            Collections.sort(templateMatches);
            this._debugLogger.writeLine("Tempaltes Obtained\n");
        }
        return templateMatches;
    }

    public List<TemplateGroupRec> getRankedTemplateGroups(IVariationsInitializationHandle handle, ILocalizer localizer) {
        List<templateMatchRec> templateMatches = this.getTemplateMatches(handle, localizer);
        ArrayList<TemplateGroupRec> groupRecs = new ArrayList<TemplateGroupRec>();
        HashSet<String> groupsSet = new HashSet<String>();
        for (templateMatchRec templateMatch : templateMatches) {
            String templateGroupName = templateMatch.getProperty("group");
            if (templateGroupName == null || groupsSet.contains(templateGroupName)) continue;
            TemplateGroupRec groupRec = new TemplateGroupRec(templateGroupName, templateMatch, this.localizeMapValues(this._rulesManager.getGroupAttributes(templateGroupName), localizer));
            groupRecs.add(groupRec);
            groupsSet.add(templateGroupName);
        }
        return groupRecs;
    }

    public <VMR extends variationMatchRec> List<VMR> getTemplateVariations(IVariationsInitializationHandle handle, OutputManager outputManager, String templateId, IVariationMatchRecFactory<VMR> variationMatchRecFactory, ILocalizer localizer) throws VisCoachException {
        this._debugLogger.writeLine("Obtaining Template (" + templateId + ") Variations");
        ArrayList<VMR> variationMatches = new ArrayList<VMR>();
        VisTemplate template = this._templatesService.getTemplateById(templateId);
        ScoreRec templateScoreRec = this._scoreManager.scoreTemplate(handle.getInputManager(), templateId);
        if (template != null) {
            List<String> variationKeys = this.getVariationManagerFromHandle(handle).getVariationKeys(template);
            for (String key : variationKeys) {
                if (!"false".equals(this.resolveInfoParam(handle, outputManager, templateId, key, "valid", localizer))) {
                    VisParentParameter parameterTree = this.getVariationManagerFromHandle(handle).resolveVariation(key, template);
                    if (template.validateVariation(parameterTree)) {
                        ScoreRec scoreRec = this._scoreManager.scoreVariation(handle.getInputManager(), parameterTree);
                        if (!this.bHideZeroScoreOrLower || scoreRec.score > 0.0f) {
                            VMR result = variationMatchRecFactory.createVariationMatchRec(key);
                            ((variationMatchRec)result).templateId = templateId;
                            ((variationMatchRec)result).score = scoreRec.score;
                            ((templateMatchRec)result).setProperties(this._rulesManager.getTemplateProperties(template.getId()));
                            ((variationMatchRec)result).scoreDescriptions = localizer.localize(templateScoreRec.descriptions);
                            ((variationMatchRec)result).scoreDescriptions.addAll(localizer.localize(scoreRec.descriptions));
                            variationMatches.add(result);
                            this._debugLogger.writeLine("Variation (" + key + ") Score: " + scoreRec.score);
                            continue;
                        }
                        this._debugLogger.writeLine("Variation (" + key + ") Skipped! Score: " + scoreRec.score);
                        continue;
                    }
                    this._debugLogger.writeLine("Variation (" + key + ") Skipped! failed validation");
                    continue;
                }
                this._debugLogger.writeLine("Variation (" + key + ") Not Valid, Skipping!");
            }
            this._debugLogger.writeLine("Sorting Variations");
            Collections.sort(variationMatches);
        }
        this._debugLogger.writeLine("Variations Obtained\n");
        return variationMatches;
    }

    public <VMR extends variationMatchRec> List<VMR> getAllVariations(IVariationsInitializationHandle handle, OutputManager outputManager, IVariationMatchRecFactory<VMR> variationMatchRecFactory, ILocalizer localizer) throws VisCoachException {
        this._debugLogger.writeLine("Obtaining All Variations");
        ArrayList<VMR> allVariations = new ArrayList<VMR>();
        List<templateMatchRec> matchedTemplates = this.getTemplateMatches(handle, localizer);
        for (templateMatchRec tMatchRec : matchedTemplates) {
            allVariations.addAll(this.getTemplateVariations(handle, outputManager, tMatchRec.templateId, variationMatchRecFactory, localizer));
        }
        this._debugLogger.writeLine("Sorting All Variations");
        Collections.sort(allVariations);
        this._debugLogger.writeLine("All Variations Obtained\n");
        return allVariations;
    }

    public String resolveTemplate(IVariationsInitializationHandle handle, OutputManager outputManager, String templateId, String variationId) throws VisCoachException {
        this._debugLogger.writeLine("Resolving template: " + templateId + " With variation key: " + variationId);
        VisTemplate template = this._templatesService.getTemplateById(templateId);
        String resolvedtemplate = outputManager.resolveOutput(template, this.getVariationManagerFromHandle(handle).resolveVariation(variationId, template));
        this._debugLogger.writeLine("Template Resolved\n");
        return resolvedtemplate;
    }

    public <VMR extends variationMatchRec> String getBestResolvedVariation(IVariationsInitializationHandle handle, OutputManager outputManager, IVariationMatchRecFactory<VMR> variationMatchRecFactory, ILocalizer localizer) throws VisCoachException {
        this._debugLogger.writeLine("Obtaining best Variation");
        String output = null;
        List<templateMatchRec> matchedTemplates = this.getTemplateMatches(handle, localizer);
        if (!matchedTemplates.isEmpty()) {
            templateMatchRec bestTemplateMatch = matchedTemplates.get(0);
            List<VMR> matchedVariations = this.getTemplateVariations(handle, outputManager, bestTemplateMatch.templateId, variationMatchRecFactory, localizer);
            if (!matchedVariations.isEmpty()) {
                variationMatchRec bestMatchedVariation = (variationMatchRec)matchedVariations.get(0);
                output = this.resolveTemplate(handle, outputManager, bestMatchedVariation.templateId, bestMatchedVariation.variationId);
            }
        }
        return output;
    }

    public String resolveInfoParam(IVariationsInitializationHandle handle, OutputManager outputManager, String templateId, String variationId, String paramName, ILocalizer localizer) throws VisCoachException {
        this._debugLogger.writeLine("Obtaining Info (" + paramName + ") from template: " + templateId + " With variation key: " + variationId);
        VisTemplate template = this._templatesService.getTemplateById(templateId);
        String resolvedInfo = outputManager.resolveOutputInfo(template, this.getVariationManagerFromHandle(handle).resolveVariation(variationId, template), paramName);
        this._debugLogger.writeLine("Template Info Resolved\n");
        if (resolvedInfo != null) {
            return resolvedInfo.replaceAll("(\\r|\\n|\\t)", "");
        }
        return null;
    }

    public ArrayList<String> resolveInfoArrayParam(IVariationsInitializationHandle handle, OutputManager outputManager, String templateId, String variationId, String paramName, ILocalizer localizer) throws VisCoachException {
        this._debugLogger.writeLine("Obtaining Info Array (" + paramName + ") from template: " + templateId + " With variation key: " + variationId);
        VisTemplate template = this._templatesService.getTemplateById(templateId);
        ArrayList<String> resolvedValues = outputManager.resolveOutputArrayInfo(template, this.getVariationManagerFromHandle(handle).resolveVariation(variationId, template), paramName);
        this._debugLogger.writeLine("Template Info Array Resolved\n");
        return resolvedValues;
    }

    public <VMR extends variationMatchRec> List<VariationGroupRec<VMR>> getVariationsFromGroup(IVariationsInitializationHandle handle, OutputManager outputManager, String group, IVariationMatchRecFactory<VMR> variationMatchRecFactory, ILocalizer localizer) throws VisCoachException {
        ArrayList<VariationGroupRec<VMR>> variationGroupings = new ArrayList<VariationGroupRec<VMR>>();
        HashMap groupMap = new HashMap();
        List<String> templateIds = this.getTemplatesFromGroup(handle, group, localizer);
        for (String templateId : templateIds) {
            List<VMR> variations = this.getTemplateVariations(handle, outputManager, templateId, variationMatchRecFactory, localizer);
            for (variationMatchRec variationMatch : variations) {
                if ("false".equals(this.resolveInfoParam(handle, outputManager, templateId, variationMatch.variationId, "valid", localizer))) continue;
                String varationGroup = this.resolveInfoParam(handle, outputManager, templateId, variationMatch.variationId, "groupName", localizer);
                VariationGroupRec groupRec = (VariationGroupRec)groupMap.get(varationGroup);
                if (groupRec == null) {
                    groupRec = new VariationGroupRec(varationGroup, this.resolveInfoArrayParam(handle, outputManager, templateId, variationMatch.variationId, "uiInfoFields", localizer));
                    groupRec.properties.put("icon", this.resolveInfoParam(handle, outputManager, templateId, variationMatch.variationId, "icon", localizer));
                    groupRec.properties.put("title", this.resolveInfoParam(handle, outputManager, templateId, variationMatch.variationId, "title", localizer));
                    groupMap.put(varationGroup, groupRec);
                    variationGroupings.add(groupRec);
                }
                variationMatch.addFieldValues(this.resolveInfoArrayParam(handle, outputManager, templateId, variationMatch.variationId, "uiInfoValues", localizer));
                groupRec.variations.add(variationMatch);
            }
        }
        return variationGroupings;
    }

    private List<String> getTemplatesFromGroup(IVariationsInitializationHandle handle, String groupName, ILocalizer localizer) {
        List<templateMatchRec> templateMatches = this.getTemplateMatches(handle, localizer);
        ArrayList<String> templateIds = new ArrayList<String>();
        for (templateMatchRec templateMatch : templateMatches) {
            if (!templateMatch.getProperty("group").equals(groupName)) continue;
            templateIds.add(templateMatch.templateId);
        }
        return templateIds;
    }

    private VariationManager getVariationManagerFromHandle(IVariationsInitializationHandle handle) {
        return (VariationManager)handle;
    }

    protected void setHideZeroScoresOrLower(boolean hideItems) {
        this.bHideZeroScoreOrLower = hideItems;
    }

    private Map<String, String> localizeMapValues(Map<String, String> attributes, ILocalizer localizer) {
        HashMap<String, String> localizedMap = new HashMap<String, String>();
        for (String key : attributes.keySet()) {
            String value = attributes.get(key);
            localizedMap.put(key, localizer.localize(value));
        }
        return localizedMap;
    }
}

