/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.parameter;

import com.ibm.aurora.visCoach.core.parameter.VisCoachParameterCreationException;
import com.ibm.aurora.visCoach.core.parameter.VisParameter;
import com.ibm.aurora.visCoach.core.parameter.VisValueParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class VisDependentValueParameter
extends VisValueParameter {
    private final List<String> _dependentParametersNames;
    protected List<VisParameter> _dependentParameters = null;

    public VisDependentValueParameter(String name, Map<String, String> attributes) throws VisCoachParameterCreationException {
        super(name);
        String parameterNames = this.getAttribute("parameters", attributes);
        if (parameterNames == null) {
            throw new VisCoachParameterCreationException("parameters attribute is missing", this.getName());
        }
        this._dependentParametersNames = this.getDependentParametersList(parameterNames);
    }

    public VisDependentValueParameter(VisDependentValueParameter parameter) {
        super(parameter);
        this._dependentParametersNames = parameter._dependentParametersNames;
        this._dependentParameters = parameter._dependentParameters;
    }

    public List<String> getDependentParametersNames() {
        return this._dependentParametersNames;
    }

    public void setDependentParameters(List<VisParameter> dependentParameters) {
        this._dependentParameters = dependentParameters;
    }

    @Override
    public boolean validateMatchesAttributes(Map<String, String> attributes) {
        String parameterNames = this.getAttribute("parameters", attributes);
        if (parameterNames != null) {
            List<String> proposedDependentList = this.getDependentParametersList(parameterNames);
            if (proposedDependentList.size() != this._dependentParametersNames.size()) {
                return false;
            }
            for (int i = 0; i < proposedDependentList.size(); ++i) {
                if (proposedDependentList.get(i).equals(this._dependentParametersNames.get(i))) continue;
                return false;
            }
        }
        return super.validateMatchesAttributes(attributes);
    }

    private List<String> getDependentParametersList(String parameterNames) {
        ArrayList<String> dependentParameterNames = new ArrayList<String>();
        if (parameterNames != null) {
            StringTokenizer dataTokenizer = new StringTokenizer(parameterNames, ",", false);
            while (dataTokenizer.hasMoreElements()) {
                dependentParameterNames.add(dataTokenizer.nextToken());
            }
        }
        return dependentParameterNames;
    }
}

